/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.window.desktop.toolbar;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.eclipse.scout.rt.ui.swing.Activator;
import org.eclipse.scout.rt.ui.swing.window.desktop.toolbar.JNavigationWidget;
import org.eclipse.scout.rt.ui.swing.window.desktop.toolbar.NavigationWidgetButton;

public class StopRefreshButton
extends NavigationWidgetButton {
    private P_GlowThread m_glowThread;
    private Object m_glowThreadLock = new Object();
    private static final int FPS = 20;
    private static final int MS_PER_FRAME = 50;
    private static final Point GLOW_POSITION = new Point(64, -5);
    private IconName m_iconName = IconName.NONE;
    private boolean m_loading = false;
    private volatile boolean m_showGlow = false;
    private Icon[] m_stopIcon;
    private Icon[] m_glowFrames;
    private int m_glowFrame = 0;
    private int m_glowDir = 1;

    public StopRefreshButton(JComponent parent) {
        super(JNavigationWidget.ButtonName.STOP_REFRESH, parent);
    }

    void loadGlowAnimation(String iconUrl) {
        this.m_glowFrames = new Icon[10];
        int i = 0;
        while (i < 10) {
            String frameUrl = String.valueOf(iconUrl) + "_" + i;
            this.m_glowFrames[i] = Activator.getIcon(frameUrl);
            ++i;
        }
    }

    public void showRefreshIcon() {
        this.setIconName(IconName.REFRESH);
    }

    public void showStopIcon() {
        this.setIconName(IconName.STOP);
    }

    public void showNoIcon() {
        this.setIconName(IconName.NONE);
    }

    private void setIconName(IconName iconName) {
        IconName oldIconName = this.m_iconName;
        this.m_iconName = iconName;
        if (oldIconName != this.m_iconName) {
            this.repaintParent();
        }
    }

    public boolean isLoading() {
        return this.m_loading;
    }

    public void setLoading(boolean loading) {
        this.m_loading = loading;
        if (loading) {
            this.startGlow();
            this.showStopIcon();
        } else {
            this.showRefreshIcon();
            this.killGlow();
        }
    }

    private void killGlow() {
        this.m_glowThread.interrupt();
    }

    private void startGlow() {
        this.m_showGlow = true;
        this.m_glowFrame = 0;
        this.m_glowDir = 1;
        this.m_glowThread = new P_GlowThread();
        this.m_glowThread.start();
    }

    void loadStopIcon(String iconUrl) {
        this.m_stopIcon = this.loadTriStateIcon(iconUrl);
    }

    @Override
    protected void paintButton(Component c, Graphics g) {
        this.paintGlow(c, g);
        super.paintButton(c, g);
    }

    @Override
    protected void paintIcon(Component c, Graphics g) {
        if (this.m_iconName != IconName.NONE) {
            super.paintIcon(c, g);
        }
    }

    @Override
    Icon getIcon() {
        switch (this.m_iconName) {
            case STOP: {
                return this.getTriStateIcon(this.m_stopIcon, this.isEnabled());
            }
            case REFRESH: {
                return super.getIcon();
            }
        }
        return null;
    }

    private void paintGlow(Component c, Graphics g) {
        if (this.m_showGlow) {
            this.paintPressedImage(this.m_glowFrames[this.m_glowFrame], GLOW_POSITION, this.isPressed(), c, g);
        }
    }

    public IconName getIconName() {
        return this.m_iconName;
    }

    @Override
    public void buttonClicked(int button) {
        if (IconName.REFRESH == this.m_iconName) {
            this.performAction(this.getPrimaryAction());
        } else {
            this.performAction(this.getSecondaryAction());
        }
    }

    static enum IconName {
        NONE,
        STOP,
        REFRESH;

    }

    class P_GlowThread
    extends Thread {
        P_GlowThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = StopRefreshButton.this.m_glowThreadLock;
            synchronized (object) {
                boolean interrupted = false;
                while (this == StopRefreshButton.this.m_glowThread) {
                    StopRefreshButton stopRefreshButton = StopRefreshButton.this;
                    stopRefreshButton.m_glowFrame = stopRefreshButton.m_glowFrame + StopRefreshButton.this.m_glowDir;
                    if (StopRefreshButton.this.m_glowFrame == 0 || StopRefreshButton.this.m_glowFrame == StopRefreshButton.this.m_glowFrames.length - 1) {
                        StopRefreshButton stopRefreshButton2 = StopRefreshButton.this;
                        stopRefreshButton2.m_glowDir = stopRefreshButton2.m_glowDir * -1;
                    }
                    if (interrupted && StopRefreshButton.this.m_glowFrame == 0) {
                        StopRefreshButton.this.m_showGlow = false;
                        StopRefreshButton.this.m_glowThread = null;
                        return;
                    }
                    try {
                        Thread.sleep(50 + this.getSineDelayForCurrentFrame());
                    }
                    catch (InterruptedException interruptedException) {
                        interrupted = true;
                    }
                    StopRefreshButton.this.repaintParent();
                }
            }
        }

        private int getSineDelayForCurrentFrame() {
            float degreeForFrame = 90 / (StopRefreshButton.this.m_glowFrames.length - 1) * StopRefreshButton.this.m_glowFrame;
            int delayPerFrame = (int)(Math.sin(this.toRadian(degreeForFrame)) * 50.0 * 2.0);
            return delayPerFrame;
        }

        private float toRadian(float degree) {
            return (float)((double)degree * (Math.PI / 180));
        }
    }
}

