/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.window.desktop.toolbar;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SpringLayout;
import javax.swing.UIManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.navigation.INavigationHistoryService;
import org.eclipse.scout.rt.client.ui.desktop.navigation.NavigationHistoryEvent;
import org.eclipse.scout.rt.client.ui.desktop.navigation.NavigationHistoryListener;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage;
import org.eclipse.scout.rt.ui.swing.SwingPopupWorker;
import org.eclipse.scout.rt.ui.swing.basic.SwingScoutComposite;
import org.eclipse.scout.rt.ui.swing.ext.JPanelEx;
import org.eclipse.scout.rt.ui.swing.window.desktop.ProgressHandler;
import org.eclipse.scout.rt.ui.swing.window.desktop.toolbar.JNavigationWidget;
import org.eclipse.scout.rt.ui.swing.window.desktop.toolbar.JToolTabsBar;
import org.eclipse.scout.rt.ui.swing.window.desktop.toolbar.JViewTabsBar;
import org.eclipse.scout.service.SERVICES;

public class SwingScoutToolBar
extends SwingScoutComposite<IDesktop> {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwingScoutToolBar.class);
    private static final long serialVersionUID = 1L;
    private JNavigationWidget m_navigationWidget;
    private JLabel m_windowIcons;
    private static final int HEIGHT = 85;
    private int m_topLevelMenuCount;
    private JViewTabsBar m_viewTabPanel;
    private JToolTabsBar m_toolTabsPanel;
    private NavigationHistoryListener m_scoutNavListener;
    private ProgressHandler m_progressHandler;

    @Override
    protected void initializeSwing() {
        SpringLayout layout = new SpringLayout();
        this.m_topLevelMenuCount = ((IDesktop)this.getScoutObject()).getMenus().length;
        JPanelEx toolBar = new JPanelEx(layout);
        this.m_navigationWidget = new JNavigationWidget(this.getSwingEnvironment());
        toolBar.add(this.m_navigationWidget);
        layout.putConstraint("West", (Component)this.m_navigationWidget, 9, "West", (Component)toolBar);
        layout.putConstraint("North", (Component)this.m_navigationWidget, 11, "North", (Component)toolBar);
        this.m_navigationWidget.getBackButton().setPrimaryAction(new P_BackAction());
        this.m_navigationWidget.getForwardButton().setPrimaryAction(new P_ForwardAction());
        this.m_navigationWidget.getForwardButton().setSecondaryAction(new P_HistoryAction());
        this.m_progressHandler = new ProgressHandler(this.getSwingEnvironment());
        this.m_navigationWidget.getStopRefreshButton().setPrimaryAction(new P_RefreshAction());
        this.m_navigationWidget.getStopRefreshButton().setSecondaryAction(this.m_progressHandler.createStopAction());
        this.m_viewTabPanel = new JViewTabsBar(this.getSwingEnvironment());
        toolBar.add(this.m_viewTabPanel);
        layout.putConstraint("South", (Component)this.m_viewTabPanel, 0, "South", (Component)toolBar);
        layout.putConstraint("West", (Component)this.m_viewTabPanel, 0, "West", (Component)toolBar);
        this.m_toolTabsPanel = new JToolTabsBar(this.getSwingEnvironment());
        toolBar.add(this.m_toolTabsPanel);
        layout.putConstraint("East", (Component)this.m_toolTabsPanel, 0, "East", (Component)toolBar);
        layout.putConstraint("South", (Component)this.m_toolTabsPanel, 0, "South", (Component)toolBar);
        layout.putConstraint("East", (Component)this.m_viewTabPanel, 0, "West", (Component)this.m_toolTabsPanel);
        JComponent logo = this.getSwingEnvironment().createLogo();
        if (logo != null) {
            toolBar.add(logo);
            int vAlignment = UIManager.getInt("HeaderPanel.logoVerticalAlignment");
            switch (vAlignment) {
                case 0: {
                    layout.putConstraint("North", (Component)logo, this.m_viewTabPanel.getPreferredSize().height * -1, "VerticalCenter", (Component)toolBar);
                    break;
                }
                case 1: {
                    layout.putConstraint("South", (Component)logo, 0, "North", (Component)this.m_viewTabPanel);
                    break;
                }
                default: {
                    layout.putConstraint("North", (Component)logo, 0, "North", (Component)toolBar);
                }
            }
            int hAlignment = UIManager.getInt("HeaderPanel.logoHorizontalAlignment");
            if (hAlignment == 1) {
                layout.putConstraint("East", (Component)logo, 0, "East", (Component)toolBar);
            } else {
                layout.putConstraint("HorizontalCenter", (Component)logo, 0, "HorizontalCenter", (Component)toolBar);
            }
        }
        toolBar.setOpaque(true);
        toolBar.setBackground(new Color(207, 226, 239));
        toolBar.setPreferredSize(new Dimension(-1, 85));
        toolBar.setBounds(0, 0, toolBar.getWidth(), 85);
        this.setSwingField(toolBar);
        this.rebuildViewTabs();
        this.rebuildToolTabs();
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        new ClientSyncJob("add navigation listener", this.getSwingEnvironment().getScoutSession()){

            protected void runVoid(IProgressMonitor monitor) throws Throwable {
                if (SwingScoutToolBar.this.m_scoutNavListener == null) {
                    SwingScoutToolBar.this.m_scoutNavListener = new NavigationHistoryListener(){

                        public void navigationChanged(NavigationHistoryEvent e) {
                            SwingScoutToolBar.this.handleNavigationChangedFromScout();
                        }
                    };
                    ((INavigationHistoryService)SERVICES.getService(INavigationHistoryService.class)).addNavigationHistoryListener(SwingScoutToolBar.this.m_scoutNavListener);
                    SwingScoutToolBar.this.handleNavigationChangedFromScout();
                }
            }
        }.schedule();
    }

    @Override
    protected void detachScout() {
        super.detachScout();
        new ClientSyncJob("remove navigation listener", this.getSwingEnvironment().getScoutSession()){

            protected void runVoid(IProgressMonitor monitor) throws Throwable {
                if (SwingScoutToolBar.this.m_scoutNavListener != null) {
                    INavigationHistoryService nav = (INavigationHistoryService)SERVICES.getService(INavigationHistoryService.class);
                    if (nav != null) {
                        nav.removeNavigationHistoryListener(SwingScoutToolBar.this.m_scoutNavListener);
                    }
                    SwingScoutToolBar.this.m_scoutNavListener = null;
                }
            }
        }.schedule();
    }

    @Override
    protected boolean isHandleScoutPropertyChange(String name, Object newValue) {
        return false;
    }

    protected void handleNavigationBackFromSwing() {
        Runnable t = new Runnable(){

            @Override
            public void run() {
                try {
                    ((INavigationHistoryService)SERVICES.getService(INavigationHistoryService.class)).stepBackward();
                }
                catch (ProcessingException processingException) {}
            }
        };
        this.getSwingEnvironment().invokeScoutLater(t, 0L);
    }

    protected void handleNavigationForwardFromSwing() {
        Runnable t = new Runnable(){

            @Override
            public void run() {
                try {
                    ((INavigationHistoryService)SERVICES.getService(INavigationHistoryService.class)).stepForward();
                }
                catch (ProcessingException processingException) {}
            }
        };
        this.getSwingEnvironment().invokeScoutLater(t, 0L);
    }

    protected void handleNavigationMenuFromSwing() {
        Runnable t = new Runnable(){

            @Override
            public void run() {
                IMenu[] scoutMenus = ((INavigationHistoryService)SERVICES.getService(INavigationHistoryService.class)).getMenus();
                new SwingPopupWorker(SwingScoutToolBar.this.getSwingEnvironment(), SwingScoutToolBar.this.m_navigationWidget, SwingScoutToolBar.this.m_navigationWidget.getHistoryMenuLocation(), scoutMenus).enqueue();
            }
        };
        this.getSwingEnvironment().invokeScoutLater(t, 5678L);
    }

    protected void handleNavigationChangedFromScout() {
        INavigationHistoryService service = (INavigationHistoryService)SERVICES.getService(INavigationHistoryService.class);
        final boolean backEnabled = service.hasBackwardBookmarks();
        final boolean forewardEnabled = service.hasForwardBookmarks();
        final boolean menuEnabled = backEnabled || forewardEnabled;
        Runnable t = new Runnable(){

            @Override
            public void run() {
                SwingScoutToolBar.this.updateNavigationWidget(backEnabled, forewardEnabled, menuEnabled);
            }
        };
        this.getSwingEnvironment().invokeSwingLater(t);
    }

    public boolean isEmpty() {
        return this.m_topLevelMenuCount == 0;
    }

    public JComponent getSwingToolBar() {
        return this.getSwingField();
    }

    public JComponent getSwingToolTabsPanel() {
        return this.m_toolTabsPanel;
    }

    private void updateNavigationWidget(boolean backEnabled, boolean forwardEnabled, boolean menuEnabled) {
        this.m_navigationWidget.getBackButton().setEnabled(backEnabled);
        this.m_navigationWidget.getForwardButton().setEnabled(forwardEnabled);
        this.m_navigationWidget.getForwardButton().setHistoryEnabled(menuEnabled);
    }

    private void rebuildViewTabs() {
        this.m_viewTabPanel.rebuild((IDesktop)this.getScoutObject());
    }

    private void rebuildToolTabs() {
        this.m_toolTabsPanel.rebuild((IDesktop)this.getScoutObject());
    }

    public JNavigationWidget getSwingNavigationWidget() {
        return this.m_navigationWidget;
    }

    private class P_BackAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private P_BackAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingScoutToolBar.this.handleNavigationBackFromSwing();
        }
    }

    private class P_ForwardAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private P_ForwardAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingScoutToolBar.this.handleNavigationForwardFromSwing();
        }
    }

    private class P_HistoryAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private P_HistoryAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingScoutToolBar.this.handleNavigationMenuFromSwing();
        }
    }

    private class P_RefreshAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private P_RefreshAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    IPage page;
                    IOutline outline = ((IDesktop)SwingScoutToolBar.this.getScoutObject()).getOutline();
                    if (outline != null && (page = outline.getActivePage()) != null) {
                        try {
                            page.reloadPage();
                        }
                        catch (ProcessingException e) {
                            LOG.error("reloading page " + page, (Throwable)e);
                        }
                    }
                }
            };
            SwingScoutToolBar.this.getSwingEnvironment().invokeScoutLater(r, 0L);
        }
    }
}

