/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.window.desktop.toolbar;

import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.rt.ui.swing.window.desktop.ToolsViewPlaceholder;
import org.eclipse.scout.rt.ui.swing.window.desktop.toolbar.JToolTabsBar;

public class ToolsViewAndTabsBarSynchronizer {
    private final ToolsViewPlaceholder m_toolsViewPlaceholder;
    private final JToolTabsBar m_toolTabsBar;
    private final OptimisticLock m_syncLock = new OptimisticLock();

    public ToolsViewAndTabsBarSynchronizer(ToolsViewPlaceholder toolsViewPlaceholder, JToolTabsBar toolTabsBar) {
        this.m_toolsViewPlaceholder = toolsViewPlaceholder;
        this.m_toolTabsBar = toolTabsBar;
        toolTabsBar.adjustWidthToToolsView(toolsViewPlaceholder.getWidth());
        this.installListeners();
    }

    protected void reset() {
    }

    private void installListeners() {
        this.m_toolTabsBar.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                try {
                    ToolsViewAndTabsBarSynchronizer.this.m_syncLock.acquire();
                    if ("collapsed".equals(evt.getPropertyName())) {
                        boolean collapsed = (Boolean)evt.getNewValue();
                        if (collapsed) {
                            ToolsViewAndTabsBarSynchronizer.this.m_toolsViewPlaceholder.collapseView();
                        } else {
                            ToolsViewAndTabsBarSynchronizer.this.m_toolsViewPlaceholder.expandView();
                        }
                    } else if ("minimumSize".equals(evt.getPropertyName())) {
                        Dimension d = (Dimension)evt.getNewValue();
                        ToolsViewAndTabsBarSynchronizer.this.m_toolsViewPlaceholder.setMinimumWidth(d.width - 1);
                    }
                }
                finally {
                    ToolsViewAndTabsBarSynchronizer.this.m_syncLock.release();
                }
            }
        });
        this.m_toolsViewPlaceholder.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                try {
                    if (ToolsViewAndTabsBarSynchronizer.this.m_syncLock.acquire()) {
                        ToolsViewAndTabsBarSynchronizer.this.m_toolTabsBar.adjustWidthToToolsView(ToolsViewAndTabsBarSynchronizer.this.m_toolsViewPlaceholder.getWidth() + 1);
                    }
                }
                finally {
                    ToolsViewAndTabsBarSynchronizer.this.m_syncLock.release();
                }
            }
        });
    }
}

