/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.window.dialog;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.ext.BorderLayoutEx;
import org.eclipse.scout.rt.ui.swing.ext.ComponentSpyAction;
import org.eclipse.scout.rt.ui.swing.ext.JDialogEx;
import org.eclipse.scout.rt.ui.swing.focus.SwingScoutFocusTraversalPolicy;
import org.eclipse.scout.rt.ui.swing.window.DependentCloseListener;
import org.eclipse.scout.rt.ui.swing.window.ISwingScoutBoundsProvider;
import org.eclipse.scout.rt.ui.swing.window.ISwingScoutView;
import org.eclipse.scout.rt.ui.swing.window.SwingScoutViewEvent;
import org.eclipse.scout.rt.ui.swing.window.SwingScoutViewListener;
import org.eclipse.scout.rt.ui.swing.window.SwingWindowManager;

public class SwingScoutDialog
implements ISwingScoutView {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwingScoutDialog.class);
    private ISwingEnvironment m_env;
    private EventListenerList m_listenerList;
    private P_SwingScoutRootListener m_swingScoutRootListener;
    private Window m_swingParent;
    private JDialogEx m_swingDialog;
    private boolean m_opened;
    private boolean m_maximized;
    private Rectangle m_boundsBeforeMaximize;
    private ISwingScoutBoundsProvider m_boundsProvider;

    public SwingScoutDialog(ISwingEnvironment env, Window swingParent) {
        this(env, swingParent, null);
    }

    public SwingScoutDialog(ISwingEnvironment env, Window swingParent, ISwingScoutBoundsProvider provider) {
        this.m_env = env;
        this.m_boundsProvider = provider;
        while (swingParent != null && !(swingParent instanceof Dialog) && !(swingParent instanceof Frame)) {
            swingParent = SwingUtilities.getWindowAncestor(swingParent);
        }
        this.m_swingParent = swingParent;
        this.m_listenerList = new EventListenerList();
        this.m_swingDialog = this.m_swingParent instanceof Dialog ? new JDialogEx((Dialog)this.m_swingParent) : new JDialogEx((Frame)this.m_swingParent);
        JComponent contentPane = (JComponent)this.m_swingDialog.getContentPane();
        contentPane.setName("SwingScoutDialog.contentPane");
        contentPane.setLayout(new BorderLayoutEx());
        contentPane.setCursor(Cursor.getDefaultCursor());
        this.m_swingDialog.setResizable(true);
        this.m_swingDialog.setModal(true);
        this.m_swingDialog.setDefaultCloseOperation(0);
        this.m_swingDialog.addWindowListener(new P_SwingWindowListener());
        SwingUtility.installFocusCycleRoot(this.m_swingDialog, new SwingScoutFocusTraversalPolicy());
        this.m_swingDialog.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner() == null) {
                            SwingScoutDialog.this.m_swingDialog.getContentPane().transferFocus();
                        }
                    }
                });
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
            }
        });
        SwingUtility.installDevelopmentShortcuts((JComponent)this.m_swingDialog.getContentPane());
        if (this.m_swingScoutRootListener == null) {
            this.m_swingScoutRootListener = new P_SwingScoutRootListener();
            this.m_env.addPropertyChangeListener(this.m_swingScoutRootListener);
        }
        if (contentPane instanceof JComponent) {
            contentPane.getInputMap(1).put(SwingUtility.createKeystroke("shift alt F1"), "componentSpy");
            contentPane.getActionMap().put("componentSpy", new ComponentSpyAction());
        }
    }

    @Override
    public JComponent getSwingContentPane() {
        return (JComponent)this.m_swingDialog.getContentPane();
    }

    @Override
    public void addSwingScoutViewListener(SwingScoutViewListener listener) {
        this.m_listenerList.add(SwingScoutViewListener.class, (EventListener)listener);
    }

    @Override
    public void removeSwingScoutViewListener(SwingScoutViewListener listener) {
        this.m_listenerList.remove(SwingScoutViewListener.class, (EventListener)listener);
    }

    private void fireSwingScoutViewEvent(SwingScoutViewEvent e) {
        EventListener[] listeners = this.m_listenerList.getListeners(SwingScoutViewListener.class);
        if (listeners != null && listeners.length > 0) {
            int i = 0;
            while (i < listeners.length) {
                try {
                    ((SwingScoutViewListener)listeners[i]).viewChanged(e);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                ++i;
            }
        }
    }

    @Override
    public void closeView() {
        this.m_opened = false;
        if (this.m_boundsProvider != null && this.m_swingDialog != null && this.m_swingDialog.isVisible()) {
            this.m_boundsProvider.storeBounds(this.m_swingDialog.getBounds());
        }
        if (this.m_swingScoutRootListener != null) {
            this.m_env.removePropertyChangeListener(this.m_swingScoutRootListener);
            this.m_swingScoutRootListener = null;
        }
        new DependentCloseListener(this.m_swingDialog).close();
    }

    @Override
    public boolean isVisible() {
        return this.m_swingDialog != null && this.m_swingDialog.isVisible();
    }

    @Override
    public boolean isActive() {
        return this.m_swingDialog != null && this.m_swingDialog.isActive();
    }

    public void setBoundsProvider(ISwingScoutBoundsProvider boundsProvider) {
        this.m_boundsProvider = boundsProvider;
    }

    @Override
    public void openView() {
        this.m_opened = true;
        try {
            Rectangle a;
            Rectangle b;
            Rectangle c;
            if (this.m_swingDialog.isModal()) {
                SwingWindowManager.getInstance().pushModalDialog(this.m_swingDialog);
            }
            this.m_swingDialog.pack();
            this.m_swingDialog.pack();
            this.m_swingDialog.setLocationRelativeTo(this.m_swingDialog.getOwner());
            if (this.m_boundsProvider != null && (c = this.m_boundsProvider.getBounds()) != null) {
                if (c.width == 0 || c.height == 0) {
                    c.width = this.m_swingDialog.getWidth();
                    c.height = this.m_swingDialog.getHeight();
                }
                this.m_swingDialog.setBounds(c);
            }
            if (!(b = SwingUtility.validateRectangleOnScreen(a = this.m_swingDialog.getBounds(), false, true)).equals(a)) {
                this.m_swingDialog.setLocation(b.getLocation());
                this.m_swingDialog.setSize(b.getSize());
            }
            if (this.m_maximized) {
                this.setMaximized(this.m_maximized);
            }
            if (this.m_opened) {
                this.m_swingDialog.setVisible(true);
            }
        }
        finally {
            if (this.m_swingDialog.isModal()) {
                SwingWindowManager.getInstance().popModalDialog(this.m_swingDialog);
            }
        }
    }

    @Override
    public void setTitle(String s) {
        if (s == null) {
            s = "";
        }
        this.m_swingDialog.setTitle(s);
    }

    @Override
    public void setCloseEnabled(boolean b) {
    }

    @Override
    public void setMaximizeEnabled(boolean b) {
    }

    @Override
    public void setMinimizeEnabled(boolean b) {
    }

    @Override
    public void setMinimized(boolean on) {
    }

    @Override
    public void setMaximized(boolean on) {
        this.m_maximized = on;
        if (on) {
            if (this.m_boundsBeforeMaximize == null) {
                this.m_boundsBeforeMaximize = this.m_swingDialog.getBounds();
            }
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            Insets in = Toolkit.getDefaultToolkit().getScreenInsets(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration());
            Rectangle r = new Rectangle();
            if (in != null) {
                r.x = in.left;
                r.y = in.top;
                r.width = d.width - in.left - in.right;
                r.height = d.height - in.top - in.bottom;
            } else {
                r.x = 0;
                r.y = 0;
                r.width = d.width;
                r.height = d.height;
            }
            this.m_swingDialog.setBounds(r);
        } else if (this.m_boundsBeforeMaximize != null) {
            this.m_swingDialog.setBounds(this.m_boundsBeforeMaximize);
            this.m_boundsBeforeMaximize = null;
        }
    }

    @Override
    public void setName(String name) {
        this.m_swingDialog.getRootPane().setName(name);
    }

    private class P_SwingScoutRootListener
    implements PropertyChangeListener {
        private P_SwingScoutRootListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("busy")) {
                boolean busy = (Boolean)e.getNewValue();
                SwingScoutDialog.this.m_swingDialog.setWaitCursor(busy);
            }
        }
    }

    private class P_SwingWindowListener
    extends WindowAdapter {
        private P_SwingWindowListener() {
        }

        @Override
        public void windowOpened(WindowEvent e) {
            SwingWindowManager.getInstance().setActiveWindow(SwingScoutDialog.this.m_swingDialog);
            SwingScoutDialog.this.fireSwingScoutViewEvent(new SwingScoutViewEvent(SwingScoutDialog.this, 10));
        }

        @Override
        public void windowActivated(WindowEvent e) {
            SwingWindowManager.getInstance().setActiveWindow(SwingScoutDialog.this.m_swingDialog);
            SwingScoutDialog.this.fireSwingScoutViewEvent(new SwingScoutViewEvent(SwingScoutDialog.this, 20));
        }

        @Override
        public void windowClosing(WindowEvent e) {
            boolean ok;
            Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (focusOwner != null && focusOwner instanceof JComponent && ((JComponent)focusOwner).getInputVerifier() != null && !(ok = ((JComponent)focusOwner).getInputVerifier().verify((JComponent)focusOwner))) {
                return;
            }
            SwingScoutDialog.this.fireSwingScoutViewEvent(new SwingScoutViewEvent(SwingScoutDialog.this, 30));
        }

        @Override
        public void windowClosed(WindowEvent e) {
            Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (focusOwner != null && focusOwner instanceof JComponent && ((JComponent)focusOwner).getInputVerifier() != null) {
                ((JComponent)focusOwner).getInputVerifier().verify((JComponent)focusOwner);
            }
            SwingScoutDialog.this.fireSwingScoutViewEvent(new SwingScoutViewEvent(SwingScoutDialog.this, 40));
        }
    }
}

