/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.window.popup;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.window.SwingScoutViewEvent;
import org.eclipse.scout.rt.ui.swing.window.popup.SwingScoutPopup;

public class SwingScoutDropDownPopup
extends SwingScoutPopup {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwingScoutDropDownPopup.class);
    private ComponentListener m_ownerComponentListener;
    private Component m_focusComponent;
    private FocusListener m_focusFocusListener;
    private AWTEventListener m_awtListener;

    public SwingScoutDropDownPopup(ISwingEnvironment env, Component ownerComponent, Component focusComponent) {
        super(env, ownerComponent, new Rectangle(ownerComponent.getLocationOnScreen(), ownerComponent.getSize()));
        this.m_focusComponent = focusComponent;
    }

    public SwingScoutDropDownPopup(ISwingEnvironment env, Component ownerComponent, Component focusComponent, int fixedWidth) {
        super(env, ownerComponent, new Rectangle(ownerComponent.getLocationOnScreen(), ownerComponent.getSize()), fixedWidth);
        this.m_focusComponent = focusComponent;
    }

    public void makeNonFocusable() {
        this.getSwingWindow().setFocusableWindowState(false);
        this.getSwingWindow().setFocusable(false);
        this.makeNonFocusableRec(this.getSwingWindow());
    }

    private void makeNonFocusableRec(Container parent) {
        Component[] componentArray = parent.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c instanceof JComponent) {
                ((JComponent)c).setRequestFocusEnabled(false);
                ((JComponent)c).setFocusable(false);
            }
            if (c instanceof Container) {
                this.makeNonFocusableRec((Container)c);
            }
            ++n2;
        }
    }

    @Override
    protected void handleSwingWindowOpened() {
        if (this.m_awtListener == null) {
            this.m_awtListener = new AWTEventListener(){

                @Override
                public void eventDispatched(AWTEvent event) {
                    MouseEvent me;
                    Window w;
                    if (event.getID() == 501 && (w = (me = (MouseEvent)event).getComponent() instanceof Window ? (Window)me.getComponent() : SwingUtilities.getWindowAncestor(me.getComponent())) != SwingScoutDropDownPopup.this.getSwingWindow()) {
                        Point p = SwingUtilities.convertPoint(me.getComponent(), me.getPoint(), SwingScoutDropDownPopup.this.getSwingOwnerComponent());
                        if (!SwingScoutDropDownPopup.this.getSwingOwnerComponent().contains(p)) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (SwingScoutDropDownPopup.this.getSwingWindow().isVisible()) {
                                        SwingScoutDropDownPopup.this.closeView();
                                        SwingScoutDropDownPopup.this.fireSwingScoutViewEvent(new SwingScoutViewEvent(SwingScoutDropDownPopup.this, 40));
                                    }
                                }
                            });
                        }
                    }
                }
            };
            Toolkit.getDefaultToolkit().addAWTEventListener(this.m_awtListener, 16L);
        }
        if (this.m_ownerComponentListener == null) {
            this.m_ownerComponentListener = new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent event) {
                    SwingScoutDropDownPopup.this.autoAdjustBounds();
                }

                @Override
                public void componentMoved(ComponentEvent event) {
                    SwingScoutDropDownPopup.this.autoAdjustBounds();
                }
            };
            Window w = SwingUtilities.getWindowAncestor(this.getSwingOwnerComponent());
            if (w != null) {
                w.addComponentListener(this.m_ownerComponentListener);
            }
            this.getSwingOwnerComponent().addComponentListener(this.m_ownerComponentListener);
        }
        if (this.m_focusComponent != null && this.m_focusFocusListener == null) {
            this.m_focusFocusListener = new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent event) {
                    SwingScoutDropDownPopup.this.closeView();
                    SwingScoutDropDownPopup.this.fireSwingScoutViewEvent(new SwingScoutViewEvent(SwingScoutDropDownPopup.this, 40));
                }
            };
            this.m_focusComponent.addFocusListener(this.m_focusFocusListener);
        }
        super.handleSwingWindowOpened();
        if (this.m_focusComponent != null && !this.m_focusComponent.hasFocus()) {
            this.closeView();
            this.fireSwingScoutViewEvent(new SwingScoutViewEvent(this, 40));
        }
    }

    @Override
    protected void handleSwingWindowClosed() {
        if (this.m_awtListener != null) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.m_awtListener);
            this.m_awtListener = null;
        }
        if (this.m_ownerComponentListener != null) {
            Window w = SwingUtilities.getWindowAncestor(this.getSwingOwnerComponent());
            if (w != null) {
                w.removeComponentListener(this.m_ownerComponentListener);
            }
            this.getSwingOwnerComponent().removeComponentListener(this.m_ownerComponentListener);
            this.m_ownerComponentListener = null;
        }
        if (this.m_focusComponent != null && this.m_focusFocusListener != null) {
            this.m_focusComponent.removeFocusListener(this.m_focusFocusListener);
            this.m_focusFocusListener = null;
        }
        super.handleSwingWindowClosed();
    }
}

