/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.window.popup;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.SwingLayoutUtility;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.ext.JWindowEx;
import org.eclipse.scout.rt.ui.swing.form.fields.AbstractLayoutManager2;
import org.eclipse.scout.rt.ui.swing.window.DependentCloseListener;
import org.eclipse.scout.rt.ui.swing.window.ISwingScoutView;
import org.eclipse.scout.rt.ui.swing.window.SwingScoutViewEvent;
import org.eclipse.scout.rt.ui.swing.window.SwingScoutViewListener;
import org.eclipse.scout.rt.ui.swing.window.SwingWindowManager;

public class SwingScoutPopup
implements ISwingScoutView {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwingScoutPopup.class);
    private ISwingEnvironment m_env;
    private int m_fixedWidth;
    private EventListenerList m_listenerList;
    private P_SwingScoutRootListener m_swingScoutRootListener;
    private Component m_ownerComponent;
    private Rectangle m_ownerBounds;
    private JWindowEx m_swingWindow;
    private boolean m_maximized;
    private boolean m_positionBelowReferenceField;
    private Rectangle m_boundsBeforeMaximize;
    private boolean m_opened;
    private boolean m_closeFired;

    public SwingScoutPopup(ISwingEnvironment env, Component ownerComponent, Rectangle ownerBounds) {
        this(env, ownerComponent, ownerBounds, 0);
    }

    public SwingScoutPopup(ISwingEnvironment env, Component ownerComponent, Rectangle ownerBounds, int fixedWidth) {
        this.m_env = env;
        this.m_ownerComponent = ownerComponent;
        this.m_ownerBounds = ownerBounds;
        this.m_listenerList = new EventListenerList();
        this.m_fixedWidth = fixedWidth;
        this.m_positionBelowReferenceField = true;
        Window w = SwingUtilities.getWindowAncestor(this.m_ownerComponent);
        this.m_swingWindow = new JWindowEx(w);
        this.m_swingWindow.addWindowListener(new P_SwingWindowListener());
        if (!SwingUtility.isSynth()) {
            this.m_swingWindow.getRootPane().setBorder(UIManager.getBorder("SwingScoutPopup.border"));
        }
        JComponent contentPane = (JComponent)this.m_swingWindow.getContentPane();
        contentPane.setLayout(new P_PopupContentPaneLayout());
        contentPane.setCursor(Cursor.getDefaultCursor());
        this.m_swingWindow.getRootPane().setName("Synth.Popup");
        if (this.m_swingScoutRootListener == null) {
            this.m_swingScoutRootListener = new P_SwingScoutRootListener();
            this.m_env.addPropertyChangeListener(this.m_swingScoutRootListener);
        }
        this.m_swingWindow.pack();
    }

    public void autoAdjustBounds() {
        try {
            if (this.m_ownerComponent.isShowing()) {
                int minWidth;
                this.m_swingWindow.validate();
                this.m_swingWindow.getRootPane().revalidate();
                Dimension d = this.m_swingWindow.getPreferredSize();
                if (this.m_fixedWidth > 0) {
                    d.width = this.m_fixedWidth;
                    minWidth = this.m_fixedWidth;
                } else {
                    d.width = Math.max(this.m_env.getFormColumnWidth() / 2, d.width);
                    minWidth = Math.max(this.m_env.getFormColumnWidth() / 2, this.m_swingWindow.getMinimumSize().width);
                }
                Point p = this.m_ownerBounds.getLocation();
                Point above = new Point(p.x, p.y - 2);
                Rectangle aboveView = SwingUtility.intersectRectangleWithScreen(new Rectangle(above.x, above.y - d.height, d.width, d.height), false, false);
                if (aboveView.width < minWidth) {
                    aboveView.x = aboveView.x + aboveView.width - minWidth;
                    aboveView.width = minWidth;
                }
                Point below = new Point(p.x, p.y + 2 + this.m_ownerBounds.height);
                Rectangle belowView = SwingUtility.intersectRectangleWithScreen(new Rectangle(below.x, below.y, d.width, d.height), false, false);
                if (belowView.width < minWidth) {
                    belowView.x = belowView.x + belowView.width - minWidth;
                    belowView.width = minWidth;
                }
                Rectangle currentView = this.m_positionBelowReferenceField ? belowView : aboveView;
                Rectangle alternateView = this.m_positionBelowReferenceField ? aboveView : belowView;
                Rectangle ownerScreen = SwingUtility.getFullScreenBoundsFor(this.m_ownerBounds, false);
                if (currentView.height >= alternateView.height) {
                    this.m_swingWindow.setBounds(SwingUtility.validateRectangleOnScreen(currentView, ownerScreen, true, true));
                } else {
                    this.m_swingWindow.setBounds(SwingUtility.validateRectangleOnScreen(alternateView, ownerScreen, true, true));
                    boolean bl = this.m_positionBelowReferenceField = !this.m_positionBelowReferenceField;
                }
                if (System.getProperty("java.version", "1.5").startsWith("1.5")) {
                    this.m_swingWindow.validate();
                    this.m_swingWindow.getRootPane().revalidate();
                }
            }
        }
        catch (Throwable throwable) {}
    }

    public Window getSwingWindow() {
        return this.m_swingWindow;
    }

    public Component getSwingOwnerComponent() {
        return this.m_ownerComponent;
    }

    @Override
    public JComponent getSwingContentPane() {
        return (JComponent)this.m_swingWindow.getContentPane();
    }

    @Override
    public void addSwingScoutViewListener(SwingScoutViewListener listener) {
        this.m_listenerList.add(SwingScoutViewListener.class, (EventListener)listener);
    }

    @Override
    public void removeSwingScoutViewListener(SwingScoutViewListener listener) {
        this.m_listenerList.remove(SwingScoutViewListener.class, (EventListener)listener);
    }

    protected void fireSwingScoutViewEvent(SwingScoutViewEvent e) {
        switch (e.getType()) {
            case 10: {
                this.m_closeFired = false;
                break;
            }
            case 40: {
                if (this.m_closeFired) {
                    return;
                }
                this.m_closeFired = true;
            }
        }
        EventListener[] listeners = this.m_listenerList.getListeners(SwingScoutViewListener.class);
        if (listeners != null && listeners.length > 0) {
            int i = 0;
            while (i < listeners.length) {
                try {
                    ((SwingScoutViewListener)listeners[i]).viewChanged(e);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                ++i;
            }
        }
    }

    protected void handleSwingWindowOpened() {
        SwingWindowManager.getInstance().setActiveWindow(this.getSwingWindow());
        this.fireSwingScoutViewEvent(new SwingScoutViewEvent(this, 10));
    }

    protected void handleSwingWindowClosed() {
        Component focusOwner;
        if (this.getSwingWindow().isFocused() && (focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) != null && focusOwner instanceof JComponent && ((JComponent)focusOwner).getInputVerifier() != null) {
            ((JComponent)focusOwner).getInputVerifier().verify((JComponent)focusOwner);
        }
        this.fireSwingScoutViewEvent(new SwingScoutViewEvent(this, 40));
    }

    @Override
    public boolean isVisible() {
        return this.m_swingWindow != null && this.m_swingWindow.isVisible();
    }

    @Override
    public boolean isActive() {
        return this.m_swingWindow != null && this.m_swingWindow.isActive();
    }

    @Override
    public void openView() {
        this.m_opened = true;
        this.autoAdjustBounds();
        if (this.m_opened) {
            this.m_swingWindow.setVisible(true);
        }
    }

    @Override
    public void closeView() {
        if (this.m_opened) {
            this.m_opened = false;
            if (this.m_swingScoutRootListener != null) {
                this.m_env.removePropertyChangeListener(this.m_swingScoutRootListener);
                this.m_swingScoutRootListener = null;
            }
            new DependentCloseListener(this.m_swingWindow).close();
        }
    }

    @Override
    public void setTitle(String s) {
    }

    @Override
    public void setCloseEnabled(boolean b) {
    }

    @Override
    public void setMaximizeEnabled(boolean b) {
    }

    @Override
    public void setMinimizeEnabled(boolean b) {
    }

    @Override
    public void setMinimized(boolean on) {
    }

    @Override
    public void setMaximized(boolean on) {
        this.m_maximized = on;
        if (on) {
            if (this.m_boundsBeforeMaximize == null) {
                this.m_boundsBeforeMaximize = this.m_swingWindow.getBounds();
            }
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            Insets in = Toolkit.getDefaultToolkit().getScreenInsets(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration());
            Rectangle r = new Rectangle();
            if (in != null) {
                r.x = in.left;
                r.y = in.top;
                r.width = d.width - in.left - in.right;
                r.height = d.height - in.top - in.bottom;
            } else {
                r.x = 0;
                r.y = 0;
                r.width = d.width;
                r.height = d.height;
            }
            this.m_swingWindow.setBounds(r);
        } else if (this.m_boundsBeforeMaximize != null) {
            this.m_swingWindow.setBounds(this.m_boundsBeforeMaximize);
            this.m_boundsBeforeMaximize = null;
        }
    }

    @Override
    public void setName(String name) {
        this.m_swingWindow.setName(name);
        this.m_swingWindow.getRootPane().setName(name);
    }

    private class P_PopupContentPaneLayout
    extends AbstractLayoutManager2 {
        private P_PopupContentPaneLayout() {
        }

        @Override
        protected Dimension getLayoutSize(Container parent, int sizeflag) {
            Dimension ps;
            Component c;
            Insets insets = parent.getInsets();
            Dimension d = new Dimension();
            d.width = 0;
            Component[] componentArray = parent.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                c = componentArray[n2];
                ps = SwingLayoutUtility.getSize(c, sizeflag);
                d.width += ps.width;
                ++n2;
            }
            d.width += insets.left + insets.right;
            d.height = 0;
            componentArray = parent.getComponents();
            n = componentArray.length;
            n2 = 0;
            while (n2 < n) {
                c = componentArray[n2];
                ps = SwingLayoutUtility.getSize(c, sizeflag);
                d.height = Math.max(d.height, ps.height);
                ++n2;
            }
            d.height += insets.top + insets.bottom;
            return d;
        }

        @Override
        protected void validateLayout(Container parent) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            this.verifyLayout(parent);
            Object object = parent.getTreeLock();
            synchronized (object) {
                Component[] componentArray = parent.getComponents();
                int n = componentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Component c = componentArray[n2];
                    c.setBounds(0, 0, 0, 0);
                    ++n2;
                }
                Insets insets = parent.getInsets();
                Rectangle view = new Rectangle(insets.left, insets.top, parent.getWidth() - insets.left - insets.right, parent.getHeight() - insets.top - insets.bottom);
                if (parent.getComponentCount() > 0) {
                    parent.getComponent(0).setBounds(view.x, view.y, view.width, view.height);
                }
            }
        }
    }

    private class P_SwingScoutRootListener
    implements PropertyChangeListener {
        private P_SwingScoutRootListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("busy")) {
                boolean busy = (Boolean)e.getNewValue();
                SwingScoutPopup.this.m_swingWindow.setWaitCursor(busy);
            }
        }
    }

    private class P_SwingWindowListener
    extends WindowAdapter {
        private P_SwingWindowListener() {
        }

        @Override
        public void windowOpened(WindowEvent e) {
            SwingScoutPopup.this.handleSwingWindowOpened();
        }

        @Override
        public void windowActivated(WindowEvent e) {
            SwingWindowManager.getInstance().setActiveWindow(SwingScoutPopup.this.getSwingWindow());
            SwingScoutPopup.this.fireSwingScoutViewEvent(new SwingScoutViewEvent(SwingScoutPopup.this, 20));
        }

        @Override
        public void windowClosing(WindowEvent e) {
            boolean ok;
            Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (focusOwner != null && focusOwner instanceof JComponent && ((JComponent)focusOwner).getInputVerifier() != null && !(ok = ((JComponent)focusOwner).getInputVerifier().verify((JComponent)focusOwner))) {
                return;
            }
            SwingScoutPopup.this.fireSwingScoutViewEvent(new SwingScoutViewEvent(SwingScoutPopup.this, 30));
        }

        @Override
        public void windowClosed(WindowEvent e) {
            SwingScoutPopup.this.handleSwingWindowClosed();
        }
    }
}

