/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt;

import java.util.ArrayList;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.checkbox.ICheckBoxMenu;
import org.eclipse.scout.rt.client.ui.action.tree.IActionNode;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.scout.rt.ui.swt.action.SwtScoutAction;
import org.eclipse.scout.rt.ui.swt.action.SwtScoutCheckboxMenu;
import org.eclipse.scout.rt.ui.swt.action.SwtScoutMenuAction;
import org.eclipse.scout.rt.ui.swt.action.SwtScoutMenuGroup;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public final class SwtMenuUtility {
    private static IScoutLogger LOG = ScoutLogManager.getLogger(SwtMenuUtility.class);

    private SwtMenuUtility() {
    }

    public static IContributionItem[] getMenuContribution(IActionNode<?>[] scoutActionNodes, ISwtEnvironment environment) {
        ArrayList<Object> contributionItems = new ArrayList<Object>();
        IActionNode<?>[] iActionNodeArray = scoutActionNodes;
        int n = scoutActionNodes.length;
        int n2 = 0;
        while (n2 < n) {
            IActionNode<?> scoutAction = iActionNodeArray[n2];
            if (scoutAction.isVisible()) {
                if (scoutAction.isSeparator()) {
                    if (contributionItems.size() <= 0 || !((IContributionItem)contributionItems.get(contributionItems.size() - 1)).isSeparator()) {
                        contributionItems.add(new Separator());
                    }
                } else if (scoutAction.hasChildActions()) {
                    MenuManager manager = new MenuManager(scoutAction.getText(), scoutAction.getActionId());
                    SwtMenuUtility.fillMenuManager(scoutAction.getChildActions().toArray(new IActionNode[scoutAction.getChildActionCount()]), (IMenuManager)manager, environment);
                    contributionItems.add(manager);
                } else if (scoutAction instanceof ICheckBoxMenu) {
                    contributionItems.add(new ActionContributionItem((org.eclipse.jface.action.IAction)new SwtScoutAction((IAction)scoutAction, environment, 32).getSwtAction()));
                } else {
                    contributionItems.add(new ActionContributionItem((org.eclipse.jface.action.IAction)new SwtScoutAction((IAction)scoutAction, environment).getSwtAction()));
                }
            }
            ++n2;
        }
        return contributionItems.toArray(new IContributionItem[contributionItems.size()]);
    }

    public static IContributionItem getMenuContributionItem(IActionNode<?> scoutAction, ISwtEnvironment environment) {
        Separator item = null;
        if (scoutAction.isVisible()) {
            if (scoutAction.isSeparator()) {
                item = new Separator();
            } else if (scoutAction.hasChildActions()) {
                MenuManager manager = new MenuManager(scoutAction.getText(), scoutAction.getActionId());
                SwtMenuUtility.fillMenuManager(scoutAction.getChildActions().toArray(new IActionNode[scoutAction.getChildActionCount()]), (IMenuManager)manager, environment);
                item = manager;
            } else {
                item = scoutAction instanceof ICheckBoxMenu ? new ActionContributionItem((org.eclipse.jface.action.IAction)new SwtScoutAction((IAction)scoutAction, environment, 32).getSwtAction()) : new ActionContributionItem((org.eclipse.jface.action.IAction)new SwtScoutAction((IAction)scoutAction, environment).getSwtAction());
            }
        }
        return item;
    }

    private static void fillMenuManager(IActionNode<?>[] scoutActionNodes, IMenuManager manager, ISwtEnvironment environment) {
        IActionNode<?>[] iActionNodeArray = scoutActionNodes;
        int n = scoutActionNodes.length;
        int n2 = 0;
        while (n2 < n) {
            IActionNode<?> scoutAction = iActionNodeArray[n2];
            if (scoutAction.isVisible()) {
                if (scoutAction.isSeparator()) {
                    if (manager.getItems().length <= 0 || !manager.getItems()[manager.getItems().length - 1].isSeparator()) {
                        manager.add((IContributionItem)new Separator());
                    }
                } else if (scoutAction.hasChildActions()) {
                    MenuManager childManager = new MenuManager(scoutAction.getText(), scoutAction.getActionId());
                    SwtMenuUtility.fillMenuManager(scoutAction.getChildActions().toArray(new IActionNode[scoutAction.getChildActionCount()]), (IMenuManager)childManager, environment);
                    manager.add((IContributionItem)childManager);
                } else if (scoutAction instanceof ICheckBoxMenu) {
                    manager.add((IContributionItem)new ActionContributionItem((org.eclipse.jface.action.IAction)new SwtScoutAction((IAction)scoutAction, environment, 32).getSwtAction()));
                } else {
                    manager.add((IContributionItem)new ActionContributionItem((org.eclipse.jface.action.IAction)new SwtScoutAction((IAction)scoutAction, environment).getSwtAction()));
                }
            }
            ++n2;
        }
    }

    public static void fillContextMenu(IMenu[] scoutMenus, Menu menu, ISwtEnvironment environment) {
        if (scoutMenus != null && scoutMenus.length > 0) {
            int count = scoutMenus.length;
            int index = 0;
            IMenu[] iMenuArray = scoutMenus;
            int n = scoutMenus.length;
            int n2 = 0;
            while (n2 < n) {
                IMenu scoutMenu = iMenuArray[n2];
                SwtMenuUtility.fillContextMenuRec(scoutMenu, index, count, menu, environment);
                ++index;
                ++n2;
            }
        }
    }

    private static void fillContextMenuRec(IActionNode<?> scoutActionNode, int index, int count, Menu menu, ISwtEnvironment environment) {
        if (!scoutActionNode.isVisible()) {
            return;
        }
        if (scoutActionNode.isSeparator()) {
            if (menu.getItemCount() > 0 && (2 & menu.getItem(menu.getItemCount() - 1).getStyle()) == 0 && index + 1 < count) {
                new MenuItem(menu, 2);
            }
        } else if (scoutActionNode instanceof ICheckBoxMenu) {
            new SwtScoutCheckboxMenu(menu, (ICheckBoxMenu)scoutActionNode, environment);
        } else if (scoutActionNode.getChildActionCount() > 0) {
            SwtScoutMenuGroup group = new SwtScoutMenuGroup(menu, (IAction)scoutActionNode, environment);
            Menu subMenu = new Menu(menu);
            group.getSwtMenuItem().setMenu(subMenu);
            int subIndex = 0;
            int subCount = scoutActionNode.getChildActions().size();
            for (IActionNode subAction : scoutActionNode.getChildActions()) {
                SwtMenuUtility.fillContextMenuRec(subAction, subIndex, subCount, subMenu, environment);
                ++subIndex;
            }
        } else {
            new SwtScoutMenuAction(menu, (IAction)scoutActionNode, environment);
        }
    }
}

