/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.basic.calendar.layout;

import org.eclipse.scout.rt.ui.swt.basic.calendar.CalendarConstants;
import org.eclipse.scout.rt.ui.swt.basic.calendar.layout.WeekItemData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class WeekItemLayout
extends Layout
implements CalendarConstants {
    private static final int MIN_WIDTH = 3;
    private static final int MIN_HEIGHT = 4;

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        return new Point(0, 0);
    }

    protected void layout(Composite composite, boolean flushCache) {
        Control[] children = composite.getChildren();
        Rectangle clipRect = composite.getClientArea();
        Control[] controlArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            WeekItemData dat = (WeekItemData)child.getLayoutData();
            int yOffset = Math.max(0, dat.offsetCellHeader - 1);
            int timelessHeight = Math.min(24 * dat.timelessMaxCount, 33 * clipRect.height / 100);
            int hTimeless = Math.max(0, timelessHeight - 1);
            int yTimed = yOffset + hTimeless + 1;
            int hTimed = clipRect.height - yOffset - hTimeless;
            Rectangle r = new Rectangle(0, 0, 0, 0);
            long intervalMillis = 50400000L;
            int timelessItemHeight = 0;
            int countTimeless = dat.timelessCount;
            if (countTimeless > 0) {
                timelessItemHeight = Math.max(5, hTimeless / countTimeless);
            }
            int absX = 0;
            int absY = 0;
            int w = clipRect.width;
            if (dat.m_item.isTimed()) {
                r.x = (int)(dat.m_item.getX0() * (float)w);
                r.width = (int)(dat.m_item.getX1() * (float)w) - r.x;
                r.width = r.width < 3 ? 3 : r.width;
                r.y = yTimed + (int)(dat.m_item.getFromRelative() * (long)hTimed / intervalMillis);
                r.height = yTimed + (int)(dat.m_item.getToRelative() * (long)hTimed / intervalMillis) - r.y;
                r.height = r.height < 4 ? 4 : r.height;
            } else {
                r.x = 0;
                r.width = w;
                r.y = yOffset + dat.timelessIndex * timelessItemHeight;
                r.height = r.y < hTimeless + yOffset ? timelessItemHeight : 0;
            }
            ++r.x;
            r.width = Math.max(0, r.width - 2);
            ++r.y;
            r.height = Math.max(0, r.height - 2);
            child.setBounds(r.x + absX, r.y + absY, r.width, r.height);
            ++n2;
        }
    }
}

