/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.basic.calendar.widgets;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeSet;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.basic.calendar.CalendarComponent;
import org.eclipse.scout.rt.client.ui.basic.calendar.DateTimeFormatFactory;
import org.eclipse.scout.rt.ui.swt.basic.calendar.CalendarItemContainer;
import org.eclipse.scout.rt.ui.swt.basic.calendar.SwtColors;
import org.eclipse.scout.rt.ui.swt.basic.calendar.widgets.AbstractCalendarItem;
import org.eclipse.scout.rt.ui.swt.basic.calendar.widgets.MonthCalendarItem;
import org.eclipse.scout.rt.ui.swt.basic.calendar.widgets.MonthCell;
import org.eclipse.scout.rt.ui.swt.basic.calendar.widgets.SwtCalendar;
import org.eclipse.scout.rt.ui.swt.basic.calendar.widgets.WeekCalendarItem;
import org.eclipse.scout.rt.ui.swt.basic.calendar.widgets.WeekCell;
import org.eclipse.scout.rt.ui.swt.util.SwtUtility;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;

public abstract class AbstractCell
extends Composite
implements PaintListener {
    protected static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractCell.class);
    public final Color BACKGROUND;
    public final Color BORDER_SELECTED_COLOR;
    public final Color BORDER_UNSELECTED_COLOR;
    protected Color background;
    protected SwtCalendar m_calendar;
    protected Calendar m_cellDate;
    protected boolean m_isFirstColumn;
    protected boolean m_isCurrentPeriod;
    protected boolean m_isSelected;
    protected String m_weekText;
    protected String m_dayText;
    protected MenuManager m_menuManager;
    protected TreeSet<CalendarItemContainer> m_itemsCached;
    protected ArrayList<AbstractCalendarItem> m_widgetItems;
    protected int m_countTimeless;

    public AbstractCell(Composite parent, int style) {
        super(parent, style);
        this.BACKGROUND = SwtColors.getInstance().white;
        this.BORDER_SELECTED_COLOR = SwtColors.getInstance().blue;
        this.BORDER_UNSELECTED_COLOR = SwtColors.getInstance().gray;
        this.background = this.BACKGROUND;
        this.m_weekText = null;
        this.m_dayText = null;
        this.m_widgetItems = new ArrayList();
        this.m_isSelected = false;
        this.setupMenu();
    }

    protected void setupMenu() {
        this.m_menuManager = new MenuManager();
        this.m_menuManager.setRemoveAllWhenShown(true);
        Menu contextMenu = this.m_menuManager.createContextMenu((Control)this);
        this.setMenu(contextMenu);
    }

    public synchronized Collection<CalendarItemContainer> getItems() {
        if (this.m_itemsCached == null) {
            this.m_itemsCached = new TreeSet();
            this.m_countTimeless = 0;
            Collection<CalendarComponent> items = this.m_calendar.getModel().getItemsAt(this.getDate().getTime());
            if (items != null) {
                try {
                    for (CalendarComponent item : items) {
                        this.m_itemsCached.add(new CalendarItemContainer(item, this));
                    }
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    LOG.warn("ConcurrentModificationException on getItems");
                    return this.m_itemsCached;
                }
            }
            if (!this.m_itemsCached.isEmpty()) {
                ArrayList<ItemBoundsOrganizer> seen = new ArrayList<ItemBoundsOrganizer>();
                ArrayList<ItemBoundsOrganizer> conflict = new ArrayList<ItemBoundsOrganizer>();
                int horizontalSlotCount = 0;
                for (CalendarItemContainer calendarItemContainer : this.m_itemsCached) {
                    if (!calendarItemContainer.isTimed()) continue;
                    ItemBoundsOrganizer newNode = new ItemBoundsOrganizer(calendarItemContainer);
                    conflict.clear();
                    int minLevel = 0;
                    for (ItemBoundsOrganizer oldNode : seen) {
                        if (!oldNode.getCC().intersects(newNode.getCC())) continue;
                        conflict.add(oldNode);
                        minLevel = Math.max(minLevel, oldNode.getMinLevel() + 1);
                    }
                    newNode.setMinLevel(minLevel);
                    horizontalSlotCount = Math.max(horizontalSlotCount, minLevel + 1);
                    seen.add(newNode);
                    for (ItemBoundsOrganizer node : conflict) {
                        node.limitMaxLevel(minLevel - 1);
                    }
                }
                for (ItemBoundsOrganizer itemBoundsOrganizer : seen) {
                    itemBoundsOrganizer.saveHorizontalExtents(horizontalSlotCount);
                }
                for (CalendarItemContainer calendarItemContainer : this.m_itemsCached) {
                    if (calendarItemContainer.isTimed()) continue;
                    calendarItemContainer.setHorizontalExtents(0.0f, 1.0f);
                    ++this.m_countTimeless;
                }
                return this.m_itemsCached;
            }
            return null;
        }
        return this.m_itemsCached;
    }

    public int getCountTimelessItems() {
        return this.m_countTimeless;
    }

    public void reloadCalendarItems() {
        this.disposeCalendarItems();
        this.m_itemsCached = null;
        this.addCalendarItems();
    }

    public SwtCalendar getCalendar() {
        return this.m_calendar;
    }

    public void paintControl(PaintEvent e) {
        this.setBackground(this.background);
        this.drawLabels(e);
        this.drawTimeline(e);
        this.drawBorder(e);
    }

    protected abstract void drawLabels(PaintEvent var1);

    protected void drawDayLabel(PaintEvent e) {
        if (this.m_dayText != null) {
            e.gc.setForeground(SwtColors.getInstance().black);
            Rectangle bounds = this.getBounds();
            Point ext = e.gc.stringExtent(this.m_dayText);
            e.gc.drawString(this.m_dayText, bounds.width - 2 - ext.x, 1, true);
        }
    }

    protected void drawWeekLabel(PaintEvent e) {
        if (this.m_dayText != null) {
            e.gc.setForeground(SwtColors.getInstance().black);
            e.gc.drawString(this.m_weekText, 3, 1, true);
        }
    }

    protected void drawBorder(PaintEvent e) {
        if (this.m_isSelected) {
            e.gc.setForeground(this.BORDER_SELECTED_COLOR);
        } else {
            e.gc.setForeground(this.BORDER_UNSELECTED_COLOR);
        }
        Rectangle bounds = this.getBounds();
        e.gc.drawRectangle(0, 0, bounds.width - 1, bounds.height - 1);
        e.gc.setForeground(this.BORDER_UNSELECTED_COLOR);
    }

    protected void drawTimeline(PaintEvent e) {
    }

    public void setSelected() {
        if (!this.m_isCurrentPeriod) {
            this.m_calendar.setViewDate(this.m_cellDate);
        }
        this.m_calendar.setSelectedItem(null);
        this.m_calendar.setSelectedDateFromUI(this.m_cellDate);
    }

    protected void hookListeners() {
        this.addPaintListener(this);
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                AbstractCell.this.setSelected();
            }
        });
        this.m_menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                AbstractCell.this.m_calendar.showGeneralContextMenu(manager);
            }
        });
        this.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                switch (e.detail) {
                    case 16: 
                    case 64: {
                        Calendar newDate = Calendar.getInstance();
                        newDate.setTime(AbstractCell.this.m_cellDate.getTime());
                        newDate.add(5, 1);
                        AbstractCell cell = AbstractCell.this.m_calendar.getCentralPanel().getCellFromDate(newDate.getTime());
                        if (cell != null) {
                            cell.setSelected();
                        }
                        e.doit = false;
                        break;
                    }
                    case 8: 
                    case 32: {
                        Calendar newDate = Calendar.getInstance();
                        newDate.setTime(AbstractCell.this.m_cellDate.getTime());
                        newDate.add(5, -1);
                        AbstractCell cell = AbstractCell.this.m_calendar.getCentralPanel().getCellFromDate(newDate.getTime());
                        if (cell != null) {
                            cell.setSelected();
                        }
                        e.doit = false;
                    }
                }
            }
        });
        this.addListener(1, new Listener(){

            public void handleEvent(Event e) {
            }
        });
    }

    public void setSelected(boolean selected) {
        if (this.m_isSelected == selected) {
            return;
        }
        if (selected) {
            this.setFocus();
        }
        this.m_isSelected = selected;
        this.redraw();
    }

    public boolean getSelected() {
        return this.m_isSelected;
    }

    public void setDayText(String text) {
        this.m_dayText = text;
    }

    public void setWeekText(String text) {
        this.m_weekText = text;
    }

    public Calendar getDate() {
        return this.m_cellDate;
    }

    protected void setVisualState() {
        String weekName = this.m_isFirstColumn ? String.valueOf(SwtUtility.getNlsText(Display.getCurrent(), "WeekShort", new String[0])) + " " + this.m_cellDate.get(3) : "";
        String day = new SimpleDateFormat("dd.MMM", Locale.getDefault()).format(this.m_cellDate.getTime());
        this.setDayText(day);
        this.setWeekText(weekName);
        if (this.m_isCurrentPeriod) {
            this.setBackground(SwtColors.getInstance().white);
        } else {
            this.setBackground(SwtColors.getInstance().lightgray);
        }
    }

    protected void addCalendarItems() {
        Collection<CalendarItemContainer> items = this.getItems();
        if (items != null) {
            Iterator<CalendarItemContainer> iterator = this.getItems().iterator();
            while (iterator.hasNext()) {
                CalendarItemContainer element;
                CalendarItemContainer item = element = iterator.next();
                if (this instanceof WeekCell) {
                    this.m_widgetItems.add(new WeekCalendarItem(this, 0, item));
                    continue;
                }
                if (!(this instanceof MonthCell)) continue;
                this.m_widgetItems.add(new MonthCalendarItem(this, 0, item));
            }
        }
    }

    public void setBackground(Color c) {
        super.setBackground(c);
        this.background = c;
    }

    protected void disposeCalendarItems() {
        if (this.m_widgetItems != null) {
            for (AbstractCalendarItem item : this.m_widgetItems) {
                if (item == null || item.isDisposed()) continue;
                item.dispose();
            }
            this.m_widgetItems = new ArrayList();
        }
    }

    public void dispose() {
        this.disposeCalendarItems();
        super.dispose();
    }

    public static long getTimeOfDayMillis(Date d) {
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        long timeRel = (((long)c.get(11) * 60L + (long)c.get(12)) * 60L + (long)c.get(13)) * 1000L + (long)c.get(14);
        c.set(10, 0);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        long dayAbs = c.getTimeInMillis();
        return dayAbs + timeRel;
    }

    public String toString() {
        SimpleDateFormat weekDayFmt = new SimpleDateFormat("EEEEE", Locale.getDefault());
        DateFormat dateFmt = new DateTimeFormatFactory().getDayMonthYear(1);
        return "AbstractCell {" + weekDayFmt.format(this.m_cellDate.getTime()) + " " + dateFmt.format(this.m_cellDate.getTime()) + "}";
    }

    private class ItemBoundsOrganizer {
        private CalendarItemContainer m_cc;
        private int m_minLevel;
        private int m_maxLevel = 100000;

        public ItemBoundsOrganizer(CalendarItemContainer cc) {
            this.m_cc = cc;
        }

        public CalendarItemContainer getCC() {
            return this.m_cc;
        }

        public int getMinLevel() {
            return this.m_minLevel;
        }

        public void setMinLevel(int i) {
            this.m_minLevel = i;
        }

        public void limitMaxLevel(int maximumValue) {
            this.m_maxLevel = Math.min(this.m_maxLevel, maximumValue);
        }

        private void saveHorizontalExtents(int horizontalSlotCount) {
            float x0 = 1.0f * (float)this.m_minLevel / (float)horizontalSlotCount;
            float x1 = 1.0f * (float)Math.min(this.m_maxLevel + 1, horizontalSlotCount) / (float)horizontalSlotCount;
            this.m_cc.setHorizontalExtents(x0, x1);
        }

        public String toString() {
            return "BoundsOrganizer[" + this.m_cc + "]";
        }
    }
}

