/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.basic.calendar.widgets;

import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Locale;
import org.eclipse.scout.rt.ui.swt.basic.calendar.SwtColors;
import org.eclipse.scout.rt.ui.swt.basic.calendar.widgets.SwtCalendar;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class DayNamesBar
extends Composite
implements PaintListener {
    protected int m_nbDays;
    protected boolean m_condensed;
    SwtCalendar m_calendar;
    ArrayList<Label> labelList = new ArrayList();

    public DayNamesBar(Composite parent, int style, SwtCalendar calendar) {
        this(parent, style, calendar, 7, false);
    }

    public DayNamesBar(Composite parent, int style, SwtCalendar calendar, int nbDays, boolean condensed) {
        super(parent, style);
        this.m_nbDays = nbDays;
        this.m_condensed = condensed;
        this.m_calendar = calendar;
        this.createControls();
    }

    public void createControls() {
        int nbCols = this.m_nbDays == 7 && this.m_condensed ? 6 : this.m_nbDays;
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 2;
        this.setLayoutData(gd);
        GridLayout layout = new GridLayout();
        layout.makeColumnsEqualWidth = true;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.numColumns = nbCols;
        this.setLayout((Layout)layout);
        String[] wdOneBased = new DateFormatSymbols(Locale.getDefault()).getShortWeekdays();
        String[] wdZeroBased = new String[7];
        System.arraycopy(wdOneBased, 1, wdZeroBased, 0, 7);
        int wdOffset = this.m_calendar.getFirstDayOfWeek() - 1;
        int i = 0;
        while (i < nbCols) {
            Label l = new Label((Composite)this, 0x1000000);
            if (nbCols == 6 && i == nbCols - 1) {
                String day1 = wdZeroBased[(i + wdOffset) % 7];
                String day2 = wdZeroBased[(i + 1 + wdOffset) % 7];
                l.setText(String.valueOf(day1) + "/" + day2);
            } else {
                l.setText(wdZeroBased[(i + wdOffset) % 7]);
            }
            l.setBackground(SwtColors.getInstance().white);
            gd = new GridData();
            gd.horizontalAlignment = 2;
            gd.grabExcessHorizontalSpace = true;
            l.setLayoutData((Object)gd);
            this.labelList.add(l);
            ++i;
        }
        this.addPaintListener(this);
    }

    public void paintControl(PaintEvent e) {
        this.setBackground(SwtColors.getInstance().white);
        this.setForeground(SwtColors.getInstance().gray);
        Rectangle bounds = this.getBounds();
        e.gc.drawRectangle(0, 0, bounds.width - 1, bounds.height - 1);
    }

    public void dispose() {
        for (Label l : this.labelList) {
            if (l == null || l.isDisposed()) continue;
            l.dispose();
        }
        super.dispose();
    }
}

