/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.basic.calendar.widgets;

import org.eclipse.scout.rt.ui.swt.basic.calendar.CalendarItemContainer;
import org.eclipse.scout.rt.ui.swt.basic.calendar.SwtColors;
import org.eclipse.scout.rt.ui.swt.basic.calendar.widgets.AbstractCalendarItem;
import org.eclipse.scout.rt.ui.swt.basic.calendar.widgets.AbstractCell;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;

public class MonthCalendarItem
extends AbstractCalendarItem {
    public MonthCalendarItem(AbstractCell parent, int style, CalendarItemContainer item) {
        super(parent, style, item);
    }

    @Override
    protected void createControls() {
    }

    @Override
    protected void setLayout() {
        GridData gd2 = new GridData();
        gd2.horizontalAlignment = 4;
        gd2.grabExcessHorizontalSpace = true;
        gd2.horizontalSpan = 2;
        gd2.heightHint = 15;
        this.setLayoutData(gd2);
    }

    @Override
    protected void hookListeners() {
        super.hookListeners();
    }

    @Override
    public void paintControl(PaintEvent e) {
        Color color = new Color((Device)SwtColors.getStandardDisplay(), this.m_item.getColor().getRed(), this.m_item.getColor().getGreen(), this.m_item.getColor().getBlue());
        if (this.m_item.getItem().equals(this.m_cell.getCalendar().getSelectedItem())) {
            color = SwtColors.getInstance().getDarker(color);
        }
        this.setBackground(color);
        Rectangle r = this.getBounds();
        r.x = 0;
        r.y = 0;
        this.m_item.setLabeled(true);
        FontMetrics fm = e.gc.getFontMetrics();
        if (this.m_item.isLabeled()) {
            String s = this.m_cell.getCalendar().getModel().getLabel(this.m_item.getItem(), this.m_cell.getDate().getTime());
            int centery = Math.max(0, (r.height - fm.getAscent()) / 2 - 3);
            e.gc.drawString(s, r.x + 3, r.y + centery);
        }
    }

    public void dispose() {
        super.dispose();
    }
}

