/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.basic.calendar.widgets;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.eclipse.scout.rt.client.ui.basic.calendar.DateTimeFormatFactory;
import org.eclipse.scout.rt.ui.swt.basic.calendar.CalendarConstants;
import org.eclipse.scout.rt.ui.swt.basic.calendar.layout.MonthCellData;
import org.eclipse.scout.rt.ui.swt.basic.calendar.widgets.AbstractCell;
import org.eclipse.scout.rt.ui.swt.basic.calendar.widgets.SwtCalendar;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class MonthCell
extends AbstractCell
implements TraverseListener,
CalendarConstants {
    public MonthCell(Composite parent, int style, SwtCalendar calendar, Date cellDate, boolean isFirstColumn, boolean isCurrentMonth) {
        super(parent, style);
        this.m_calendar = calendar;
        this.m_cellDate = Calendar.getInstance();
        this.m_cellDate.setTime(cellDate);
        this.m_isFirstColumn = isFirstColumn;
        this.m_isCurrentPeriod = isCurrentMonth;
        this.m_isSelected = false;
        this.createControls();
        this.setVisualState();
        this.addCalendarItems();
        this.hookListeners();
    }

    public void keyTraversed(TraverseEvent e) {
    }

    protected void createControls() {
        int vertSpan = 2;
        int day = this.m_cellDate.get(7);
        int firstDay = this.m_calendar.getFirstDayOfWeek();
        int weekEndDay1 = (firstDay - 1 + 5) % 7 + 1;
        int weekEndDay2 = (firstDay - 1 + 6) % 7 + 1;
        if (this.m_calendar.getCondensedMode() && (day == weekEndDay1 || day == weekEndDay2)) {
            vertSpan = 1;
        }
        MonthCellData cd = new MonthCellData();
        cd.verticalSpan = vertSpan;
        this.setLayoutData(cd);
        GridLayout layout = new GridLayout();
        layout.marginTop = 12;
        layout.marginWidth = 2;
        layout.marginHeight = 3;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 1;
        layout.numColumns = 2;
        this.setLayout((Layout)layout);
    }

    @Override
    protected void drawLabels(PaintEvent e) {
        if (this.m_isFirstColumn) {
            this.drawWeekLabel(e);
        }
        this.drawDayLabel(e);
    }

    @Override
    public String toString() {
        SimpleDateFormat weekDayFmt = new SimpleDateFormat("EEEEE", Locale.getDefault());
        DateFormat dateFmt = new DateTimeFormatFactory().getDayMonthYear(1);
        return "MonthCell {" + weekDayFmt.format(this.m_cellDate.getTime()) + " " + dateFmt.format(this.m_cellDate.getTime()) + "}";
    }

    @Override
    public void dispose() {
        super.dispose();
    }
}

