/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.basic.calendar.widgets;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.eclipse.scout.rt.client.ui.basic.calendar.DateTimeFormatFactory;
import org.eclipse.scout.rt.ui.swt.basic.calendar.SwtColors;
import org.eclipse.scout.rt.ui.swt.basic.calendar.layout.WeekItemLayout;
import org.eclipse.scout.rt.ui.swt.basic.calendar.widgets.AbstractCalendarItem;
import org.eclipse.scout.rt.ui.swt.basic.calendar.widgets.AbstractCell;
import org.eclipse.scout.rt.ui.swt.basic.calendar.widgets.SwtCalendar;
import org.eclipse.scout.rt.ui.swt.basic.calendar.widgets.WeekCalendarItem;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public class WeekCell
extends AbstractCell {
    protected int m_realOffsetY;
    protected boolean m_drawHeader;
    protected int m_timelessCounter = 0;

    public WeekCell(Composite parent, int style, SwtCalendar calendar, Date cellDate, boolean isFirstColumn, boolean isCurrentMonth) {
        super(parent, style);
        this.m_calendar = calendar;
        this.m_cellDate = Calendar.getInstance();
        this.m_cellDate.setTime(cellDate);
        this.m_isFirstColumn = isFirstColumn;
        this.m_drawHeader = this.m_calendar.getDisplayMode() != 1;
        this.m_isSelected = false;
        this.m_isCurrentPeriod = isCurrentMonth;
        this.m_realOffsetY = this.m_drawHeader ? 13 : 0;
        this.createControls();
        this.setVisualState();
        this.hookListeners();
    }

    protected void createControls() {
        int vertSpan = 2;
        int day = this.m_cellDate.get(7);
        int firstDay = this.m_calendar.getFirstDayOfWeek();
        int weekEndDay1 = (firstDay - 1 + 5) % 7 + 1;
        int weekEndDay2 = (firstDay - 1 + 6) % 7 + 1;
        if (this.m_calendar.getCondensedMode() && this.m_calendar.getDisplayMode() == 2 && (day == weekEndDay1 || day == weekEndDay2)) {
            vertSpan = 1;
        }
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.verticalSpan = vertSpan;
        this.setLayoutData(gd);
        WeekItemLayout layout = new WeekItemLayout();
        this.setLayout(layout);
    }

    @Override
    protected void setVisualState() {
        if (this.m_drawHeader) {
            super.setVisualState();
        }
    }

    @Override
    protected void drawTimeline(PaintEvent e) {
        Rectangle clipRect = this.getBounds();
        int timelessMaxCount = this.m_calendar.getCentralPanel().getTimelessMaxCount();
        int timelessHeight = Math.min(24 * timelessMaxCount, 33 * clipRect.height / 100);
        int hTimeless = Math.max(0, timelessHeight - 1);
        int yTimed = this.m_realOffsetY + hTimeless + 1;
        Rectangle bounds = this.getBounds();
        int slots = 14;
        double deltaY = (double)(bounds.height - yTimed) / ((double)slots * 1.0);
        e.gc.setForeground(this.BORDER_UNSELECTED_COLOR);
        int x1 = 1;
        int y1 = (int)Math.round(deltaY * 6.0) + yTimed;
        int x2 = bounds.width - 3;
        int y2 = (int)Math.round(deltaY);
        Rectangle noon = new Rectangle(x1, y1, x2, y2);
        e.gc.setBackground(SwtColors.getInstance().lightgray);
        e.gc.fillRectangle(noon);
        e.gc.setBackground(SwtColors.getInstance().white);
        int time = 6;
        int i = 0;
        while (i < slots) {
            int y = (int)Math.round(deltaY * (double)i) + yTimed;
            e.gc.drawLine(0, y, bounds.width - 1, y);
            ++time;
            ++i;
        }
    }

    @Override
    public void addCalendarItems() {
        super.addCalendarItems();
    }

    public void setItemsLayoutData() {
        if (this.m_widgetItems != null) {
            for (AbstractCalendarItem item : this.m_widgetItems) {
                WeekCalendarItem it = (WeekCalendarItem)item;
                it.setLayoutData();
            }
        }
    }

    @Override
    protected void drawLabels(PaintEvent e) {
        if (this.m_drawHeader) {
            if (this.m_isFirstColumn) {
                this.drawWeekLabel(e);
            }
            this.drawDayLabel(e);
        }
    }

    public int getNextTimelessCounter() {
        return this.m_timelessCounter++;
    }

    public void resetTimelessCounter() {
        this.m_timelessCounter = 0;
    }

    @Override
    protected void disposeCalendarItems() {
        super.disposeCalendarItems();
        this.resetTimelessCounter();
    }

    @Override
    public String toString() {
        SimpleDateFormat weekDayFmt = new SimpleDateFormat("EEEEE", Locale.getDefault());
        DateFormat dateFmt = new DateTimeFormatFactory().getDayMonthYear(1);
        return "WeekCell {" + weekDayFmt.format(this.m_cellDate.getTime()) + " " + dateFmt.format(this.m_cellDate.getTime()) + "}";
    }
}

