/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.basic.table;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorDeactivationEvent;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.booleanfield.IBooleanField;
import org.eclipse.scout.rt.ui.swt.basic.ISwtScoutComposite;
import org.eclipse.scout.rt.ui.swt.basic.table.ISwtScoutTable;
import org.eclipse.scout.rt.ui.swt.ext.table.TableViewerEx;
import org.eclipse.scout.rt.ui.swt.extension.UiDecorationExtensionPoint;
import org.eclipse.scout.rt.ui.swt.keystroke.SwtKeyStroke;
import org.eclipse.scout.rt.ui.swt.util.SwtUtility;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class SwtScoutTableCellEditor {
    private static final String DUMMY_VALUE = "Dummy";
    private final ISwtScoutTable m_tableComposite;
    private final Listener m_rowHeightListener;
    private boolean m_tableIsEditingAndContainsFocus;

    public SwtScoutTableCellEditor(ISwtScoutTable tableComposite) {
        this.m_tableComposite = tableComposite;
        this.m_rowHeightListener = new Listener(){

            public void handleEvent(Event event) {
                event.height = Math.max(event.height, UiDecorationExtensionPoint.getLookAndFeel().getLogicalGridLayoutRowHeight());
            }
        };
    }

    public void initialize() {
        TableViewer viewer = this.m_tableComposite.getSwtTableViewer();
        String[] columnPropertyNames = new String[viewer.getTable().getColumnCount()];
        CellEditor[] oldEditors = viewer.getCellEditors();
        CellEditor[] newEditors = new CellEditor[columnPropertyNames.length];
        boolean hasEditors = false;
        int i = 0;
        while (i < columnPropertyNames.length) {
            TableColumn swtCol = viewer.getTable().getColumn(i);
            IColumn scoutCol = (IColumn)swtCol.getData("scoutColumn");
            if (scoutCol != null) {
                columnPropertyNames[i] = "" + scoutCol.getColumnIndex();
                if (scoutCol.isEditable()) {
                    hasEditors = true;
                    newEditors[i] = new P_SwtCellEditor((Composite)viewer.getTable());
                }
            } else {
                columnPropertyNames[i] = "";
            }
            ++i;
        }
        viewer.setCellModifier((ICellModifier)new P_SwtCellModifier());
        viewer.setColumnProperties(columnPropertyNames);
        viewer.setCellEditors(newEditors);
        if (oldEditors != null && oldEditors.length > 0) {
            CellEditor[] cellEditorArray = oldEditors;
            int n = oldEditors.length;
            int n2 = 0;
            while (n2 < n) {
                CellEditor editor = cellEditorArray[n2];
                if (editor != null) {
                    editor.dispose();
                }
                ++n2;
            }
        }
        if (hasEditors) {
            viewer.getTable().addListener(41, this.m_rowHeightListener);
        } else {
            viewer.getTable().removeListener(41, this.m_rowHeightListener);
        }
        this.m_tableComposite.getEnvironment().getDisplay().addFilter(15, new Listener(){

            public void handleEvent(Event e) {
                TableViewer v;
                Widget c = e.widget;
                if (c == null || !(c instanceof Control)) {
                    return;
                }
                boolean oldValue = SwtScoutTableCellEditor.this.m_tableIsEditingAndContainsFocus;
                boolean newValue = SwtUtility.isAncestorOf(SwtScoutTableCellEditor.this.m_tableComposite.getSwtField(), (Control)c);
                SwtScoutTableCellEditor.this.m_tableIsEditingAndContainsFocus = newValue;
                if (oldValue && !newValue && (v = SwtScoutTableCellEditor.this.m_tableComposite.getSwtTableViewer()) instanceof TableViewerEx) {
                    ((TableViewerEx)v).applyEditorValue();
                }
            }
        });
    }

    protected Control getEditorControl(Composite parent, ITableRow scoutRow, IColumn<?> scoutCol) {
        Composite swtEditorControl = null;
        ISwtScoutComposite<? extends IFormField> editorComposite = this.createEditorComposite(parent, scoutRow, scoutCol);
        if (editorComposite != null) {
            this.decorateEditorComposite(editorComposite, scoutRow, scoutCol);
            swtEditorControl = editorComposite.getSwtContainer();
        }
        return swtEditorControl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ISwtScoutComposite<? extends IFormField> createEditorComposite(Composite parent, final ITableRow scoutRow, final IColumn<?> scoutCol) {
        final AtomicReference fieldRef = new AtomicReference();
        if (scoutRow != null && scoutCol != null) {
            Runnable t = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    fieldRef.set(((ITable)SwtScoutTableCellEditor.this.m_tableComposite.getScoutObject()).getUIFacade().prepareCellEditFromUI(scoutRow, scoutCol));
                    AtomicReference atomicReference = fieldRef;
                    synchronized (atomicReference) {
                        fieldRef.notifyAll();
                    }
                }
            };
            AtomicReference atomicReference = fieldRef;
            synchronized (atomicReference) {
                this.m_tableComposite.getEnvironment().invokeScoutLater(t, 2345L);
                try {
                    fieldRef.wait(2345L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (fieldRef.get() != null) {
            return this.m_tableComposite.getEnvironment().createFormField(parent, (IFormField)fieldRef.get());
        }
        return null;
    }

    protected void decorateEditorComposite(ISwtScoutComposite<? extends IFormField> editorComposite, ITableRow scoutRow, IColumn<?> scoutCol) {
        if (editorComposite.getScoutObject() instanceof IBooleanField) {
            final IBooleanField cb = (IBooleanField)editorComposite.getScoutObject();
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    cb.getUIFacade().setSelectedFromUI(!cb.isChecked());
                }
            };
            editorComposite.getEnvironment().invokeScoutLater(t, 0L);
        }
    }

    protected void saveEditorFromSwt() {
        this.m_tableIsEditingAndContainsFocus = false;
        Runnable t = new Runnable(){

            @Override
            public void run() {
                ((ITable)SwtScoutTableCellEditor.this.m_tableComposite.getScoutObject()).getUIFacade().completeCellEditFromUI();
            }
        };
        this.m_tableComposite.getEnvironment().invokeScoutLater(t, 0L);
    }

    protected void cancelEditorFromSwt() {
        this.m_tableIsEditingAndContainsFocus = false;
        Runnable t = new Runnable(){

            @Override
            public void run() {
                ((ITable)SwtScoutTableCellEditor.this.m_tableComposite.getScoutObject()).getUIFacade().cancelCellEditFromUI();
            }
        };
        this.m_tableComposite.getEnvironment().invokeScoutLater(t, 0L);
    }

    protected IColumn<?> getScoutColumn(String property) {
        if (property != null && property.matches("[0-9]+")) {
            int colIndex = Integer.parseInt(property);
            return ((ITable)this.m_tableComposite.getScoutObject()).getColumnSet().getColumn(colIndex);
        }
        return null;
    }

    private class P_SwtCellEditor
    extends CellEditor {
        private Composite m_container;
        private Object m_value;

        protected P_SwtCellEditor(Composite parent) {
            super(parent);
        }

        protected Control createControl(Composite parent) {
            this.m_container = new Composite(parent, 0){

                public Point computeSize(int wHint, int hHint, boolean changed) {
                    return new Point(wHint, hHint);
                }
            };
            this.m_container.setLayout((Layout)new FillLayout());
            SwtScoutTableCellEditor.this.m_tableComposite.getEnvironment().addKeyStroke((Widget)this.m_container, new SwtKeyStroke(27){

                @Override
                public void handleSwtAction(Event e) {
                    e.doit = false;
                    P_SwtCellEditor.this.fireCancelEditor();
                }
            });
            SwtScoutTableCellEditor.this.m_tableComposite.getEnvironment().addKeyStroke((Widget)this.m_container, new SwtKeyStroke(13){

                @Override
                public void handleSwtAction(Event e) {
                    e.doit = false;
                    P_SwtCellEditor.this.fireApplyEditorValue();
                    P_SwtCellEditor.this.deactivate();
                }
            });
            return this.m_container;
        }

        protected void doSetFocus() {
            this.m_container.traverse(16);
            Control focusControl = this.m_container.getDisplay().getFocusControl();
            if (focusControl != null) {
                focusControl.addTraverseListener(new TraverseListener(){

                    public void keyTraversed(TraverseEvent e) {
                        if (e.detail == 2 || e.detail == 4) {
                            e.doit = false;
                        }
                    }
                });
            }
        }

        protected Object doGetValue() {
            return this.m_value;
        }

        protected void doSetValue(Object value) {
            this.m_value = value;
        }

        public void activate(ColumnViewerEditorActivationEvent e) {
            if (e.getSource() instanceof ViewerCell) {
                ViewerCell cell = (ViewerCell)e.getSource();
                TableViewer viewer = SwtScoutTableCellEditor.this.m_tableComposite.getSwtTableViewer();
                TableColumn swtCol = viewer.getTable().getColumn(cell.getColumnIndex());
                IColumn scoutCol = (IColumn)swtCol.getData("scoutColumn");
                ITableRow scoutRow = (ITableRow)cell.getElement();
                if (scoutRow != null && scoutCol != null) {
                    SwtScoutTableCellEditor.this.getEditorControl(this.m_container, scoutRow, scoutCol);
                }
                this.m_container.layout(true, true);
                this.m_container.setVisible(true);
            }
        }

        protected void deactivate(ColumnViewerEditorDeactivationEvent e) {
            Control[] controlArray = this.m_container.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                c.dispose();
                ++n2;
            }
            super.deactivate(e);
            if (e.eventType == 1) {
                SwtScoutTableCellEditor.this.cancelEditorFromSwt();
            }
        }
    }

    private class P_SwtCellModifier
    implements ICellModifier {
        private P_SwtCellModifier() {
        }

        public void modify(Object element, String property, Object value) {
            SwtScoutTableCellEditor.this.saveEditorFromSwt();
        }

        public Object getValue(Object element, String property) {
            return SwtScoutTableCellEditor.DUMMY_VALUE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean canModify(Object element, String property) {
            AtomicBoolean b;
            final ITable table = (ITable)SwtScoutTableCellEditor.this.m_tableComposite.getScoutObject();
            final ITableRow row = (ITableRow)element;
            final IColumn<?> column = SwtScoutTableCellEditor.this.getScoutColumn(property);
            AtomicBoolean atomicBoolean = b = new AtomicBoolean();
            synchronized (atomicBoolean) {
                Runnable r = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        AtomicBoolean atomicBoolean = b;
                        synchronized (atomicBoolean) {
                            try {
                                if (table != null && row != null && column != null) {
                                    b.set(table.isCellEditable(row, column));
                                }
                            }
                            catch (Throwable throwable) {}
                            b.notifyAll();
                        }
                    }
                };
                SwtScoutTableCellEditor.this.m_tableComposite.getEnvironment().invokeScoutLater(r, 2345L);
                try {
                    b.wait(2345L);
                }
                catch (InterruptedException interruptedException) {}
            }
            return b.get();
        }
    }
}

