/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.basic.table;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.rt.client.ui.basic.cell.ICell;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.shared.AbstractIcons;
import org.eclipse.scout.rt.ui.swt.Activator;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.scout.rt.ui.swt.basic.table.SwtScoutTable;
import org.eclipse.scout.rt.ui.swt.basic.table.TableColumnManager;
import org.eclipse.scout.rt.ui.swt.extension.UiDecorationExtensionPoint;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class SwtScoutTableModel
implements IStructuredContentProvider,
ITableColorProvider,
ITableLabelProvider,
ITableFontProvider {
    private static final boolean COMPOSITE_ICON_ENABLED = "true".equals(Activator.getDefault().getBundle().getBundleContext().getProperty("scout.fix355669"));
    private transient ListenerList listenerList = null;
    private final ITable m_table;
    private final ISwtEnvironment m_environment;
    private final SwtScoutTable m_swtTable;
    private final TableColumnManager m_columnManager;
    private Image m_imgCheckboxFalse;
    private Image m_imgCheckboxTrue;
    private Color m_disabledForegroundColor;

    public SwtScoutTableModel(ITable table, SwtScoutTable swtTable, ISwtEnvironment environment, TableColumnManager columnManager) {
        this.m_table = table;
        this.m_swtTable = swtTable;
        this.m_environment = environment;
        this.m_columnManager = columnManager;
        this.m_imgCheckboxTrue = this.m_environment.getIcon(AbstractIcons.CheckboxYes);
        this.m_imgCheckboxFalse = this.m_environment.getIcon(AbstractIcons.CheckboxNo);
        this.m_disabledForegroundColor = this.m_environment.getColor(UiDecorationExtensionPoint.getLookAndFeel().getColorForegroundDisabled());
    }

    public boolean isMultiline() {
        if (this.m_table != null) {
            return this.m_table.isMultilineText();
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        if (this.m_table != null) {
            return this.m_table.getFilteredRows();
        }
        return new Object[0];
    }

    public Color getBackground(Object element, int columnIndex) {
        ICell cell;
        if (columnIndex > 0 && (cell = this.getCell(element, columnIndex)) != null) {
            return this.m_environment.getColor(cell.getBackgroundColor());
        }
        return null;
    }

    public Color getForeground(Object element, int columnIndex) {
        if (columnIndex > 0) {
            ITableRow scoutRow = (ITableRow)element;
            ICell scoutCell = this.getCell(element, columnIndex);
            if (scoutCell == null) {
                return null;
            }
            Color col = this.m_environment.getColor(scoutCell.getForegroundColor());
            if (!(col != null || scoutRow.isEnabled() && scoutCell.isEnabled())) {
                col = this.m_disabledForegroundColor;
            }
            return col;
        }
        return null;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        int[] columnOrder = this.m_swtTable.getSwtField().getColumnOrder();
        if (columnOrder.length > 1) {
            IColumn<?> col = this.m_columnManager.getColumnByModelIndex(columnIndex - 1);
            ICell cell = this.getCell(element, columnIndex);
            Image checkBoxImage = null;
            if (columnOrder[1] == columnIndex && this.m_swtTable.getScoutObject() != null && ((ITable)this.m_swtTable.getScoutObject()).isCheckable()) {
                checkBoxImage = ((ITableRow)element).isChecked() ? this.m_imgCheckboxTrue : this.m_imgCheckboxFalse;
            } else if (col != null && cell != null && col.getDataType() == Boolean.class) {
                Boolean b = (Boolean)cell.getValue();
                checkBoxImage = b != null && b != false ? this.m_imgCheckboxTrue : this.m_imgCheckboxFalse;
            }
            String iconId = null;
            if (cell != null && cell.getIconId() != null) {
                iconId = cell.getIconId();
            } else if (columnOrder[1] == columnIndex) {
                ITableRow row = (ITableRow)element;
                iconId = row.getIconId();
            }
            Image decoImage = this.m_environment.getIcon(iconId);
            if (COMPOSITE_ICON_ENABLED && checkBoxImage != null && decoImage != null) {
                String key = String.valueOf(checkBoxImage == this.m_imgCheckboxTrue ? AbstractIcons.CheckboxYes : AbstractIcons.CheckboxYes) + "_" + iconId;
                ImageRegistry reg = Activator.getDefault().getImageRegistry();
                Image compositeImage = reg.get(key);
                if (compositeImage == null) {
                    int w1 = checkBoxImage.getBounds().width;
                    int w2 = decoImage.getBounds().width;
                    int h = Math.max(checkBoxImage.getBounds().height, decoImage.getBounds().height);
                    compositeImage = new Image((Device)Display.getCurrent(), w1 + w2, h);
                    GC gc = new GC((Drawable)compositeImage);
                    gc.drawImage(checkBoxImage, 0, 0);
                    gc.drawImage(decoImage, w1, 0);
                    gc.dispose();
                    reg.put(key, compositeImage);
                }
                return compositeImage;
            }
            if (checkBoxImage != null) {
                return checkBoxImage;
            }
            if (decoImage != null) {
                return decoImage;
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (columnIndex > 0) {
            ICell cell = this.getCell(element, columnIndex);
            if (cell == null) {
                return "";
            }
            String text = cell.getText();
            if (!this.isMultiline()) {
                text = StringUtility.removeNewLines((String)text);
            }
            return text;
        }
        return "";
    }

    public Font getFont(Object element, int columnIndex) {
        ICell cell;
        if (columnIndex > 0 && (cell = this.getCell(element, columnIndex)) != null) {
            return this.m_environment.getFont(cell.getFont(), this.m_swtTable.getSwtField().getFont());
        }
        return null;
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void addListener(ILabelProviderListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new ListenerList(1);
        }
        this.listenerList.add((Object)listener);
    }

    public void removeListener(ILabelProviderListener listener) {
        if (this.listenerList != null) {
            this.listenerList.remove((Object)listener);
            if (this.listenerList.isEmpty()) {
                this.listenerList = null;
            }
        }
    }

    private Object[] getListeners() {
        ListenerList list = this.listenerList;
        if (list == null) {
            return new Object[0];
        }
        return list.getListeners();
    }

    public void dispose() {
        if (this.listenerList != null) {
            this.listenerList.clear();
        }
    }

    protected void fireLabelProviderChanged(final LabelProviderChangedEvent event) {
        Object[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final ILabelProviderListener l = (ILabelProviderListener)listeners[i];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.labelProviderChanged(event);
                }
            });
            ++i;
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    protected ICell getCell(Object row, int colIndex) {
        IColumn<?> column = this.m_columnManager.getColumnByModelIndex(colIndex - 1);
        if (column != null) {
            return this.m_table.getCell((ITableRow)row, column);
        }
        return null;
    }

    public SwtScoutTable getSwtScoutTable() {
        return this.m_swtTable;
    }
}

