/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.basic.table;

import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.ui.swt.basic.table.AbstractKeyboardNavigationSupport;
import org.eclipse.scout.rt.ui.swt.ext.table.TableEx;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;

public abstract class TableKeyboardNavigationSupport
extends AbstractKeyboardNavigationSupport {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(TableKeyboardNavigationSupport.class);
    private final TableEx m_table;
    private Listener m_tableListener;
    private int m_contextColumnIndex;
    private static final int EVENT_TYPE_KEY = 1;
    private DisposeListener m_disposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            TableKeyboardNavigationSupport.this.detachListeners();
        }
    };

    public TableKeyboardNavigationSupport(TableEx table) {
        this(table, 500L);
    }

    public TableKeyboardNavigationSupport(TableEx table, long delay) {
        super(delay);
        this.m_table = table;
        this.attachListeners();
    }

    public void dispose() {
        this.detachListeners();
    }

    public void resetContextColumnIndex() {
        this.m_contextColumnIndex = -1;
    }

    private void attachListeners() {
        if (this.m_tableListener == null) {
            this.m_tableListener = new P_TableListener();
            this.m_table.addListener(3, this.m_tableListener);
            this.m_table.addListener(1, this.m_tableListener);
        }
        this.m_table.addDisposeListener(this.m_disposeListener);
    }

    private void detachListeners() {
        if (this.m_tableListener != null) {
            this.m_table.removeListener(3, this.m_tableListener);
            this.m_table.removeListener(1, this.m_tableListener);
            this.m_tableListener = null;
        }
        this.m_table.removeDisposeListener(this.m_disposeListener);
    }

    @Override
    void handleSearchPattern(final String regex) {
        this.m_table.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                int column = TableKeyboardNavigationSupport.this.m_contextColumnIndex;
                if (column < 0) {
                    int i = 0;
                    while (i < TableKeyboardNavigationSupport.this.m_table.getColumnCount()) {
                        if (TableKeyboardNavigationSupport.this.m_table.getSortColumn() == TableKeyboardNavigationSupport.this.m_table.getColumn(i)) {
                            column = i;
                            break;
                        }
                        ++i;
                    }
                }
                if (column < 0 && TableKeyboardNavigationSupport.this.m_table.getColumnCount() > 0) {
                    column = 0;
                }
                if (column < 0) {
                    return;
                }
                if (LOG.isInfoEnabled()) {
                    LOG.info("finding regex:" + regex + " in column " + TableKeyboardNavigationSupport.this.m_table.getColumn(column).getText());
                }
                int startIndex = 0;
                startIndex = TableKeyboardNavigationSupport.this.m_table.getSelectionIndex() < 0 ? 0 : TableKeyboardNavigationSupport.this.m_table.getSelectionIndex() + 1;
                int itemCount = TableKeyboardNavigationSupport.this.m_table.getItemCount();
                int i = 0;
                while (i < itemCount) {
                    TableItem tableItem = TableKeyboardNavigationSupport.this.m_table.getItem((startIndex + i) % itemCount);
                    String itemText = tableItem.getText(column);
                    if (itemText != null && itemText.toLowerCase().matches(regex)) {
                        TableKeyboardNavigationSupport.this.handleKeyboardNavigation(tableItem);
                        return;
                    }
                    ++i;
                }
            }
        });
    }

    abstract void handleKeyboardNavigation(TableItem var1);

    private class P_TableListener
    implements Listener {
        private P_TableListener() {
        }

        public void handleEvent(Event event) {
            if (event.doit) {
                block0 : switch (event.type) {
                    case 1: {
                        if (event.stateMask != 0 && event.stateMask != 131072 || !Character.isLetter((char)event.keyCode) || event.keyCode == 0x1000050) break;
                        TableKeyboardNavigationSupport.this.addChar(Character.toLowerCase((char)event.keyCode));
                        break;
                    }
                    case 3: {
                        Point p = new Point(event.x, event.y);
                        TableItem item = TableKeyboardNavigationSupport.this.m_table.getItem(p);
                        if (item == null) break;
                        int i = 0;
                        while (i < TableKeyboardNavigationSupport.this.m_table.getColumnCount()) {
                            Rectangle rect = item.getBounds(i);
                            if (rect.contains(p)) {
                                TableKeyboardNavigationSupport.this.m_contextColumnIndex = i;
                                break block0;
                            }
                            ++i;
                        }
                        break;
                    }
                }
            }
        }
    }
}

