/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.basic.table.internal;

import java.util.Vector;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorDeactivationEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class SnippetForTableEditor {
    final String[][] database = new String[][]{{"A1", "B1", "C1"}, {"A2", "B2", "C2"}, {"A3", "B3", "C3"}};
    final TableViewer viewer;

    public static void main(String[] args) {
        new SnippetForTableEditor();
    }

    SnippetForTableEditor() {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        Table table = new Table((Composite)shell, 67586);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        int i = 0;
        while (i < 3) {
            TableColumn column = new TableColumn(table, 0);
            column.setWidth(100);
            column.setMoveable(true);
            ++i;
        }
        this.viewer = new TableViewer(table);
        ContentProvider content = new ContentProvider();
        this.viewer.setContentProvider((IContentProvider)content);
        this.viewer.setLabelProvider((IBaseLabelProvider)content);
        this.viewer.setColumnProperties(new String[]{"A", "B", "C"});
        AdHocCellEditor cellEditor = new AdHocCellEditor((Composite)this.viewer.getTable());
        CellEditor[] cellEditorArray = new CellEditor[3];
        cellEditorArray[0] = cellEditor;
        cellEditorArray[2] = cellEditor;
        this.viewer.setCellEditors(cellEditorArray);
        this.viewer.setCellModifier((ICellModifier)new CellModifier());
        this.viewer.setInput((Object)System.currentTimeMillis());
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    class AdHocCellEditor
    extends CellEditor {
        private Composite m_container;

        public AdHocCellEditor(Composite parent) {
            super(parent);
        }

        public void activate(ColumnViewerEditorActivationEvent e) {
            if (e.getSource() instanceof ViewerCell) {
                ViewerCell cell = (ViewerCell)e.getSource();
                System.out.println("row: " + cell.getElement() + ", col: " + cell.getColumnIndex());
                Text text = new Text(this.m_container, 2048);
                text.setText("abc");
                this.m_container.layout(true, true);
                this.m_container.setVisible(true);
            }
        }

        protected void deactivate(ColumnViewerEditorDeactivationEvent event) {
            Control[] controlArray = this.m_container.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                c.dispose();
                ++n2;
            }
            super.deactivate(event);
            if (event.eventType == 1) {
                System.out.println("canceled");
            }
        }

        protected Control createControl(Composite parent) {
            this.m_container = new Composite(parent, 0);
            this.m_container.setLayout((Layout)new FillLayout());
            return this.m_container;
        }

        protected Object doGetValue() {
            return "ABC";
        }

        protected void doSetFocus() {
            this.m_container.setFocus();
        }

        protected void doSetValue(Object value) {
        }
    }

    class CellModifier
    implements ICellModifier {
        CellModifier() {
        }

        public void modify(Object element, String property, Object value) {
            if (element instanceof TableItem) {
                TableItem item = (TableItem)element;
                String[] row = (String[])item.getData();
                System.out.println("Modified " + property + " " + value);
                if ("A".equals(property)) {
                    row[0] = (String)value;
                } else if ("B".equals(property)) {
                    row[1] = (String)value;
                } else if ("C".equals(property)) {
                    row[2] = (String)value;
                }
                SnippetForTableEditor.this.viewer.setInput((Object)System.currentTimeMillis());
            }
        }

        public Object getValue(Object element, String property) {
            if ("A".equals(property)) {
                return ((String[])element)[0];
            }
            if ("B".equals(property)) {
                return ((String[])element)[1];
            }
            if ("C".equals(property)) {
                return ((String[])element)[2];
            }
            return null;
        }

        public boolean canModify(Object element, String property) {
            return true;
        }
    }

    class ContentProvider
    implements ITableLabelProvider,
    IStructuredContentProvider {
        private final Vector<ILabelProviderListener> listeners = new Vector();

        ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return SnippetForTableEditor.this.database;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer2, Object oldInput, Object newInput) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return ((String[])element)[columnIndex];
        }

        public void addListener(ILabelProviderListener listener) {
            this.listeners.add(listener);
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
            this.listeners.remove(listener);
        }
    }
}

