/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.basic.tree;

import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.basic.cell.ICell;
import org.eclipse.scout.rt.client.ui.basic.tree.ITree;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.shared.AbstractIcons;
import org.eclipse.scout.rt.ui.swt.Activator;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.scout.rt.ui.swt.extension.UiDecorationExtensionPoint;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class SwtScoutTreeModel
extends LabelProvider
implements ITreeContentProvider,
IFontProvider,
IColorProvider {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwtScoutTreeModel.class);
    private static final boolean COMPOSITE_ICON_ENABLED = "true".equals(Activator.getDefault().getBundle().getBundleContext().getProperty("scout.fix355669"));
    private ITree m_tree;
    private final ISwtEnvironment m_environment;
    private final TreeViewer m_treeViewer;
    private Image m_imgCheckboxTrue;
    private Image m_imgCheckboxFalse;
    private Color m_disabledForegroundColor;

    public SwtScoutTreeModel(ITree tree, ISwtEnvironment environment, TreeViewer treeViewer) {
        this.m_tree = tree;
        this.m_environment = environment;
        this.m_treeViewer = treeViewer;
        this.m_imgCheckboxTrue = this.m_environment.getIcon(AbstractIcons.CheckboxYes);
        this.m_imgCheckboxFalse = this.m_environment.getIcon(AbstractIcons.CheckboxNo);
        this.m_disabledForegroundColor = this.m_environment.getColor(UiDecorationExtensionPoint.getLookAndFeel().getColorForegroundDisabled());
    }

    public Object[] getChildren(Object parentElement) {
        ITreeNode scoutNode = (ITreeNode)parentElement;
        return scoutNode.getFilteredChildNodes();
    }

    public Object getParent(Object element) {
        ITreeNode scoutNode = (ITreeNode)element;
        return scoutNode.getParentNode();
    }

    public boolean hasChildren(Object element) {
        ITreeNode scoutNode = (ITreeNode)element;
        return !scoutNode.isLeaf();
    }

    public Object[] getElements(Object inputElement) {
        if (this.m_tree != null) {
            if (this.m_tree.isRootNodeVisible()) {
                return new Object[]{this.m_tree.getRootNode()};
            }
            return this.m_tree.getRootNode().getFilteredChildNodes();
        }
        return new Object[0];
    }

    public Image getImage(Object element) {
        ITreeNode scoutNode = (ITreeNode)element;
        if (scoutNode == null) {
            return null;
        }
        Image checkBoxImage = null;
        if (this.m_tree.isCheckable()) {
            checkBoxImage = scoutNode.isChecked() ? this.m_imgCheckboxTrue : this.m_imgCheckboxFalse;
        }
        String iconId = scoutNode.getCell().getIconId();
        Image decoImage = null;
        decoImage = this.m_environment.getIcon(iconId);
        if (COMPOSITE_ICON_ENABLED && checkBoxImage != null && decoImage != null) {
            String key = String.valueOf(checkBoxImage == this.m_imgCheckboxTrue ? AbstractIcons.CheckboxYes : AbstractIcons.CheckboxYes) + "_" + iconId;
            ImageRegistry reg = Activator.getDefault().getImageRegistry();
            Image compositeImage = reg.get(key);
            if (compositeImage == null) {
                int w1 = checkBoxImage.getBounds().width;
                int w2 = decoImage.getBounds().width;
                int h = Math.max(checkBoxImage.getBounds().height, decoImage.getBounds().height);
                compositeImage = new Image((Device)Display.getCurrent(), w1 + w2, h);
                GC gc = new GC((Drawable)compositeImage);
                gc.drawImage(checkBoxImage, 0, 0);
                gc.drawImage(decoImage, w1, 0);
                gc.dispose();
                reg.put(key, compositeImage);
            }
            return compositeImage;
        }
        if (checkBoxImage != null) {
            return checkBoxImage;
        }
        if (decoImage != null) {
            return decoImage;
        }
        return null;
    }

    public String getText(Object element) {
        ITreeNode scoutNode = (ITreeNode)element;
        String text = scoutNode.getCell().getText();
        text = StringUtility.removeNewLines((String)text);
        return text;
    }

    public Font getFont(Object element) {
        ITreeNode scoutNode = (ITreeNode)element;
        if (scoutNode.getCell().getFont() != null) {
            return this.m_environment.getFont(scoutNode.getCell().getFont(), this.m_treeViewer.getTree().getFont());
        }
        return null;
    }

    public Color getForeground(Object element) {
        ITreeNode scoutNode = (ITreeNode)element;
        ICell scoutCell = scoutNode.getCell();
        Color col = this.m_environment.getColor(scoutCell.getForegroundColor());
        if (col == null && !scoutCell.isEnabled()) {
            col = this.m_disabledForegroundColor;
        }
        return col;
    }

    public Color getBackground(Object element) {
        ITreeNode scoutNode = (ITreeNode)element;
        if (scoutNode.getCell().getBackgroundColor() != null) {
            return this.m_environment.getColor(scoutNode.getCell().getBackgroundColor());
        }
        return null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

