/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.ext;

import java.util.EventListener;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.rt.ui.swt.Activator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class DropDownButton
extends Canvas {
    private static final int BORDER = 3;
    private static final int GAP = 3;
    private String m_text = "";
    private Image m_image;
    private Image m_imageDisabled;
    private Rectangle m_buttonArea = new Rectangle(0, 0, 0, 0);
    private Rectangle m_dropDownArea = new Rectangle(0, 0, 0, 0);
    private EventListenerList m_eventListeners = new EventListenerList();
    private boolean m_mouseHover;
    private Point m_mouseDownPosition;
    private boolean m_dropdownEnabled = true;
    private boolean m_buttonEnabled = true;
    private Image m_dropDownIcon;
    private Image m_dropDownIconDisabled;
    private Color m_focusedHighlightBorderColor;
    private Color m_mouseOverHighlightColor;
    private Color m_borderColor;
    private Color m_borderColorDisabled;
    private Color m_textColor;
    private Color m_textColorDisabled;
    private Color m_backgroundGradient1;
    private Color m_backgroundGradient2;
    private Color m_backgroundGradient1MouseDown;
    private Color m_backgroundGradient2MouseDown;
    private Color m_backgroundDisabled;

    public DropDownButton(Composite parent, int style) {
        super(parent, style | 0x20000000);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                DropDownButton.this.paintInternal(e.gc);
            }
        });
        this.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                switch (e.detail) {
                    case 2: 
                    case 4: 
                    case 8: 
                    case 16: 
                    case 256: 
                    case 512: {
                        e.doit = true;
                    }
                }
            }
        });
        this.addListener(1, new Listener(){

            public void handleEvent(Event e) {
                DropDownButton.this.handleKeyEvent(e);
            }
        });
        this.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DropDownButton.this.redraw();
            }

            public void focusLost(FocusEvent e) {
                DropDownButton.this.redraw();
            }
        });
        this.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                DropDownButton.this.m_mouseHover = true;
                DropDownButton.this.redraw();
            }

            public void mouseExit(MouseEvent e) {
                DropDownButton.this.m_mouseHover = false;
                DropDownButton.this.redraw();
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                DropDownButton.this.m_mouseDownPosition = new Point(e.x, e.y);
                DropDownButton.this.redraw();
            }

            public void mouseUp(MouseEvent e) {
                Point pt = new Point(e.x, e.y);
                if (e.button == 1 && DropDownButton.this.getClientArea().contains(pt)) {
                    DropDownButton.this.handleSelectionInternal(e);
                }
                DropDownButton.this.m_mouseDownPosition = null;
                DropDownButton.this.redraw();
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DropDownButton.this.freeResources();
            }
        });
        this.initResources();
    }

    protected void handleSelectionInternal(MouseEvent event) {
        Point pt = new Point(event.x, event.y);
        if (this.m_buttonArea.contains(pt)) {
            Event e = new Event();
            e.button = event.button;
            e.count = event.count;
            e.data = event.data;
            e.display = event.display;
            e.stateMask = event.stateMask;
            e.time = event.time;
            e.widget = event.widget;
            e.x = event.x;
            e.y = event.y;
            this.fireSelectionEvent(new SelectionEvent(e));
        } else if (this.m_dropDownArea.contains(pt) && this.isDropdownEnabled() && this.getMenu() != null) {
            this.getMenu().setVisible(true);
        }
    }

    protected void handleKeyEvent(Event e) {
        switch (e.keyCode) {
            case 13: 
            case 32: {
                SelectionEvent selEvent = new SelectionEvent(e);
                this.fireSelectionEvent(selEvent);
                break;
            }
            case 0x1000002: {
                if (!this.isDropdownEnabled() || this.getMenu() == null) break;
                this.getMenu().setVisible(true);
            }
        }
    }

    public void fireSelectionEvent(SelectionEvent e) {
        if (this.isButtonEnabled()) {
            SelectionListener[] selectionListenerArray = (SelectionListener[])this.m_eventListeners.getListeners(SelectionListener.class);
            int n = selectionListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                SelectionListener l = selectionListenerArray[n2];
                l.widgetSelected(e);
                ++n2;
            }
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.m_eventListeners.add(SelectionListener.class, (EventListener)listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.m_eventListeners.remove(SelectionListener.class, (EventListener)listener);
    }

    public void setText(String text) {
        if (text == null) {
            text = "";
        }
        this.m_text = text;
        this.redraw();
    }

    public String getText() {
        return this.m_text;
    }

    public void setImage(Image image) {
        this.m_image = image;
        if (this.m_imageDisabled != null && !this.m_imageDisabled.isDisposed()) {
            this.m_imageDisabled.dispose();
            this.m_imageDisabled = null;
        }
        if (this.m_image != null) {
            this.m_imageDisabled = new Image((Device)this.getDisplay(), this.m_image, 1);
        }
        this.redraw();
    }

    public Image getImage() {
        return this.m_image;
    }

    public void setDropdownEnabled(boolean enabled) {
        this.m_dropdownEnabled = enabled;
        super.setEnabled(this.isButtonEnabled() || this.isDropdownEnabled());
        this.redraw();
    }

    public boolean isDropdownEnabled() {
        return this.m_dropdownEnabled;
    }

    public void setButtonEnabled(boolean enabled) {
        this.m_buttonEnabled = enabled;
        super.setEnabled(this.isButtonEnabled() || this.isDropdownEnabled());
        this.redraw();
    }

    public boolean isButtonEnabled() {
        return this.m_buttonEnabled;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.m_buttonEnabled = enabled;
        this.m_dropdownEnabled = enabled;
        this.redraw();
    }

    private void initResources() {
        this.m_borderColor = this.getDisplay().getSystemColor(17);
        this.m_borderColorDisabled = this.getDisplay().getSystemColor(18);
        this.m_textColor = this.getDisplay().getSystemColor(21);
        this.m_textColorDisabled = this.getDisplay().getSystemColor(17);
        this.m_focusedHighlightBorderColor = new Color((Device)this.getDisplay(), 118, 183, 232);
        this.m_mouseOverHighlightColor = new Color((Device)this.getDisplay(), 180, 200, 220);
        this.m_dropDownIcon = Activator.imageDescriptorFromLocalPlugin("ArrowDown.gif").createImage();
        this.m_dropDownIconDisabled = new Image((Device)this.getDisplay(), this.m_dropDownIcon, 1);
        this.m_backgroundGradient1 = new Color((Device)this.getDisplay(), 255, 255, 255);
        this.m_backgroundGradient2 = new Color((Device)this.getDisplay(), 220, 220, 220);
        this.m_backgroundGradient1MouseDown = this.getDisplay().getSystemColor(19);
        this.m_backgroundGradient2MouseDown = this.getDisplay().getSystemColor(20);
        this.m_backgroundDisabled = this.getDisplay().getSystemColor(22);
    }

    public void freeResources() {
        this.m_dropDownIcon.dispose();
        this.m_dropDownIconDisabled.dispose();
        this.m_focusedHighlightBorderColor.dispose();
        this.m_mouseOverHighlightColor.dispose();
        this.m_backgroundGradient1.dispose();
        this.m_backgroundGradient2.dispose();
        if (this.m_imageDisabled != null && !this.m_imageDisabled.isDisposed()) {
            this.m_imageDisabled.dispose();
            this.m_imageDisabled = null;
        }
    }

    public Point computeSize(int hint, int hint2, boolean changed) {
        this.getClientArea();
        Point size = new Point(12, 12);
        GC gc = null;
        try {
            gc = new GC((Drawable)this);
            if (this.getImage() != null) {
                Rectangle imgBounds = this.getImage().getBounds();
                size.x += imgBounds.width + 3;
                size.y = Math.max(size.y, 12 + imgBounds.height);
            }
            if (!"".equals(this.getText())) {
                Point textSize = gc.textExtent(this.getText());
                size.x += textSize.x + 3;
                size.y = Math.max(size.y, 12 + textSize.y);
            }
            if ((this.getStyle() & 4) != 0) {
                size.x += this.m_dropDownIcon.getBounds().width + 1;
                size.y = Math.max(size.y, 12 + this.m_dropDownIcon.getBounds().height);
            }
        }
        finally {
            if (gc != null) {
                gc.dispose();
            }
        }
        size.x = Math.max(hint, size.x);
        size.y = Math.max(hint2, size.y);
        return size;
    }

    private void paintInternal(GC gc) {
        gc.setAdvanced(true);
        Color borderColor = this.isEnabled() ? this.m_borderColor : this.m_borderColorDisabled;
        Rectangle clientArea = this.getClientArea();
        --clientArea.width;
        --clientArea.height;
        if (this.isFocusControl()) {
            gc.setBackground(this.m_focusedHighlightBorderColor);
            gc.fillRectangle(clientArea);
        }
        if (this.isFocusControl()) {
            gc.setForeground(borderColor);
            LineAttributes attr = new LineAttributes(1.0f);
            attr.dashOffset = 1.0f;
            attr.width = 1.0f;
            attr.style = 3;
            gc.setLineAttributes(attr);
            gc.drawRoundRectangle(clientArea.x + 2, clientArea.y + 2, clientArea.width - 4, clientArea.height - 4, 3, 3);
        }
        gc.setLineStyle(1);
        gc.setForeground(borderColor);
        gc.drawRoundRectangle(clientArea.x, clientArea.y, clientArea.width, clientArea.height, 3, 3);
        ++clientArea.x;
        ++clientArea.y;
        --clientArea.width;
        --clientArea.height;
        Rectangle buttonArea = this.createCopy(clientArea);
        this.m_dropDownArea = new Rectangle(0, 0, 0, 0);
        if ((this.getStyle() & 4) != 0) {
            int witdh = this.m_dropDownIcon.getBounds().width + 1;
            int x = buttonArea.x + buttonArea.width - witdh;
            int y = buttonArea.y;
            int height = buttonArea.height;
            Rectangle dropdownArea = new Rectangle(x, y, witdh, height);
            this.m_dropDownArea = this.createCopy(dropdownArea);
            buttonArea.width -= dropdownArea.width;
            this.paintDropdownButton(gc, dropdownArea);
        }
        this.m_buttonArea = this.createCopy(buttonArea);
        this.paintButton(gc, buttonArea);
    }

    private Rectangle createCopy(Rectangle rect) {
        Rectangle copy = new Rectangle(rect.x, rect.y, rect.width, rect.height);
        return copy;
    }

    private void paintButton(GC gc, Rectangle drawArea) {
        if (!this.isButtonEnabled()) {
            gc.setForeground(this.m_backgroundDisabled);
            gc.setBackground(this.m_backgroundDisabled);
        } else if (this.m_mouseDownPosition != null && drawArea.contains(this.m_mouseDownPosition)) {
            gc.setForeground(this.m_backgroundGradient1MouseDown);
            gc.setBackground(this.m_backgroundGradient2MouseDown);
        } else if (this.m_mouseHover) {
            gc.setForeground(this.m_backgroundGradient1);
            gc.setBackground(this.m_mouseOverHighlightColor);
        } else {
            gc.setForeground(this.m_backgroundGradient1);
            gc.setBackground(this.m_backgroundGradient2);
        }
        gc.fillGradientRectangle(drawArea.x, drawArea.y, drawArea.width, drawArea.height, true);
        drawArea.x += 3;
        if (this.m_image != null) {
            Image img = this.isButtonEnabled() ? this.m_image : this.m_imageDisabled;
            gc.drawImage(img, drawArea.x, Math.max(drawArea.y + 3, drawArea.y + (drawArea.height - img.getBounds().height) / 2));
            drawArea.x += img.getBounds().width + 3;
            drawArea.width -= img.getBounds().width + 3;
        }
        if (!"".equals(this.getText())) {
            Point textSize = gc.textExtent(this.getText());
            int x = drawArea.x + Math.max(0, (drawArea.width - textSize.x) / 2);
            int y = drawArea.y + Math.max(3, (drawArea.height - textSize.y) / 2);
            if (this.isButtonEnabled()) {
                gc.setForeground(this.getDisplay().getSystemColor(21));
            } else {
                gc.setForeground(this.getDisplay().getSystemColor(17));
            }
            gc.drawText(this.getText(), x, y, true);
        }
    }

    private void paintDropdownButton(GC gc, Rectangle bounds) {
        if (!this.isDropdownEnabled()) {
            gc.setForeground(this.m_backgroundDisabled);
            gc.setBackground(this.m_backgroundDisabled);
        } else if (this.m_mouseDownPosition != null && bounds.contains(this.m_mouseDownPosition)) {
            gc.setForeground(this.m_backgroundGradient1MouseDown);
            gc.setBackground(this.m_backgroundGradient2MouseDown);
        } else {
            gc.setForeground(this.m_backgroundGradient1);
            gc.setBackground(this.m_backgroundGradient2);
        }
        gc.fillGradientRectangle(bounds.x, bounds.y, bounds.width, bounds.height, true);
        Image img = null;
        if (this.isDropdownEnabled()) {
            img = this.m_dropDownIcon;
            gc.setForeground(this.getDisplay().getSystemColor(17));
        } else {
            img = this.m_dropDownIconDisabled;
            gc.setForeground(this.getDisplay().getSystemColor(18));
        }
        gc.setLineStyle(1);
        gc.drawLine(bounds.x, bounds.y, bounds.x, bounds.y + bounds.height);
        ++bounds.x;
        int imgY = Math.max(bounds.y + 3, bounds.y + (bounds.height - img.getBounds().height) / 2);
        gc.drawImage(img, bounds.x, imgY);
    }
}

