/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.ext;

import org.eclipse.scout.commons.exception.IProcessingStatus;
import org.eclipse.scout.rt.client.ui.form.fields.ScoutFieldStatus;
import org.eclipse.scout.rt.shared.AbstractIcons;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.scout.rt.ui.swt.LogicalGridData;
import org.eclipse.scout.rt.ui.swt.basic.comp.CLabelEx;
import org.eclipse.scout.rt.ui.swt.ext.ILabelComposite;
import org.eclipse.scout.rt.ui.swt.extension.UiDecorationExtensionPoint;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class StatusLabelEx
extends Composite
implements ILabelComposite {
    private final ISwtEnvironment m_environment;
    private IProcessingStatus m_status;
    private CLabelEx m_label;
    private Label m_statusLabel;
    private Image m_infoImg;
    private Image m_warningImg;
    private Image m_errorImg;
    private String m_preMarker = "";
    private String m_postMarker = "";
    private Font m_swtFont;
    protected Font mandatoryFont;
    private Color m_swtLabelForeground;
    protected Color mandatoryLabelForeground;
    private String m_text;

    public StatusLabelEx(Composite parent, int style, ISwtEnvironment environment) {
        super(parent, 0);
        this.m_environment = environment;
        this.m_infoImg = environment.getIcon(AbstractIcons.StatusWarning);
        this.m_warningImg = environment.getIcon(AbstractIcons.StatusWarning);
        this.m_errorImg = environment.getIcon(AbstractIcons.StatusError);
        this.createContent(this, style);
        GridLayout containerLayout = new GridLayout(2, false);
        containerLayout.horizontalSpacing = 0;
        containerLayout.marginHeight = 0;
        containerLayout.marginWidth = 0;
        containerLayout.verticalSpacing = 0;
        this.setLayout((Layout)containerLayout);
    }

    protected void createContent(Composite parent, int style) {
        this.m_label = new CLabelEx(parent, style | this.m_environment.getFormToolkit().getFormToolkit().getOrientation());
        this.m_swtFont = this.m_label.getFont();
        this.m_swtLabelForeground = this.m_label.getForeground();
        this.m_environment.getFormToolkit().getFormToolkit().adapt((Control)this.m_label, false, false);
        this.m_statusLabel = new Label(parent, 0);
        this.m_environment.getFormToolkit().getFormToolkit().adapt((Control)this.m_statusLabel, false, false);
        GridData data = new GridData(1808);
        this.m_label.setLayoutData(data);
        GridData dataStatus = new GridData(1040);
        this.m_statusLabel.setLayoutData((Object)dataStatus);
    }

    public ISwtEnvironment getEnvironment() {
        return this.m_environment;
    }

    @Override
    public void setLayoutWidthHint(int w) {
        Object o = this.getLayoutData();
        if (o instanceof LogicalGridData) {
            LogicalGridData data = (LogicalGridData)o;
            data.widthHint = w;
        }
    }

    @Override
    public boolean setMandadatory(boolean b) {
        int starPos;
        String labelTextColor;
        boolean updateLayout = false;
        FontSpec labelFontString = UiDecorationExtensionPoint.getLookAndFeel().getMandatoryLabelFont();
        if (labelFontString != null) {
            Font f = null;
            f = b ? this.getEnvironment().getFont(labelFontString, this.m_swtFont) : null;
            if (this.mandatoryFont != f) {
                this.mandatoryFont = f;
                this.updateFont();
                updateLayout = true;
            }
        }
        if ((labelTextColor = UiDecorationExtensionPoint.getLookAndFeel().getMandatoryLabelTextColor()) != null) {
            Color c = null;
            c = b ? this.getEnvironment().getColor(labelTextColor) : null;
            if (this.mandatoryLabelForeground != c) {
                this.mandatoryLabelForeground = c;
                this.updateLabelForeground();
            }
        }
        if ((starPos = UiDecorationExtensionPoint.getLookAndFeel().getMandatoryStarMarkerPosition()) != 0) {
            switch (starPos) {
                case 2: {
                    this.m_postMarker = b ? "*" : "";
                    break;
                }
                case 1: {
                    this.m_preMarker = b ? "*" : "";
                }
            }
            this.updateText();
            this.layout(true, true);
            updateLayout = true;
        }
        return updateLayout;
    }

    private void updateLabelForeground() {
        if (this.mandatoryLabelForeground != null) {
            this.m_label.setForeground(this.mandatoryLabelForeground);
        } else {
            this.m_label.setForeground(this.m_swtLabelForeground);
        }
    }

    protected void updateFont() {
        if (this.mandatoryFont != null) {
            this.m_label.setFont(this.mandatoryFont);
        } else {
            this.m_label.setFont(this.m_swtFont);
        }
    }

    public Color getBackground() {
        return this.m_label.getBackground();
    }

    public void setBackground(Color color) {
        this.m_label.setBackground(color);
    }

    @Override
    public Color getForeground() {
        return this.m_label.getForeground();
    }

    @Override
    public void setForeground(Color color) {
        this.m_label.setForeground(color);
    }

    @Override
    public String getText() {
        return this.m_text;
    }

    @Override
    public void setText(String text) {
        this.m_text = text;
        this.updateText();
    }

    protected void updateText() {
        String text = this.m_text;
        if (text == null) {
            text = "";
        }
        this.m_label.setText(String.valueOf(this.m_preMarker) + text + this.m_postMarker);
    }

    @Override
    public void setStatus(IProcessingStatus status) {
        this.m_status = status;
        if (this.m_status == null) {
            this.m_statusLabel.setToolTipText("");
            this.m_statusLabel.setImage(null);
            ((GridData)this.m_statusLabel.getLayoutData()).exclude = true;
        } else {
            String iconId;
            String string = iconId = this.m_status instanceof ScoutFieldStatus ? ((ScoutFieldStatus)this.m_status).getIconId() : null;
            if (iconId != null) {
                this.m_statusLabel.setImage(this.getEnvironment().getIcon(iconId));
            } else {
                switch (this.m_status.getSeverity()) {
                    case 4: 
                    case 16: {
                        this.m_statusLabel.setImage(this.m_errorImg);
                        break;
                    }
                    case 2: {
                        this.m_statusLabel.setImage(this.m_warningImg);
                        break;
                    }
                    default: {
                        this.m_statusLabel.setImage(this.m_infoImg);
                    }
                }
            }
            StringBuffer buf = new StringBuffer();
            if (this.m_status.getTitle() != null) {
                buf.append(this.m_status.getTitle());
            }
            if (this.m_status.getMessage() != null) {
                if (buf.length() > 0) {
                    buf.append("\n");
                }
                buf.append(this.m_status.getMessage());
            }
            this.m_statusLabel.setToolTipText(buf.toString());
            ((GridData)this.m_statusLabel.getLayoutData()).exclude = false;
        }
        this.layout(true, true);
    }

    public void setFont(Font font) {
        this.m_swtFont = font;
        this.updateFont();
    }

    public Font getFont() {
        return this.m_label.getFont();
    }

    public String getDisplayText() {
        return this.m_label.getText();
    }
}

