/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.ext;

import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.rt.ui.swt.util.SwtUtility;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;

public class TextEx
extends Text {
    private Menu m_copyPasteMenu = new Menu((Decorations)this.getShell(), 8);
    private MenuItem m_cutItem;
    private MenuItem m_copyItem;
    private MenuItem m_pasteItem;

    public TextEx(Composite parent, int style) {
        super(parent, style);
        this.m_copyPasteMenu.addMenuListener(new MenuListener(){

            public void menuHidden(MenuEvent e) {
            }

            public void menuShown(MenuEvent e) {
                if (TextEx.this.isEnabled()) {
                    TextEx.this.m_cutItem.setEnabled(StringUtility.hasText((String)TextEx.this.getSelectionText()));
                    TextEx.this.m_copyItem.setEnabled(StringUtility.hasText((String)TextEx.this.getSelectionText()));
                }
            }
        });
        this.m_cutItem = new MenuItem(this.m_copyPasteMenu, 8);
        this.m_cutItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextEx.this.cut();
            }
        });
        this.m_cutItem.setText(SwtUtility.getNlsText(Display.getCurrent(), "Cut", new String[0]));
        this.m_copyItem = new MenuItem(this.m_copyPasteMenu, 8);
        this.m_copyItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TextEx.this.isEnabled()) {
                    TextEx.this.copy();
                } else {
                    boolean hasSelection = StringUtility.hasText((String)TextEx.this.getSelectionText());
                    if (hasSelection) {
                        TextEx.this.copy();
                    } else {
                        TextEx.this.setSelection(0, TextEx.this.getText().length());
                        TextEx.this.copy();
                        TextEx.this.clearSelection();
                    }
                }
            }
        });
        this.m_copyItem.setText(SwtUtility.getNlsText(Display.getCurrent(), "Copy", new String[0]));
        this.m_pasteItem = new MenuItem(this.m_copyPasteMenu, 8);
        this.m_pasteItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextEx.this.paste();
            }
        });
        this.m_pasteItem.setText(SwtUtility.getNlsText(Display.getCurrent(), "Paste", new String[0]));
    }

    public void setEnabled(boolean enabled) {
        Composite parent;
        super.setEnabled(enabled);
        if (!this.isDisposed()) {
            if (enabled) {
                this.m_cutItem.setEnabled(true);
                this.m_copyItem.setEnabled(true);
                this.m_pasteItem.setEnabled(true);
                this.setMenu(this.m_copyPasteMenu);
            } else {
                this.setMenu(null);
            }
        }
        if ((parent = this.getParent()) != null && !parent.isDisposed()) {
            if (enabled) {
                parent.setMenu(null);
            } else {
                this.m_cutItem.setEnabled(false);
                this.m_copyItem.setEnabled(true);
                this.m_pasteItem.setEnabled(false);
                parent.setMenu(this.m_copyPasteMenu);
            }
        }
    }

    protected void checkSubclass() {
    }

    public boolean setFocus() {
        return this.getEditable();
    }
}

