/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.ext;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class WizardStatusButton
extends Canvas {
    private static final String ELLIPSIS = "...";
    private Font m_textFont;
    private Font m_stepFont;
    private String m_text;
    private int m_step;
    private boolean m_selected;
    private Color m_selectedBorderColor;
    private Color m_selectedBackground;
    private Color m_selectedBackgroundGradient;
    private Color m_selectedForeground;
    private Color m_background;
    private Color m_backgroundGradient;
    private Color m_foreground;
    int height = 26;
    int borderWith = 2;
    private Point m_cachedSize = new Point(0, 0);

    public WizardStatusButton(Composite parent, int style) {
        super(parent, style);
        this.initResources();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WizardStatusButton.this.freeResources();
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                WizardStatusButton.this.paint(e.gc);
            }
        });
    }

    protected void initResources() {
        this.m_selectedBorderColor = new Color((Device)this.getDisplay(), 213, 216, 243);
        this.m_selectedBackground = new Color((Device)this.getDisplay(), 94, 122, 194);
        this.m_selectedBackgroundGradient = new Color((Device)this.getDisplay(), 213, 216, 243);
        this.m_selectedForeground = new Color((Device)this.getDisplay(), 255, 255, 255);
        this.m_background = new Color((Device)this.getDisplay(), 219, 226, 245);
        this.m_backgroundGradient = new Color((Device)this.getDisplay(), 219, 226, 245);
        this.m_foreground = new Color((Device)this.getDisplay(), 0, 0, 0);
    }

    protected void freeResources() {
        this.m_selectedBorderColor.dispose();
        this.m_selectedBackground.dispose();
        this.m_selectedBackgroundGradient.dispose();
        this.m_selectedForeground.dispose();
        this.m_background.dispose();
        this.m_backgroundGradient.dispose();
        this.m_foreground.dispose();
    }

    protected void paint(GC gc) {
        if (this.m_selected) {
            this.paintSelectedBackground(gc);
            gc.setForeground(this.m_selectedForeground);
        } else {
            this.paintBackground(gc);
            gc.setForeground(this.m_foreground);
        }
        Rectangle bounds = this.getBounds();
        Point imageSize = this.computeSize(-1, -1, false);
        gc.setFont(this.m_stepFont);
        Point stepSize = gc.textExtent("" + this.m_step);
        gc.drawText(String.valueOf(this.m_step), (imageSize.y - stepSize.x) / 2, (imageSize.y - stepSize.y) / 2, true);
        gc.setFont(this.m_textFont);
        String text = this.m_text;
        if (text == null) {
            text = "";
        }
        Point textBounds = gc.textExtent(text);
        int availableSpace = bounds.width - this.height - 6;
        if (availableSpace < textBounds.x) {
            this.setToolTipText(text);
            text = this.shortenText(gc, text, availableSpace);
            textBounds = gc.textExtent(text);
        } else {
            this.setToolTipText(null);
        }
        gc.drawText(text, this.height + 3, (this.height - textBounds.y) / 2, true);
    }

    protected void paintSelectedBackground(GC gc) {
        Rectangle bounds = this.getBounds();
        gc.setBackground(this.m_selectedBorderColor);
        gc.fillOval(bounds.width - this.height, 0, this.height, this.height);
        gc.setBackground(this.m_selectedBackgroundGradient);
        gc.fillOval(bounds.width - this.height + this.borderWith, this.borderWith, this.height - 2 * this.borderWith, this.height - 2 * this.borderWith);
        gc.setBackground(this.m_selectedBorderColor);
        gc.fillRectangle(this.height / 2, 0, bounds.width - this.height, this.height);
        gc.setBackground(this.m_selectedBackgroundGradient);
        gc.setForeground(this.m_selectedBackground);
        gc.fillGradientRectangle(this.height / 2 + this.borderWith, this.borderWith, bounds.width - this.height - 2 * this.borderWith, this.height - 2 * this.borderWith, false);
        gc.setAlpha(150);
        gc.setBackground(this.m_selectedBorderColor);
        gc.fillOval(0, 0, this.height, this.height);
        gc.setAlpha(255);
        gc.setBackground(this.m_selectedBackground);
        gc.fillOval(this.borderWith, this.borderWith, this.height - 2 * this.borderWith, this.height - 2 * this.borderWith);
    }

    protected void paintBackground(GC gc) {
        Rectangle bounds = this.getBounds();
        gc.setBackground(this.m_backgroundGradient);
        gc.fillOval(bounds.width - this.height, 0, this.height, this.height);
        gc.setBackground(this.m_backgroundGradient);
        gc.fillOval(bounds.width - this.height + this.borderWith, this.borderWith, this.height - 2 * this.borderWith, this.height - 2 * this.borderWith);
        gc.setBackground(this.m_backgroundGradient);
        gc.fillRectangle(this.height / 2, 0, bounds.width - this.height, this.height);
        gc.setBackground(this.m_backgroundGradient);
        gc.setForeground(this.m_background);
        gc.fillGradientRectangle(this.height / 2 + this.borderWith, this.borderWith, bounds.width - this.height - 2 * this.borderWith, this.height - 2 * this.borderWith, false);
        gc.setAlpha(150);
        gc.setBackground(this.m_backgroundGradient);
        gc.fillOval(0, 0, this.height, this.height);
        gc.setAlpha(255);
        gc.setBackground(this.m_background);
        gc.fillOval(this.borderWith, this.borderWith, this.height - 2 * this.borderWith, this.height - 2 * this.borderWith);
    }

    protected String shortenText(GC gc, String t, int labelWidth) {
        if (t == null) {
            return null;
        }
        String text = t;
        String rangeWord = "";
        int textWidth = gc.textExtent((String)ELLIPSIS).x;
        int rangeWidth = gc.textExtent((String)rangeWord).x;
        int s = text.length();
        while (s >= 0) {
            String s1 = t.substring(0, s);
            int l1 = gc.textExtent((String)s1).x;
            if (l1 + textWidth + rangeWidth < labelWidth) {
                t = String.valueOf(s1) + ELLIPSIS + rangeWord;
                break;
            }
            --s;
        }
        return t;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size;
        block2: {
            size = new Point(this.height, this.height);
            GC gc = null;
            try {
                gc = new GC((Drawable)this);
                gc.setFont(this.getTextFont());
                Point stringSize = gc.stringExtent(this.getText());
                size.x = Math.max(wHint, stringSize.x + this.height + 10);
            }
            catch (Exception exception) {
                if (gc == null || gc.isDisposed()) break block2;
                gc.dispose();
            }
        }
        this.m_cachedSize = size;
        return this.m_cachedSize;
    }

    public void setText(String text) {
        this.m_text = text;
        this.redraw();
    }

    public String getText() {
        return this.m_text;
    }

    public int getStep() {
        return this.m_step;
    }

    public void setStep(int step) {
        this.m_step = step;
        this.redraw();
    }

    public Font getTextFont() {
        return this.m_textFont;
    }

    public void setTextFont(Font textFont) {
        this.m_textFont = textFont;
        this.redraw();
    }

    public Font getStepFont() {
        return this.m_stepFont;
    }

    public void setStepFont(Font stepFont) {
        this.m_stepFont = stepFont;
        this.redraw();
    }

    public void setSelected(boolean selected) {
        this.m_selected = selected;
        this.redraw();
    }

    public boolean isSelected() {
        return this.m_selected;
    }
}

