/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.form;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.commons.beans.IPropertyObserver;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.ui.form.FormEvent;
import org.eclipse.scout.rt.client.ui.form.FormListener;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.ui.swt.DefaultValidateRoot;
import org.eclipse.scout.rt.ui.swt.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swt.basic.SwtScoutComposite;
import org.eclipse.scout.rt.ui.swt.basic.WidgetPrinter;
import org.eclipse.scout.rt.ui.swt.form.ISwtScoutForm;
import org.eclipse.scout.rt.ui.swt.form.fields.ISwtScoutFormField;
import org.eclipse.scout.rt.ui.swt.form.fields.SwtScoutFormFieldGridData;
import org.eclipse.scout.rt.ui.swt.util.SwtUtility;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class SwtScoutForm
extends SwtScoutComposite<IForm>
implements ISwtScoutForm {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwtScoutForm.class);
    private FormListener m_scoutFormListener;

    @Override
    protected void initializeSwt(Composite parent) {
        Composite container = this.getEnvironment().getFormToolkit().createComposite(parent);
        ISwtScoutFormField swtGroup = this.getEnvironment().createFormField(container, (IFormField)this.getScoutObject().getRootGroupBox());
        Composite swtField = swtGroup.getSwtContainer();
        this.setSwtContainer(container);
        this.setSwtField((Control)swtField);
        SwtScoutFormFieldGridData layoutData = new SwtScoutFormFieldGridData((IFormField)this.getScoutObject().getRootGroupBox());
        this.getSwtField().setLayoutData((Object)layoutData);
        container.setLayout((Layout)new LogicalGridLayout(0, 0));
        container.setData("LayoutValidateManager.validateRoot", (Object)new DefaultValidateRoot(parent));
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        if (this.m_scoutFormListener == null) {
            this.m_scoutFormListener = new P_ScoutFormListener();
            this.getScoutObject().addFormListener(this.m_scoutFormListener);
        }
        ClientSyncJob job = new ClientSyncJob("", this.getEnvironment().getClientSession()){

            protected void runVoid(IProgressMonitor monitor) throws Throwable {
                FormEvent[] pendingEvents;
                FormEvent[] formEventArray = pendingEvents = SwtScoutForm.this.getEnvironment().fetchPendingPrintEvents(SwtScoutForm.this.getScoutObject());
                int n = pendingEvents.length;
                int n2 = 0;
                while (n2 < n) {
                    FormEvent o = formEventArray[n2];
                    SwtScoutForm.this.handleFormEvent(o);
                    ++n2;
                }
            }
        };
        job.schedule();
    }

    @Override
    protected void detachScout() {
        super.detachScout();
        if (this.m_scoutFormListener != null) {
            this.getScoutObject().removeFormListener(this.m_scoutFormListener);
            this.m_scoutFormListener = null;
        }
    }

    @Override
    public Composite getSwtFormPane() {
        return (Composite)this.getSwtField();
    }

    @Override
    public IForm getScoutObject() {
        return (IForm)super.getScoutObject();
    }

    @Override
    public void setInitialFocus() {
    }

    protected void handleScoutPrintEvent(final FormEvent e) {
        Runnable t = new Runnable(){

            @Override
            public void run() {
                WidgetPrinter wp = null;
                try {
                    if (SwtScoutForm.this.getSwtFormPane() != null) {
                        if (e.getFormField() != null) {
                            for (Control c : SwtUtility.findChildComponents((Widget)SwtScoutForm.this.getSwtContainer(), Control.class)) {
                                IPropertyObserver scoutModel = (IPropertyObserver)c.getData("org.eclipse.scout.rt.object");
                                if (scoutModel != e.getFormField()) continue;
                                wp = new WidgetPrinter(c);
                                break;
                            }
                        }
                        if (wp == null) {
                            wp = new WidgetPrinter((Control)SwtScoutForm.this.getSwtFormPane().getShell());
                        }
                    }
                    if (wp != null) {
                        try {
                            wp.print(e.getPrintDevice(), e.getPrintParameters());
                        }
                        catch (Throwable ex) {
                            LOG.error(null, ex);
                        }
                    }
                }
                catch (Throwable throwable) {
                    File outputFile = null;
                    if (wp != null) {
                        outputFile = wp.getOutputFile();
                    }
                    File outputFileFinal = outputFile;
                    Runnable r = new Runnable(outputFileFinal){
                        private final /* synthetic */ File val$outputFileFinal;
                        {
                            this.val$outputFileFinal = file;
                        }

                        @Override
                        public void run() {
                            SwtScoutForm.this.getScoutObject().getUIFacade().fireFormPrintedFromUI(this.val$outputFileFinal);
                        }
                    };
                    SwtScoutForm.this.getEnvironment().invokeScoutLater(r, 0L);
                    throw throwable;
                }
                File outputFile = null;
                if (wp != null) {
                    outputFile = wp.getOutputFile();
                }
                File outputFileFinal = outputFile;
                Runnable r = new /* invalid duplicate definition of identical inner class */;
                SwtScoutForm.this.getEnvironment().invokeScoutLater(r, 0L);
            }
        };
        this.getEnvironment().invokeSwtLater(t);
    }

    public void handleFormEvent(FormEvent e) {
        switch (e.getType()) {
            case 4000: {
                this.handleScoutPrintEvent(e);
                break;
            }
            case 5000: {
                break;
            }
            case 6000: {
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        if (SwtScoutForm.this.getSwtFormPane() != null) {
                            Shell sh = SwtScoutForm.this.getSwtFormPane().getShell();
                            sh.isVisible();
                        }
                    }
                };
                this.getEnvironment().invokeSwtLater(t);
                break;
            }
            case 6010: {
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        if (SwtScoutForm.this.getSwtFormPane() != null) {
                            Shell sh = SwtScoutForm.this.getSwtFormPane().getShell();
                            sh.isVisible();
                        }
                    }
                };
                this.getEnvironment().invokeSwtLater(t);
            }
        }
    }

    private class P_ScoutFormListener
    implements FormListener {
        private P_ScoutFormListener() {
        }

        public void formChanged(FormEvent e) {
            SwtScoutForm.this.handleFormEvent(e);
        }
    }
}

