/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.form.fields.browserfield;

import java.io.File;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.scout.commons.IOUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.browserfield.IBrowserField;
import org.eclipse.scout.rt.shared.services.common.file.RemoteFile;
import org.eclipse.scout.rt.ui.swt.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swt.ext.StatusLabelEx;
import org.eclipse.scout.rt.ui.swt.extension.UiDecorationExtensionPoint;
import org.eclipse.scout.rt.ui.swt.form.fields.SwtScoutValueFieldComposite;
import org.eclipse.scout.rt.ui.swt.form.fields.browserfield.ISwtScoutBrowserField;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class SwtScoutBrowserField
extends SwtScoutValueFieldComposite<IBrowserField>
implements ISwtScoutBrowserField {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwtScoutBrowserField.class);
    private File m_tempDir;
    private String m_currentLocation;

    private void deleteCache(File file) {
        IOUtility.deleteDirectory((File)file);
    }

    @Override
    protected void initializeSwt(Composite parent) {
        Composite container = this.getEnvironment().getFormToolkit().createComposite(parent);
        int labelStyle = UiDecorationExtensionPoint.getLookAndFeel().getFormFieldLabelAlignment();
        StatusLabelEx label = new StatusLabelEx(container, labelStyle, this.getEnvironment());
        this.getEnvironment().getFormToolkit().getFormToolkit().adapt((Control)label, false, false);
        Browser browser = this.getEnvironment().getFormToolkit().createBrowser(container, 0);
        browser.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (SwtScoutBrowserField.this.m_tempDir != null) {
                    SwtScoutBrowserField.this.deleteCache(SwtScoutBrowserField.this.m_tempDir);
                }
            }
        });
        browser.addLocationListener((LocationListener)new LocationAdapter(){

            public void changing(LocationEvent event) {
                event.doit = SwtScoutBrowserField.this.fireBeforeLocationChangedFromSwt(event.location);
            }

            public void changed(LocationEvent event) {
                SwtScoutBrowserField.this.fireAfterLocationChangedFromSwt(event.location);
            }
        });
        this.setSwtContainer(container);
        this.setSwtLabel(label);
        this.setSwtField((Control)browser);
        this.getSwtContainer().setLayout((Layout)new LogicalGridLayout(1, 0));
    }

    public Browser getSwtField() {
        return (Browser)super.getSwtField();
    }

    @Override
    protected void detachScout() {
        if (this.m_tempDir != null) {
            IOUtility.deleteDirectory((File)this.m_tempDir);
            this.m_tempDir = null;
        }
        super.detachScout();
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if ("location".equals(name)) {
            this.setLocationFromScout();
        }
    }

    @Override
    protected void setValueFromScout() {
        this.setLocationFromScout();
    }

    protected void setLocationFromScout() {
        String location;
        block11: {
            location = ((IBrowserField)this.getScoutObject()).getLocation();
            RemoteFile r = (RemoteFile)((IBrowserField)this.getScoutObject()).getValue();
            if (location == null && r != null && r.exists()) {
                try {
                    if (this.m_tempDir == null) {
                        try {
                            this.m_tempDir = IOUtility.createTempDirectory((String)"html");
                        }
                        catch (ProcessingException e) {
                            LOG.error("create temporary folder", (Throwable)e);
                        }
                    }
                    if (r.getName().matches(".*\\.(zip|jar)")) {
                        r.writeZipContentToDirectory(this.m_tempDir);
                        String simpleName = r.getName().replaceAll("\\.(zip|jar)", ".htm");
                        File[] fileArray = this.m_tempDir.listFiles();
                        int n = fileArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File f = fileArray[n2];
                            if (f.getName().startsWith(simpleName)) {
                                location = f.toURI().toURL().toExternalForm();
                                break block11;
                            }
                            ++n2;
                        }
                        break block11;
                    }
                    File f = new File(this.m_tempDir, r.getName());
                    r.writeData(f);
                    location = f.toURI().toURL().toExternalForm();
                }
                catch (Throwable t) {
                    LOG.error("preparing html content for " + r, t);
                }
            }
        }
        this.m_currentLocation = location;
        if (this.m_currentLocation != null) {
            this.getSwtField().setUrl(this.m_currentLocation);
        } else {
            this.getSwtField().setText("");
        }
    }

    @Override
    protected void setEnabledFromScout(boolean b) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean fireBeforeLocationChangedFromSwt(final String location) {
        AtomicReference accept;
        AtomicReference atomicReference = accept = new AtomicReference();
        synchronized (atomicReference) {
            Runnable t = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    AtomicReference atomicReference = accept;
                    synchronized (atomicReference) {
                        accept.set(((IBrowserField)SwtScoutBrowserField.this.getScoutObject()).getUIFacade().fireBeforeLocationChangedFromUI(location));
                        accept.notifyAll();
                    }
                }
            };
            this.getEnvironment().invokeScoutLater(t, 0L);
            try {
                accept.wait(10000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return accept.get() != null ? (Boolean)accept.get() : false;
    }

    protected void fireAfterLocationChangedFromSwt(final String location) {
        Runnable t = new Runnable(){

            @Override
            public void run() {
                ((IBrowserField)SwtScoutBrowserField.this.getScoutObject()).getUIFacade().fireAfterLocationChangedFromUI(location);
            }
        };
        this.getEnvironment().invokeScoutLater(t, 0L);
    }
}

