/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.form.fields.datefield;

import java.text.DateFormat;
import java.util.Date;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.rt.client.ui.form.fields.datefield.IDateField;
import org.eclipse.scout.rt.shared.AbstractIcons;
import org.eclipse.scout.rt.ui.swt.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swt.ext.ButtonEx;
import org.eclipse.scout.rt.ui.swt.ext.StatusLabelEx;
import org.eclipse.scout.rt.ui.swt.extension.UiDecorationExtensionPoint;
import org.eclipse.scout.rt.ui.swt.form.fields.LogicalGridDataBuilder;
import org.eclipse.scout.rt.ui.swt.form.fields.SwtScoutValueFieldComposite;
import org.eclipse.scout.rt.ui.swt.form.fields.datefield.ISwtScoutDateField;
import org.eclipse.scout.rt.ui.swt.form.fields.datefield.chooser.DateChooserDialog;
import org.eclipse.scout.rt.ui.swt.form.fields.datefield.chooser.TimeChooserDialog;
import org.eclipse.scout.rt.ui.swt.internal.TextFieldEditableSupport;
import org.eclipse.scout.rt.ui.swt.keystroke.SwtKeyStroke;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class SwtScoutDateField
extends SwtScoutValueFieldComposite<IDateField>
implements ISwtScoutDateField {
    public static final int TYPE_TIME_CHOOSER = 1;
    public static final int TYPE_DATE_CHOOSER = 2;
    private ButtonEx m_dateChooserButton;
    private ButtonEx m_timeChooserButton;
    private boolean m_hasTime;
    private TextFieldEditableSupport m_editableSupport;

    @Override
    protected void initializeSwt(Composite parent) {
        Composite container = this.getEnvironment().getFormToolkit().createComposite(parent);
        int labelStyle = UiDecorationExtensionPoint.getLookAndFeel().getFormFieldLabelAlignment();
        StatusLabelEx label = new StatusLabelEx(container, labelStyle, this.getEnvironment());
        this.getEnvironment().getFormToolkit().getFormToolkit().adapt((Control)label, false, false);
        StyledText textField = this.getEnvironment().getFormToolkit().createStyledText(container, 2052);
        ButtonEx dateChooserButton = this.getEnvironment().getFormToolkit().createButtonEx(container, 8);
        dateChooserButton.setImage(this.getEnvironment().getIcon(AbstractIcons.DateFieldDate));
        ButtonEx timeChooserButton = this.getEnvironment().getFormToolkit().createButtonEx(container, 8);
        timeChooserButton.setImage(this.getEnvironment().getIcon(AbstractIcons.DateFieldTime));
        timeChooserButton.setVisible(((IDateField)this.getScoutObject()).isHasTime());
        container.setTabList(new Control[]{textField});
        this.getEnvironment().addKeyStroke((Widget)container, new P_DateChooserOpenKeyStroke());
        this.getEnvironment().addKeyStroke((Widget)container, new P_DateTimeChooserOpenKeyStroke());
        textField.addKeyListener((KeyListener)new P_ShiftDateListener());
        dateChooserButton.addListener(44, new P_SwtBrowseButtonListener(2));
        timeChooserButton.addListener(44, new P_SwtBrowseButtonListener(1));
        this.setSwtContainer(container);
        this.setSwtLabel(label);
        this.setDateChooserButton(dateChooserButton);
        this.setTimeChooserButton(timeChooserButton);
        this.setSwtField((Control)textField);
        container.setLayout((Layout)new LogicalGridLayout(1, 0));
        dateChooserButton.setLayoutData(LogicalGridDataBuilder.createButton1());
        timeChooserButton.setLayoutData(LogicalGridDataBuilder.createButton2());
    }

    @Override
    public ButtonEx getDateChooserButton() {
        return this.m_dateChooserButton;
    }

    public void setDateChooserButton(ButtonEx dateChooserButton) {
        this.m_dateChooserButton = dateChooserButton;
    }

    @Override
    public ButtonEx getTimeChooserButton() {
        return this.m_timeChooserButton;
    }

    public void setTimeChooserButton(ButtonEx timeChooserButton) {
        this.m_timeChooserButton = timeChooserButton;
    }

    @Override
    public StyledText getSwtField() {
        return (StyledText)super.getSwtField();
    }

    @Override
    protected void setFieldEnabled(Control swtField, boolean enabled) {
        if (UiDecorationExtensionPoint.getLookAndFeel().isEnabledAsReadOnly()) {
            if (this.m_editableSupport == null) {
                this.m_editableSupport = new TextFieldEditableSupport(this.getSwtField());
            }
            this.m_editableSupport.setEditable(enabled);
        } else {
            super.setFieldEnabled(swtField, enabled);
        }
    }

    @Override
    protected void setDisplayTextFromScout(String s) {
        if (s == null) {
            s = "";
        }
        this.getSwtField().setText(s);
        super.handleSwtFocusGained();
        this.getSwtField().setCaretOffset(0);
    }

    @Override
    protected void setEnabledFromScout(boolean b) {
        super.setEnabledFromScout(b);
        this.m_dateChooserButton.setEnabled(b);
        this.m_timeChooserButton.setEnabled(b);
    }

    @Override
    protected boolean handleSwtInputVerifier() {
        final String text = this.getSwtField().getText();
        if (CompareUtility.equals((Object)text, (Object)((IDateField)this.getScoutObject()).getDisplayText()) && ((IDateField)this.getScoutObject()).getErrorStatus() == null) {
            return true;
        }
        final Holder result = new Holder(Boolean.class, (Object)false);
        Runnable t = new Runnable(){

            @Override
            public void run() {
                boolean b = ((IDateField)SwtScoutDateField.this.getScoutObject()).getUIFacade().setDateTimeTextFromUI(text);
                result.setValue((Object)b);
            }
        };
        JobEx job = this.getEnvironment().invokeScoutLater(t, 0L);
        try {
            job.join(2345L);
        }
        catch (InterruptedException interruptedException) {}
        this.getEnvironment().dispatchImmediateSwtJobs();
        return true;
    }

    @Override
    protected void handleSwtFocusGained() {
        super.handleSwtFocusGained();
        this.getSwtField().setSelection(0, this.getSwtField().getText().length());
    }

    @Override
    protected void handleSwtFocusLost() {
        this.getSwtField().setSelection(0, 0);
    }

    private void handleSwtDateChooserAction() {
        if (this.getDateChooserButton().isVisible() && this.getDateChooserButton().isEnabled()) {
            DateChooserDialog dialog;
            Date newDate;
            Date oldDate = (Date)((IDateField)this.getScoutObject()).getValue();
            if (oldDate == null) {
                oldDate = new Date();
            }
            if ((newDate = (dialog = new DateChooserDialog(this.getSwtField().getShell(), oldDate, this.getEnvironment())).openDateChooser((Control)this.getSwtField())) != null) {
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        ((IDateField)SwtScoutDateField.this.getScoutObject()).getUIFacade().setDateFromUI(newDate);
                    }
                };
                this.getEnvironment().invokeScoutLater(t, 0L);
            }
            this.getSwtField().setFocus();
        }
    }

    private void handleSwtTimeChooserAction() {
        if (this.getTimeChooserButton().isVisible() && this.getTimeChooserButton().isEnabled()) {
            TimeChooserDialog dialog;
            Date newDate;
            Date d = (Date)((IDateField)this.getScoutObject()).getValue();
            if (d == null) {
                d = new Date();
            }
            if ((newDate = (dialog = new TimeChooserDialog(this.getSwtField().getShell(), d, this.getEnvironment())).openDateChooser((Control)this.getSwtField())) != null) {
                this.getSwtField().setText(DateFormat.getDateTimeInstance(3, 3).format(newDate));
                this.handleSwtInputVerifier();
            }
            this.getSwtField().setFocus();
        }
    }

    private class P_DateChooserOpenKeyStroke
    extends SwtKeyStroke {
        public P_DateChooserOpenKeyStroke() {
            super(0x100000B);
        }

        @Override
        public void handleSwtAction(Event e) {
            SwtScoutDateField.this.handleSwtDateChooserAction();
        }
    }

    private class P_DateTimeChooserOpenKeyStroke
    extends SwtKeyStroke {
        public P_DateTimeChooserOpenKeyStroke() {
            super(0x100000B, 131072);
        }

        @Override
        public void handleSwtAction(Event e) {
            SwtScoutDateField.this.handleSwtTimeChooserAction();
        }
    }

    private class P_ShiftDateListener
    extends KeyAdapter {
        private P_ShiftDateListener() {
        }

        public void keyPressed(KeyEvent e) {
            if (SwtScoutDateField.this.getSwtField().isEnabled() && SwtScoutDateField.this.getSwtField().getEditable() && SwtScoutDateField.this.getSwtField().isVisible()) {
                int level = -1;
                int value = 0;
                switch (e.keyCode) {
                    case 0x1000001: {
                        if (e.stateMask == 0) {
                            level = 0;
                            value = 1;
                            break;
                        }
                        if (e.stateMask == 131072) {
                            level = 1;
                            value = 1;
                            break;
                        }
                        if (e.stateMask != 262144) break;
                        level = 2;
                        value = 1;
                        break;
                    }
                    case 0x1000002: {
                        if (e.stateMask == 0) {
                            level = 0;
                            value = -1;
                            break;
                        }
                        if (e.stateMask == 131072) {
                            level = 1;
                            value = -1;
                            break;
                        }
                        if (e.stateMask != 262144) break;
                        level = 2;
                        value = -1;
                    }
                }
                if (level >= 0) {
                    final int levelFinal = level;
                    final int valueFinal = value;
                    final String newDisplayText = SwtScoutDateField.this.getSwtField().getText();
                    Runnable t = new Runnable(){

                        @Override
                        public void run() {
                            if (!CompareUtility.equals((Object)newDisplayText, (Object)((IDateField)SwtScoutDateField.this.getScoutObject()).getDisplayText())) {
                                ((IDateField)SwtScoutDateField.this.getScoutObject()).getUIFacade().setDateTimeTextFromUI(newDisplayText);
                            }
                            ((IDateField)SwtScoutDateField.this.getScoutObject()).getUIFacade().fireDateShiftActionFromUI(levelFinal, valueFinal);
                        }
                    };
                    SwtScoutDateField.this.getEnvironment().invokeScoutLater(t, 2345L);
                }
            }
        }
    }

    private class P_SwtBrowseButtonListener
    implements Listener {
        private int m_buttonId;

        public P_SwtBrowseButtonListener(int buttonId) {
            this.m_buttonId = buttonId;
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 44: {
                    if (this.m_buttonId == 2) {
                        SwtScoutDateField.this.handleSwtDateChooserAction();
                        break;
                    }
                    if (this.m_buttonId != 1) break;
                    SwtScoutDateField.this.handleSwtTimeChooserAction();
                }
            }
        }
    }
}

