/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.form.fields.datefield.chooser;

import java.text.DateFormatSymbols;
import java.util.Date;
import java.util.Locale;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.scout.commons.DateUtility;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.scout.rt.ui.swt.ext.table.TableEx;
import org.eclipse.scout.rt.ui.swt.ext.table.util.TableCellRolloverSupport;
import org.eclipse.scout.rt.ui.swt.form.fields.datefield.chooser.DateRow;
import org.eclipse.scout.rt.ui.swt.form.fields.datefield.chooser.DatefieldTableModel;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class DateChooserDialog
extends Dialog {
    public static final int TYPE_BACK_YEAR = 1;
    public static final int TYPE_BACK_MONTH = 2;
    public static final int TYPE_FOREWARD_MONTH = 4;
    public static final int TYPE_FOREWARD_YEAR = 8;
    private static final int COLUMN_WIDTH = 35;
    private TableViewer m_viewer;
    private TableCursor m_cursor;
    private Label m_monthLabel;
    private DatefieldTableModel m_model;
    private Date m_returnDate = null;
    private final ISwtEnvironment m_environment;

    protected int getShellStyle() {
        return 0;
    }

    public DateChooserDialog(Shell parentShell, Date date, ISwtEnvironment environment) {
        super(parentShell);
        this.m_environment = environment;
        this.m_model = new DatefieldTableModel(this.getEnvironment());
        this.setDisplayDate(date);
        this.setBlockOnOpen(true);
    }

    private void setDisplayDate(Date date) {
        this.m_model.setHighLightDate(date);
        this.m_model.setNavigationDate(date);
    }

    public Date openDateChooser(Control c) {
        this.showDialogFor(c);
        return this.m_returnDate;
    }

    public int showDialogFor(Control field) {
        this.create();
        this.getShell().addShellListener((ShellListener)new ShellAdapter(){

            public void shellDeactivated(ShellEvent e) {
                DateChooserDialog.this.close();
            }
        });
        Rectangle appBounds = this.getEnvironment().getDisplay().getBounds();
        Point absPrefPos = field.toDisplay(field.getSize().x - this.getShell().getSize().x, field.getSize().y);
        Rectangle prefBounds = new Rectangle(absPrefPos.x, absPrefPos.y, this.getShell().getSize().x, this.getShell().getSize().y);
        if (prefBounds.x + prefBounds.width > appBounds.width) {
            prefBounds.x = appBounds.width - prefBounds.width;
        }
        if (prefBounds.y + prefBounds.height > appBounds.height) {
            prefBounds.y = appBounds.height - prefBounds.height;
        }
        this.getShell().setLocation(prefBounds.x, prefBounds.y);
        this.m_viewer.refresh();
        int ret = this.open();
        return ret;
    }

    protected Control createContents(Composite parent) {
        Composite rootArea = new Composite(parent, 524288);
        Control navigationArea = this.createControlArea(rootArea);
        Control calendarArea = this.createPickDateArea(rootArea);
        rootArea.setLayout((Layout)new FormLayout());
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        navigationArea.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(navigationArea, 2);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        calendarArea.setLayoutData((Object)data);
        return rootArea;
    }

    private Control createPickDateArea(Composite parent) {
        TableEx table = this.getEnvironment().getFormToolkit().createTable(parent, 65536);
        table.setLinesVisible(true);
        TableViewer viewer = new TableViewer((Table)table);
        new TableCellRolloverSupport(viewer);
        table.setHeaderVisible(true);
        this.m_cursor = new TableCursor((Table)table, 0);
        this.m_cursor.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                TableCursor cursor = (TableCursor)e.widget;
                Date date = ((DateRow)cursor.getRow().getData()).getDate(cursor.getColumn() - 1);
                DateChooserDialog.this.m_returnDate = date;
                DateChooserDialog.this.getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DateChooserDialog.this.close();
                    }
                });
            }
        });
        TableColumn dummyColumn = new TableColumn((Table)table, 131072);
        dummyColumn.setWidth(0);
        dummyColumn.setResizable(false);
        dummyColumn.setMoveable(false);
        String[] wd = new DateFormatSymbols(Locale.getDefault()).getShortWeekdays();
        int i = 2;
        while (i < 8) {
            TableColumn col = new TableColumn((Table)table, 0x1000000);
            col.setWidth(35);
            col.setResizable(false);
            col.setMoveable(false);
            col.setText(wd[i]);
            ++i;
        }
        TableColumn col = new TableColumn((Table)table, 0x1000000);
        col.setWidth(35);
        col.setResizable(false);
        col.setMoveable(false);
        col.setText(wd[1]);
        this.m_viewer = viewer;
        this.m_viewer.setLabelProvider((IBaseLabelProvider)this.m_model);
        this.m_viewer.setContentProvider((IContentProvider)this.m_model);
        this.m_viewer.setInput((Object)this.m_model);
        return table;
    }

    private Control createControlArea(Composite parent) {
        Composite rootArea = this.getEnvironment().getFormToolkit().createComposite(parent, 524288);
        this.createButton(rootArea, 1);
        this.createButton(rootArea, 2);
        this.m_monthLabel = this.getEnvironment().getFormToolkit().createLabel(rootArea, "", 0x1000000);
        this.m_monthLabel.setText(this.m_model.getMonthYearLabel());
        this.createButton(rootArea, 4);
        this.createButton(rootArea, 8);
        rootArea.setLayout((Layout)new GridLayout(5, false));
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.m_monthLabel.setLayoutData((Object)data);
        return rootArea;
    }

    private Button createButton(Composite parent, int type) {
        String text = null;
        switch (type) {
            case 1: {
                text = "<<";
                break;
            }
            case 2: {
                text = "<";
                break;
            }
            case 4: {
                text = ">";
                break;
            }
            case 8: {
                text = ">>";
            }
        }
        Button b = this.getEnvironment().getFormToolkit().createButton(parent, text, 8);
        b.addSelectionListener((SelectionListener)new P_NavigationSelectionListener(type));
        GridData data = new GridData(22, 22);
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = false;
        b.setLayoutData((Object)data);
        return b;
    }

    public ISwtEnvironment getEnvironment() {
        return this.m_environment;
    }

    private class P_NavigationSelectionListener
    extends SelectionAdapter {
        private int m_type;

        P_NavigationSelectionListener(int type) {
            this.m_type = type;
        }

        public void widgetSelected(SelectionEvent e) {
            switch (this.m_type) {
                case 1: {
                    DateChooserDialog.this.m_model.setNavigationDate(DateUtility.addYears((Date)DateChooserDialog.this.m_model.getNavigationDate(), (int)-1));
                    break;
                }
                case 2: {
                    DateChooserDialog.this.m_model.setNavigationDate(DateUtility.addMonths((Date)DateChooserDialog.this.m_model.getNavigationDate(), (int)-1));
                    break;
                }
                case 4: {
                    DateChooserDialog.this.m_model.setNavigationDate(DateUtility.addMonths((Date)DateChooserDialog.this.m_model.getNavigationDate(), (int)1));
                    break;
                }
                case 8: {
                    DateChooserDialog.this.m_model.setNavigationDate(DateUtility.addYears((Date)DateChooserDialog.this.m_model.getNavigationDate(), (int)1));
                }
            }
            DateChooserDialog.this.m_viewer.refresh();
            DateChooserDialog.this.m_monthLabel.setText(DateChooserDialog.this.m_model.getMonthYearLabel());
        }
    }
}

