/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.form.fields.datefield.chooser;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.scout.rt.ui.swt.form.fields.datefield.chooser.AbstractDateSelectionListener;
import org.eclipse.scout.rt.ui.swt.form.fields.datefield.chooser.DateSelectionEvent;
import org.eclipse.scout.rt.ui.swt.form.fields.datefield.chooser.TimeChooserContent;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TimeChooserDialog
extends Dialog {
    public static final int TYPE_BACK_YEAR = 1;
    public static final int TYPE_BACK_MONTH = 2;
    public static final int TYPE_FOREWARD_MONTH = 4;
    public static final int TYPE_FOREWARD_YEAR = 8;
    private TimeChooserContent m_timeChooserContent;
    private Date m_returnDate = null;
    private Date m_displayDate;
    private final ISwtEnvironment m_environment;

    protected int getShellStyle() {
        return 0;
    }

    public TimeChooserDialog(Shell parentShell, Date date, ISwtEnvironment environment) {
        super(parentShell);
        this.m_environment = environment;
        this.setDisplayDate(date);
        this.setBlockOnOpen(true);
    }

    public TimeChooserDialog(Shell parentShell, Number number, ISwtEnvironment environment) {
        super(parentShell);
        this.m_environment = environment;
        this.setDisplayDate((Double)number);
        this.setBlockOnOpen(true);
    }

    private void setDisplayDate(Date date) {
        this.m_displayDate = date;
    }

    private void setDisplayDate(Double number) {
        if (number == null) {
            return;
        }
        Calendar c = Calendar.getInstance();
        int hours = (int)(number * 24.0);
        int mins = (int)Math.round((number * 24.0 - (double)hours) * 60.0);
        c.set(0, 0, 0, hours, mins);
        this.m_displayDate = c.getTime();
    }

    public Date openDateChooser(Control c) {
        this.showDialogFor(c);
        return this.m_returnDate;
    }

    public int showDialogFor(Control field) {
        this.create();
        this.getShell().addShellListener((ShellListener)new ShellAdapter(){

            public void shellDeactivated(ShellEvent e) {
                TimeChooserDialog.this.close();
            }
        });
        Rectangle appBounds = this.getEnvironment().getDisplay().getBounds();
        Point absPrefPos = field.toDisplay(field.getSize().x - this.getShell().getSize().x, field.getSize().y);
        Rectangle prefBounds = new Rectangle(absPrefPos.x, absPrefPos.y, this.getShell().getSize().x, this.getShell().getSize().y);
        if (prefBounds.x + prefBounds.width > appBounds.width) {
            prefBounds.x = appBounds.width - prefBounds.width;
        }
        if (prefBounds.y + prefBounds.height > appBounds.height) {
            prefBounds.y = appBounds.height - prefBounds.height;
        }
        this.getShell().setLocation(prefBounds.x, prefBounds.y);
        int ret = this.open();
        return ret;
    }

    protected Control createContents(Composite parent) {
        Composite rootArea = new Composite(parent, 0);
        this.m_timeChooserContent = new TimeChooserContent(rootArea, this.m_displayDate, this.getEnvironment());
        this.m_timeChooserContent.addTimeChangedListener(new AbstractDateSelectionListener(){

            @Override
            public void dateChanged(DateSelectionEvent e) {
                TimeChooserDialog.this.m_returnDate = (Date)e.getData();
                TimeChooserDialog.this.getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        TimeChooserDialog.this.close();
                    }
                });
            }
        });
        this.m_timeChooserContent.setDate(this.m_displayDate);
        rootArea.setLayout((Layout)new FormLayout());
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        this.m_timeChooserContent.setLayoutData(data);
        return rootArea;
    }

    public ISwtEnvironment getEnvironment() {
        return this.m_environment;
    }
}

