/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.form.fields.imagebox;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.beans.IPropertyObserver;
import org.eclipse.scout.commons.dnd.TransferObject;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.rt.client.ui.IDNDSupport;
import org.eclipse.scout.rt.client.ui.form.fields.imagebox.IImageField;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.scout.rt.ui.swt.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swt.ext.ImageViewer;
import org.eclipse.scout.rt.ui.swt.ext.StatusLabelEx;
import org.eclipse.scout.rt.ui.swt.extension.UiDecorationExtensionPoint;
import org.eclipse.scout.rt.ui.swt.form.fields.AbstractSwtScoutDndSupport;
import org.eclipse.scout.rt.ui.swt.form.fields.SwtScoutFieldComposite;
import org.eclipse.scout.rt.ui.swt.form.fields.imagebox.ISwtScoutImageBox;
import org.eclipse.scout.rt.ui.swt.util.SwtUtility;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class SwtScoutImageField
extends SwtScoutFieldComposite<IImageField>
implements ISwtScoutImageBox {
    private Image m_image;

    @Override
    protected void initializeSwt(Composite parent) {
        Composite container = this.getEnvironment().getFormToolkit().createComposite(parent);
        int labelStyle = UiDecorationExtensionPoint.getLookAndFeel().getFormFieldLabelAlignment();
        StatusLabelEx label = new StatusLabelEx(container, labelStyle, this.getEnvironment());
        this.getEnvironment().getFormToolkit().getFormToolkit().adapt((Control)label, false, false);
        ImageViewer imgViewer = this.getEnvironment().getFormToolkit().createImageViewer(container);
        this.setSwtContainer(container);
        this.setSwtLabel(label);
        this.setSwtField((Control)imgViewer);
        imgViewer.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SwtScoutImageField.this.freeResources();
            }
        });
        this.getSwtContainer().setLayout((Layout)new LogicalGridLayout(1, 0));
    }

    private void freeResources() {
        if (this.m_image != null && !this.m_image.isDisposed()) {
            if (this.getSwtField() != null && !this.getSwtField().isDisposed()) {
                this.getSwtField().setImage(null);
            }
            this.m_image.dispose();
            this.m_image = null;
        }
    }

    public ImageViewer getSwtField() {
        return (ImageViewer)super.getSwtField();
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        this.getSwtField().setAlignmentX(SwtUtility.getHorizontalAlignment(((IImageField)this.getScoutObject()).getGridData().horizontalAlignment));
        this.getSwtField().setAlignmentY(SwtUtility.getHorizontalAlignment(((IImageField)this.getScoutObject()).getGridData().verticalAlignment));
        this.updateAutoFitFromScout();
        this.updateImageFromScout();
        new P_DndSupport((IPropertyObserver)this.getScoutObject(), (IDNDSupport)this.getScoutObject(), (Control)this.getSwtField(), this.getEnvironment());
    }

    protected void updateImageFromScout() {
        this.freeResources();
        if (((IImageField)this.getScoutObject()).getImage() instanceof byte[]) {
            this.m_image = new Image((Device)this.getSwtField().getDisplay(), (InputStream)new ByteArrayInputStream((byte[])((IImageField)this.getScoutObject()).getImage()));
            this.getSwtField().setImage(this.m_image);
        } else if (((IImageField)this.getScoutObject()).getImage() instanceof ImageData) {
            this.m_image = new Image((Device)this.getSwtField().getDisplay(), (ImageData)((IImageField)this.getScoutObject()).getImage());
            this.getSwtField().setImage(this.m_image);
        } else if (!StringUtility.isNullOrEmpty((String)((IImageField)this.getScoutObject()).getImageId())) {
            this.getSwtField().setImage(this.getEnvironment().getIcon(((IImageField)this.getScoutObject()).getImageId()));
        }
        this.getSwtField().redraw();
    }

    protected void updateAutoFitFromScout() {
        this.getSwtField().setAutoFit(((IImageField)this.getScoutObject()).isAutoFit());
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        if ("image".equals(name)) {
            this.updateImageFromScout();
        } else if ("autoFit".equals(name)) {
            this.updateAutoFitFromScout();
        }
        super.handleScoutPropertyChange(name, newValue);
    }

    private class P_DndSupport
    extends AbstractSwtScoutDndSupport {
        public P_DndSupport(IPropertyObserver scoutObject, IDNDSupport scoutDndSupportable, Control control, ISwtEnvironment environment) {
            super(scoutObject, scoutDndSupportable, control, environment);
        }

        @Override
        protected TransferObject handleSwtDragRequest() {
            final Holder result = new Holder(TransferObject.class, null);
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    TransferObject scoutTransferable = ((IImageField)SwtScoutImageField.this.getScoutObject()).getUIFacade().fireDragRequestFromUI();
                    result.setValue((Object)scoutTransferable);
                }
            };
            JobEx job = SwtScoutImageField.this.getEnvironment().invokeScoutLater(t, 2345L);
            try {
                job.join(2345L);
            }
            catch (InterruptedException interruptedException) {}
            return (TransferObject)result.getValue();
        }

        @Override
        protected void handleSwtDropAction(DropTargetEvent event, final TransferObject scoutTransferObject) {
            Runnable job = new Runnable(){

                @Override
                public void run() {
                    ((IImageField)SwtScoutImageField.this.getScoutObject()).getUIFacade().fireDropActionFromUi(scoutTransferObject);
                }
            };
            SwtScoutImageField.this.getEnvironment().invokeScoutLater(job, 200L);
        }
    }
}

