/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.form.fields.numberfield;

import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.rt.client.ui.form.fields.numberfield.INumberField;
import org.eclipse.scout.rt.ui.swt.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swt.ext.StatusLabelEx;
import org.eclipse.scout.rt.ui.swt.extension.UiDecorationExtensionPoint;
import org.eclipse.scout.rt.ui.swt.form.fields.SwtScoutValueFieldComposite;
import org.eclipse.scout.rt.ui.swt.form.fields.numberfield.ISwtScoutNumberField;
import org.eclipse.scout.rt.ui.swt.internal.TextFieldEditableSupport;
import org.eclipse.scout.rt.ui.swt.util.SwtUtility;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SwtScoutNumberField
extends SwtScoutValueFieldComposite<INumberField<?>>
implements ISwtScoutNumberField {
    private TextFieldEditableSupport m_editableSupport;

    @Override
    protected void initializeSwt(Composite parent) {
        Composite container = this.getEnvironment().getFormToolkit().createComposite(parent);
        int labelStyle = UiDecorationExtensionPoint.getLookAndFeel().getFormFieldLabelAlignment();
        StatusLabelEx label = new StatusLabelEx(container, labelStyle, this.getEnvironment());
        this.getEnvironment().getFormToolkit().getFormToolkit().adapt((Control)label, false, false);
        int style = 2048;
        style |= SwtUtility.getVerticalAlignment(((INumberField)this.getScoutObject()).getGridData().verticalAlignment);
        Text text = this.getEnvironment().getFormToolkit().createText(container, style |= SwtUtility.getHorizontalAlignment(((INumberField)this.getScoutObject()).getGridData().horizontalAlignment));
        text.setTextLimit(32);
        this.setSwtContainer(container);
        this.setSwtLabel(label);
        this.setSwtField((Control)text);
        this.getSwtContainer().setLayout((Layout)new LogicalGridLayout(1, 0));
    }

    public Text getSwtField() {
        return (Text)super.getSwtField();
    }

    @Override
    protected void setFieldEnabled(Control swtField, boolean enabled) {
        if (UiDecorationExtensionPoint.getLookAndFeel().isEnabledAsReadOnly()) {
            if (this.m_editableSupport == null) {
                this.m_editableSupport = new TextFieldEditableSupport(this.getSwtField());
            }
            this.m_editableSupport.setEditable(enabled);
        } else {
            super.setFieldEnabled(swtField, enabled);
        }
    }

    @Override
    protected void setDisplayTextFromScout(String s) {
        if (s == null) {
            s = "";
        }
        this.getSwtField().setText(s);
    }

    @Override
    protected boolean handleSwtInputVerifier() {
        final String text = this.getSwtField().getText();
        if (CompareUtility.equals((Object)text, (Object)((INumberField)this.getScoutObject()).getDisplayText()) && ((INumberField)this.getScoutObject()).getErrorStatus() == null) {
            return true;
        }
        final Holder result = new Holder(Boolean.class, (Object)false);
        Runnable t = new Runnable(){

            @Override
            public void run() {
                boolean b = ((INumberField)SwtScoutNumberField.this.getScoutObject()).getUIFacade().setTextFromUI(text);
                result.setValue((Object)b);
            }
        };
        JobEx job = this.getEnvironment().invokeScoutLater(t, 0L);
        try {
            job.join(2345L);
        }
        catch (InterruptedException interruptedException) {}
        this.getEnvironment().dispatchImmediateSwtJobs();
        return true;
    }

    @Override
    protected void handleSwtFocusGained() {
        super.handleSwtFocusGained();
        this.getSwtField().setSelection(0, this.getSwtField().getText().length());
    }

    @Override
    protected void handleSwtFocusLost() {
        this.getSwtField().setSelection(0, 0);
    }
}

