/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.form.fields.sequencebox;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.scout.commons.exception.IProcessingStatus;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.IValueField;
import org.eclipse.scout.rt.client.ui.form.fields.sequencebox.ISequenceBox;
import org.eclipse.scout.rt.ui.swt.LogicalGridData;
import org.eclipse.scout.rt.ui.swt.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swt.ext.ILabelComposite;
import org.eclipse.scout.rt.ui.swt.ext.StatusLabelEx;
import org.eclipse.scout.rt.ui.swt.extension.UiDecorationExtensionPoint;
import org.eclipse.scout.rt.ui.swt.form.fields.ISwtScoutFormField;
import org.eclipse.scout.rt.ui.swt.form.fields.SwtScoutFieldComposite;
import org.eclipse.scout.rt.ui.swt.form.fields.SwtScoutFormFieldGridData;
import org.eclipse.scout.rt.ui.swt.form.fields.sequencebox.ISwtScoutSequenceBox;
import org.eclipse.scout.rt.ui.swt.util.SwtLayoutUtility;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class SwtScoutSequenceBox
extends SwtScoutFieldComposite<ISequenceBox>
implements ISwtScoutSequenceBox {
    private PropertyChangeListener m_scoutMandatoryChangeListener;
    private PropertyChangeListener m_scoutErrorStatusChangeListener;

    @Override
    protected void initializeSwt(Composite parent) {
        Composite container = this.getEnvironment().getFormToolkit().createComposite(parent);
        int labelStyle = UiDecorationExtensionPoint.getLookAndFeel().getFormFieldLabelAlignment();
        StatusLabelEx label = new StatusLabelEx(container, labelStyle, this.getEnvironment());
        this.getEnvironment().getFormToolkit().getFormToolkit().adapt((Control)label, false, false);
        Composite fieldContainer = this.getEnvironment().getFormToolkit().createComposite(container);
        IFormField[] iFormFieldArray = this.getScoutObject().getFields();
        int n = iFormFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFormField scoutField = iFormFieldArray[n2];
            ISwtScoutFormField swtFormField = this.getEnvironment().createFormField(fieldContainer, scoutField);
            ILabelComposite childLabel = swtFormField.getSwtLabel();
            if (childLabel != null && childLabel.getLayoutData() instanceof LogicalGridData) {
                ((LogicalGridData)childLabel.getLayoutData()).widthHint = 0;
            }
            SwtScoutFormFieldGridData data = new SwtScoutFormFieldGridData(scoutField){

                @Override
                public void validate() {
                    super.validate();
                    this.useUiWidth = !SwtScoutSequenceBox.this.getScoutObject().isEqualColumnWidths();
                    this.useUiHeight = true;
                }
            };
            swtFormField.getSwtContainer().setLayoutData((Object)data);
            ++n2;
        }
        this.setSwtContainer(container);
        this.setSwtLabel(label);
        this.setSwtField((Control)fieldContainer);
        fieldContainer.setLayout((Layout)new LogicalGridLayout(6, 0));
        container.setLayout((Layout)new LogicalGridLayout(1, 0));
        this.setChildMandatoryFromScout();
    }

    public Composite getSwtField() {
        return (Composite)super.getSwtField();
    }

    @Override
    public ISequenceBox getScoutObject() {
        return (ISequenceBox)super.getScoutObject();
    }

    protected void setChildMandatoryFromScout() {
        boolean inheritedMandatory = false;
        IFormField[] iFormFieldArray = this.getScoutObject().getFields();
        int n = iFormFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFormField f = iFormFieldArray[n2];
            if (f.isVisible() && f instanceof IValueField && (inheritedMandatory = ((IValueField)f).isMandatory())) break;
            ++n2;
        }
        this.setMandatoryFromScout(inheritedMandatory);
    }

    protected void setChildErrorStatusFromScout() {
        IProcessingStatus inheritedErrorStatus = null;
        IFormField[] iFormFieldArray = this.getScoutObject().getFields();
        int n = iFormFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFormField f = iFormFieldArray[n2];
            if (f.isVisible() && f instanceof IValueField) {
                inheritedErrorStatus = ((IValueField)f).getErrorStatus();
                break;
            }
            ++n2;
        }
        this.setErrorStatusFromScout(inheritedErrorStatus);
    }

    @Override
    protected void setEnabledFromScout(boolean b) {
        boolean updateLayout = false;
        if (this.getSwtLabel() != null && this.getSwtLabel().getEnabled() != b) {
            updateLayout = true;
            this.getSwtLabel().setEnabled(b);
            if (b) {
                this.getSwtLabel().setForeground(null);
            } else {
                this.getSwtLabel().setForeground(this.getEnvironment().getColor(UiDecorationExtensionPoint.getLookAndFeel().getColorForegroundDisabled()));
            }
        }
        if (updateLayout && this.isConnectedToScout()) {
            SwtLayoutUtility.invalidateLayout((Control)this.getSwtContainer());
        }
    }

    @Override
    protected void attachScout() {
        IFormField f;
        super.attachScout();
        this.m_scoutMandatoryChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                Runnable j = new Runnable(){

                    @Override
                    public void run() {
                        if (SwtScoutSequenceBox.this.getSwtContainer() != null && !SwtScoutSequenceBox.this.getSwtContainer().isDisposed()) {
                            SwtScoutSequenceBox.this.setChildMandatoryFromScout();
                        }
                    }
                };
                SwtScoutSequenceBox.this.getEnvironment().invokeSwtLater(j);
            }
        };
        IFormField[] iFormFieldArray = this.getScoutObject().getFields();
        int n = iFormFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            f = iFormFieldArray[n2];
            f.addPropertyChangeListener("mandatory", this.m_scoutMandatoryChangeListener);
            ++n2;
        }
        this.m_scoutErrorStatusChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                Runnable j = new Runnable(){

                    @Override
                    public void run() {
                        SwtScoutSequenceBox.this.setChildErrorStatusFromScout();
                    }
                };
                SwtScoutSequenceBox.this.getEnvironment().invokeSwtLater(j);
            }
        };
        iFormFieldArray = this.getScoutObject().getFields();
        n = iFormFieldArray.length;
        n2 = 0;
        while (n2 < n) {
            f = iFormFieldArray[n2];
            f.addPropertyChangeListener("errorStatus", this.m_scoutErrorStatusChangeListener);
            ++n2;
        }
    }

    @Override
    protected void detachScout() {
        if (this.m_scoutMandatoryChangeListener != null) {
            IFormField[] iFormFieldArray = this.getScoutObject().getFields();
            int n = iFormFieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFormField f = iFormFieldArray[n2];
                f.removePropertyChangeListener("mandatory", this.m_scoutMandatoryChangeListener);
                ++n2;
            }
            this.m_scoutMandatoryChangeListener = null;
        }
        super.detachScout();
    }
}

