/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.form.fields.snapbox.button;

import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.rt.client.ui.form.fields.button.IButton;
import org.eclipse.scout.rt.ui.swt.basic.SwtScoutComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SwtScoutMinimizedButton
extends SwtScoutComposite<IButton> {
    private OptimisticLock m_selectionLock = new OptimisticLock();

    @Override
    protected void initializeSwt(Composite parent) {
        Button button = this.getEnvironment().getFormToolkit().createButton(parent, "", 2);
        this.setSwtField((Control)button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SwtScoutMinimizedButton.this.handleSwtSelection(SwtScoutMinimizedButton.this.getSwtField().getSelection());
            }
        });
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        this.setIconIdFromScout(((IButton)this.getScoutObject()).getIconId());
        this.setSelectionFormScout(((IButton)this.getScoutObject()).isSelected());
        this.getSwtField().setToolTipText(((IButton)this.getScoutObject()).getLabel());
    }

    public Button getSwtField() {
        return (Button)super.getSwtField();
    }

    protected void setIconIdFromScout(String iconId) {
        this.getSwtField().setImage(this.getEnvironment().getIcon(iconId));
    }

    private void handleSwtSelection(final boolean selected) {
        try {
            if (this.m_selectionLock.acquire()) {
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        ((IButton)SwtScoutMinimizedButton.this.getScoutObject()).getUIFacade().setSelectedFromUI(selected);
                    }
                };
                this.getEnvironment().invokeScoutLater(t, 0L);
            }
        }
        finally {
            this.m_selectionLock.release();
        }
    }

    protected void setSelectionFormScout(boolean selection) {
        try {
            if (this.m_selectionLock.acquire()) {
                this.getSwtField().setSelection(selection);
            }
        }
        finally {
            this.m_selectionLock.release();
        }
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        if ("selected".equals(name)) {
            this.setSelectionFormScout((Boolean)newValue);
        } else if ("iconId".equals(name)) {
            this.setIconIdFromScout((String)newValue);
        } else {
            super.handleScoutPropertyChange(name, newValue);
        }
    }
}

