/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.form.fields.splitbox;

import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.rt.client.ui.ClientUIPreferences;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.splitbox.ISplitBox;
import org.eclipse.scout.rt.ui.swt.DefaultValidateRoot;
import org.eclipse.scout.rt.ui.swt.form.fields.SwtScoutFieldComposite;
import org.eclipse.scout.rt.ui.swt.form.fields.splitbox.ISwtScoutSplitBox;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;

public class SwtScoutSplitBox
extends SwtScoutFieldComposite<ISplitBox>
implements ISwtScoutSplitBox {
    private OptimisticLock lockSplitter = new OptimisticLock();

    @Override
    protected void initializeSwt(Composite parent) {
        SashForm container = this.getEnvironment().getFormToolkit().createSashForm(parent, ((ISplitBox)this.getScoutObject()).isSplitHorizontal() ? 256 : 512);
        container.setData("LayoutValidateManager.validateRoot", (Object)new DefaultValidateRoot((Composite)container));
        container.setBackground(container.getDisplay().getSystemColor(19));
        IFormField[] iFormFieldArray = ((ISplitBox)this.getScoutObject()).getFields();
        int n = iFormFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFormField scoutField = iFormFieldArray[n2];
            this.getEnvironment().createFormField((Composite)container, scoutField);
            ++n2;
        }
        this.setSwtContainer((Composite)container);
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        int[] a = null;
        String propName = ((ISplitBox)this.getScoutObject()).getCacheSplitterPositionPropertyName();
        if (!StringUtility.isNullOrEmpty((String)propName) && ((ISplitBox)this.getScoutObject()).isCacheSplitterPosition()) {
            try {
                a = ClientUIPreferences.getInstance().getPropertyIntArray(propName);
            }
            catch (Throwable throwable) {}
        }
        if (a != null && a.length == 2) {
            this.setSplitterPosition(a[0], a[1]);
        } else {
            this.setSplitterPositionFromScout();
        }
    }

    @Override
    protected void detachScout() {
        this.setSplitterPositionFromSwt();
        super.detachScout();
    }

    @Override
    public SashForm getSwtContainer() {
        return (SashForm)super.getSwtContainer();
    }

    protected void setSplitterPositionFromSwt() {
        String propName = ((ISplitBox)this.getScoutObject()).getCacheSplitterPositionPropertyName();
        if (!StringUtility.isNullOrEmpty((String)propName)) {
            if (((ISplitBox)this.getScoutObject()).isCacheSplitterPosition()) {
                int[] weights = this.getSwtContainer().getWeights();
                ClientUIPreferences.getInstance().setPropertyIntArray(propName, weights);
            } else {
                ClientUIPreferences.getInstance().setPropertyIntArray(propName, null);
            }
        }
    }

    protected void setSplitterPositionFromScout() {
        try {
            if (this.lockSplitter.acquire()) {
                int[] weights;
                double position = ((ISplitBox)this.getScoutObject()).getSplitterPosition();
                weights = new int[]{(int)(position * 100.0), 100 - weights[0]};
                this.getSwtContainer().setWeights(weights);
            }
        }
        finally {
            this.lockSplitter.release();
        }
    }

    protected void setSplitterPosition(int leftWidth, int rightWidth) {
        try {
            int total;
            if (this.lockSplitter.acquire() && (total = leftWidth + rightWidth) > 0) {
                int leftPct = leftWidth * 100 / total;
                int rightPct = rightWidth * 100 / total;
                this.getSwtContainer().setWeights(new int[]{leftPct, rightPct});
            }
        }
        finally {
            this.lockSplitter.release();
        }
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        if (!"splitterEnabled".equals(name) && "splitterPosition".equals(name)) {
            this.setSplitterPositionFromScout();
        }
        super.handleScoutPropertyChange(name, newValue);
    }
}

