/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.form.fields.tabbox;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.commons.RunnableWithData;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.tabbox.ITabBox;
import org.eclipse.scout.rt.ui.swt.form.fields.SwtScoutFieldComposite;
import org.eclipse.scout.rt.ui.swt.form.fields.tabbox.ISwtScoutTabBox;
import org.eclipse.scout.rt.ui.swt.form.fields.tabbox.SwtScoutTabItem;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class SwtScoutTabBox
extends SwtScoutFieldComposite<ITabBox>
implements ISwtScoutTabBox {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwtScoutTabBox.class);
    private HashMap<CTabItem, SwtScoutTabItem> m_tabs;
    private Listener m_uiTabFocusListener;
    private P_TabListener m_tabListener = new P_TabListener();
    private OptimisticLock m_selectedTabLock;
    private OptimisticLock m_rebuildItemsLock = new OptimisticLock();

    public SwtScoutTabBox() {
        this.m_selectedTabLock = new OptimisticLock();
    }

    @Override
    protected void initializeSwt(Composite parent) {
        CTabFolder tabFolder = this.getEnvironment().getFormToolkit().createTabFolder(parent);
        tabFolder.marginHeight = 8;
        this.setSwtLabel(null);
        this.setSwtField((Control)tabFolder);
        this.setSwtContainer((Composite)tabFolder);
        IGroupBox[] iGroupBoxArray = this.getScoutObject().getGroupBoxes();
        int n = iGroupBoxArray.length;
        int n2 = 0;
        while (n2 < n) {
            IGroupBox box = iGroupBoxArray[n2];
            box.addPropertyChangeListener((PropertyChangeListener)this.m_tabListener);
            ++n2;
        }
        this.rebuildItems();
        if (this.m_uiTabFocusListener == null) {
            this.m_uiTabFocusListener = new P_SwtFocusListener();
        }
        tabFolder.addListener(13, this.m_uiTabFocusListener);
        tabFolder.addListener(15, this.m_uiTabFocusListener);
        tabFolder.addListener(16, this.m_uiTabFocusListener);
    }

    protected void rebuildItems() {
        try {
            this.m_rebuildItemsLock.acquire();
            this.getSwtContainer().setRedraw(false);
            IGroupBox selectedBox = null;
            if (this.m_tabs != null) {
                SwtScoutTabItem swtScoutTabItem;
                CTabItem selectedTab = this.getSwtField().getSelection();
                if (selectedTab != null && (swtScoutTabItem = this.m_tabs.get(selectedTab)) != null && ((IGroupBox)swtScoutTabItem.getScoutObject()).isVisible()) {
                    selectedBox = (IGroupBox)swtScoutTabItem.getScoutObject();
                }
                for (SwtScoutTabItem item : this.m_tabs.values()) {
                    item.getTabItem().dispose();
                    item.dispose();
                }
            }
            this.m_tabs = new HashMap();
            CTabItem selectedCItem = null;
            IGroupBox[] iGroupBoxArray = this.getScoutObject().getGroupBoxes();
            int n = iGroupBoxArray.length;
            int n2 = 0;
            while (n2 < n) {
                IGroupBox box = iGroupBoxArray[n2];
                if (box.isVisible()) {
                    SwtScoutTabItem item = new SwtScoutTabItem();
                    item.createField((Composite)this.getSwtField(), box, this.getEnvironment());
                    this.m_tabs.put(item.getTabItem(), item);
                    if (box.equals(selectedBox)) {
                        selectedCItem = item.getTabItem();
                    }
                    if (selectedBox == null) {
                        selectedBox = box;
                        selectedCItem = item.getTabItem();
                    }
                }
                ++n2;
            }
            this.getSwtField().setSelection(selectedCItem);
        }
        finally {
            this.getSwtContainer().setRedraw(true);
            this.m_rebuildItemsLock.release();
        }
    }

    @Override
    public ITabBox getScoutObject() {
        return (ITabBox)super.getScoutObject();
    }

    public CTabFolder getSwtField() {
        return (CTabFolder)super.getSwtField();
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        this.setSelectedTabFromScout();
    }

    @Override
    protected void detachScout() {
        IGroupBox[] iGroupBoxArray = this.getScoutObject().getGroupBoxes();
        int n = iGroupBoxArray.length;
        int n2 = 0;
        while (n2 < n) {
            IGroupBox b = iGroupBoxArray[n2];
            b.removePropertyChangeListener((PropertyChangeListener)this.m_tabListener);
            ++n2;
        }
        super.detachScout();
    }

    @Override
    protected void setEnabledFromScout(boolean b) {
    }

    protected void setSelectedTabFromSwt() {
        try {
            IGroupBox box;
            CTabItem comp;
            SwtScoutTabItem tabComposite;
            if (this.m_selectedTabLock.acquire() && (tabComposite = this.m_tabs.get(comp = this.getSwtField().getSelection())) != null && (box = (IGroupBox)tabComposite.getScoutObject()) != null) {
                Runnable j = new Runnable(){

                    @Override
                    public void run() {
                        SwtScoutTabBox.this.getScoutObject().getUIFacade().setSelectedTabFromUI(box);
                    }
                };
                this.getEnvironment().invokeScoutLater(j, 0L);
            }
        }
        finally {
            this.m_selectedTabLock.release();
        }
    }

    protected void setSelectedTabFromScout() {
        try {
            this.m_selectedTabLock.acquire();
            IGroupBox selectedTab = this.getScoutObject().getSelectedTab();
            CTabItem foundItem = null;
            for (Map.Entry<CTabItem, SwtScoutTabItem> e : this.m_tabs.entrySet()) {
                IGroupBox test = (IGroupBox)e.getValue().getScoutObject();
                if (test != selectedTab) continue;
                foundItem = e.getKey();
                break;
            }
            if (foundItem != null) {
                this.getSwtField().setSelection(foundItem);
            }
        }
        finally {
            this.m_selectedTabLock.release();
        }
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("selectedTab")) {
            this.setSelectedTabFromScout();
        }
    }

    private class P_SwtFocusListener
    implements Listener {
        private SwtScoutTabItem m_focusedItem;

        private P_SwtFocusListener() {
        }

        public void handleEvent(Event event) {
            SwtScoutTabItem item = (SwtScoutTabItem)SwtScoutTabBox.this.m_tabs.get(SwtScoutTabBox.this.getSwtField().getSelection());
            switch (event.type) {
                case 13: {
                    SwtScoutTabBox.this.setSelectedTabFromSwt();
                    if (this.m_focusedItem == item) {
                        return;
                    }
                    if (this.m_focusedItem != null) {
                        this.m_focusedItem.setUiFocus(false);
                    }
                    this.m_focusedItem = item;
                    this.m_focusedItem.setUiFocus(true);
                    break;
                }
                case 16: {
                    if (this.m_focusedItem == null) break;
                    this.m_focusedItem.setUiFocus(false);
                    this.m_focusedItem = null;
                    break;
                }
                case 15: {
                    if (this.m_focusedItem != null) {
                        this.m_focusedItem.setUiFocus(false);
                    }
                    this.m_focusedItem = item;
                    this.m_focusedItem.setUiFocus(true);
                    break;
                }
            }
        }
    }

    private class P_TabListener
    implements PropertyChangeListener {
        private P_TabListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("visible")) {
                try {
                    if (SwtScoutTabBox.this.m_rebuildItemsLock.acquire()) {
                        RunnableWithData t = new RunnableWithData(){

                            public void run() {
                                SwtScoutTabBox.this.rebuildItems();
                            }
                        };
                        SwtScoutTabBox.this.getEnvironment().invokeSwtLater((Runnable)t);
                    }
                }
                finally {
                    SwtScoutTabBox.this.m_rebuildItemsLock.release();
                }
            }
        }
    }
}

