/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.form.fields.tablefield;

import org.eclipse.scout.commons.exception.IProcessingStatus;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.form.fields.tablefield.ITableField;
import org.eclipse.scout.rt.ui.swt.LogicalGridData;
import org.eclipse.scout.rt.ui.swt.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swt.basic.table.ISwtScoutTable;
import org.eclipse.scout.rt.ui.swt.basic.table.SwtScoutTable;
import org.eclipse.scout.rt.ui.swt.ext.StatusLabelEx;
import org.eclipse.scout.rt.ui.swt.extension.UiDecorationExtensionPoint;
import org.eclipse.scout.rt.ui.swt.form.fields.LogicalGridDataBuilder;
import org.eclipse.scout.rt.ui.swt.form.fields.SwtScoutFieldComposite;
import org.eclipse.scout.rt.ui.swt.form.fields.tablefield.ISwtScoutTableField;
import org.eclipse.scout.rt.ui.swt.form.fields.tablefield.ISwtTableStatus;
import org.eclipse.scout.rt.ui.swt.form.fields.tablefield.SwtTableStatus;
import org.eclipse.scout.rt.ui.swt.util.SwtLayoutUtility;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class SwtScoutTableField
extends SwtScoutFieldComposite<ITableField<? extends ITable>>
implements ISwtScoutTableField {
    private ISwtScoutTable m_tableComposite;
    private ISwtTableStatus m_swtTableStatus;

    @Override
    protected void initializeSwt(Composite parent) {
        Composite container = this.getEnvironment().getFormToolkit().createComposite(parent);
        int labelStyle = UiDecorationExtensionPoint.getLookAndFeel().getFormFieldLabelAlignment();
        StatusLabelEx label = new StatusLabelEx(container, labelStyle, this.getEnvironment());
        this.getEnvironment().getFormToolkit().getFormToolkit().adapt((Control)label, false, false);
        this.setSwtContainer(container);
        this.setSwtLabel(label);
        LogicalGridLayout containerLayout = new LogicalGridLayout(1, 0);
        container.setLayout((Layout)containerLayout);
    }

    @Override
    protected void setFieldEnabled(Control swtField, boolean b) {
        if (this.m_tableComposite != null) {
            this.m_tableComposite.setEnabledFromScout(b);
        }
    }

    @Override
    public Control getSwtField() {
        return super.getSwtField();
    }

    @Override
    protected void attachScout() {
        this.setTableFromScout(((ITableField)this.getScoutObject()).getTable());
        super.attachScout();
    }

    protected synchronized void setTableFromScout(ITable table) {
        try {
            this.getSwtContainer().setRedraw(false);
            if (this.m_tableComposite != null && !this.m_tableComposite.isDisposed()) {
                this.m_tableComposite.dispose();
            }
            if (this.m_swtTableStatus != null) {
                this.m_swtTableStatus.dispose();
            }
            this.m_tableComposite = null;
            this.m_swtTableStatus = null;
            if (table != null) {
                LogicalGridData tableGridData = LogicalGridDataBuilder.createField(((ITableField)this.getScoutObject()).getGridData());
                this.m_tableComposite = this.createSwtScoutTable();
                this.m_tableComposite.createField(this.getSwtContainer(), ((ITableField)this.getScoutObject()).getTable(), this.getEnvironment());
                this.m_tableComposite.getSwtField().setLayoutData((Object)tableGridData);
                if (((ITableField)this.getScoutObject()).isTableStatusVisible()) {
                    this.m_swtTableStatus = this.createSwtTableStatus();
                }
                this.setSwtField(this.m_tableComposite.getSwtField());
                this.setTableStatusFromScout();
            }
        }
        finally {
            this.getSwtContainer().setRedraw(true);
        }
        if (!this.getSwtContainer().isDisposed()) {
            this.getSwtContainer().layout(true, true);
        }
    }

    protected void setTableStatusFromScout() {
        if (this.m_swtTableStatus != null) {
            IProcessingStatus dataStatus = ((ITableField)this.getScoutObject()).getTablePopulateStatus();
            IProcessingStatus selectionStatus = ((ITableField)this.getScoutObject()).getTableSelectionStatus();
            this.m_swtTableStatus.setStatus(dataStatus, selectionStatus);
        }
    }

    protected ISwtScoutTable createSwtScoutTable() {
        return new SwtScoutTable();
    }

    protected ISwtTableStatus createSwtTableStatus() {
        return new SwtTableStatus(this.getEnvironment(), this.getSwtContainer(), (ITableField)this.getScoutObject());
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("table")) {
            this.setTableFromScout((ITable)newValue);
            if (this.isConnectedToScout()) {
                SwtLayoutUtility.invalidateLayout((Control)this.getSwtContainer());
            }
        } else if (name.equals("tableSelectionStatus")) {
            this.setTableStatusFromScout();
        } else if (name.equals("tablePopulateStatus")) {
            this.setTableStatusFromScout();
        }
    }
}

