/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.form.fields.treefield;

import org.eclipse.scout.rt.client.ui.basic.tree.ITree;
import org.eclipse.scout.rt.client.ui.form.fields.treefield.ITreeField;
import org.eclipse.scout.rt.ui.swt.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swt.basic.tree.SwtScoutTree;
import org.eclipse.scout.rt.ui.swt.ext.StatusLabelEx;
import org.eclipse.scout.rt.ui.swt.extension.UiDecorationExtensionPoint;
import org.eclipse.scout.rt.ui.swt.form.fields.LogicalGridDataBuilder;
import org.eclipse.scout.rt.ui.swt.form.fields.SwtScoutFieldComposite;
import org.eclipse.scout.rt.ui.swt.form.fields.treefield.ISwtScoutTreeField;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class SwtScoutTreeField
extends SwtScoutFieldComposite<ITreeField>
implements ISwtScoutTreeField {
    private SwtScoutTree m_treeComposite;

    @Override
    protected void initializeSwt(Composite parent) {
        Composite container = this.getEnvironment().getFormToolkit().createComposite(parent);
        int labelStyle = UiDecorationExtensionPoint.getLookAndFeel().getFormFieldLabelAlignment();
        StatusLabelEx label = new StatusLabelEx(container, labelStyle, this.getEnvironment());
        this.getEnvironment().getFormToolkit().getFormToolkit().adapt((Control)label, false, false);
        this.setSwtContainer(container);
        this.setSwtLabel(label);
        container.setLayout((Layout)new LogicalGridLayout(1, 0));
    }

    @Override
    protected void attachScout() {
        this.setTreeFromScout(((ITreeField)this.getScoutObject()).getTree());
        super.attachScout();
    }

    protected void setTreeFromScout(ITree tree) {
        if (this.m_treeComposite != null) {
            this.m_treeComposite.dispose();
            this.m_treeComposite = null;
        }
        if (tree != null) {
            this.m_treeComposite = new SwtScoutTree();
            this.m_treeComposite.createField(this.getSwtContainer(), ((ITreeField)this.getScoutObject()).getTree(), this.getEnvironment());
            this.m_treeComposite.getSwtField().setLayoutData(LogicalGridDataBuilder.createField(((ITreeField)this.getScoutObject()).getGridData()));
            this.setSwtField((Control)this.m_treeComposite.getSwtField());
        }
        this.getSwtContainer().layout(true, true);
    }

    @Override
    protected void setFieldEnabled(Control swtField, boolean b) {
        if (this.hasSwtTree()) {
            this.m_treeComposite.setEnabledFromScout(b);
        }
    }

    protected boolean hasSwtTree() {
        return this.m_treeComposite != null && this.m_treeComposite.isInitialized();
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("tree")) {
            this.setTreeFromScout((ITree)newValue);
        }
    }
}

