/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.form.radiobuttongroup;

import java.util.ArrayList;
import org.eclipse.scout.rt.client.ui.form.fields.GridData;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.radiobuttongroup.IRadioButtonGroup;
import org.eclipse.scout.rt.ui.swt.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swt.ext.StatusLabelEx;
import org.eclipse.scout.rt.ui.swt.extension.IUiDecoration;
import org.eclipse.scout.rt.ui.swt.extension.UiDecorationExtensionPoint;
import org.eclipse.scout.rt.ui.swt.form.fields.ISwtScoutFormField;
import org.eclipse.scout.rt.ui.swt.form.fields.SwtScoutValueFieldComposite;
import org.eclipse.scout.rt.ui.swt.form.radiobuttongroup.ISwtScoutRadioButtonGroup;
import org.eclipse.scout.rt.ui.swt.form.radiobuttongroup.layout.RadioButtonGroupLayout;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class SwtScoutRadioButtonGroup
extends SwtScoutValueFieldComposite<IRadioButtonGroup<?>>
implements ISwtScoutRadioButtonGroup {
    private P_SwtButtonListener m_swtButtonListener = new P_SwtButtonListener();
    private ArrayList<Button> m_swtRadioButtons = new ArrayList();

    @Override
    protected void initializeSwt(Composite parent) {
        boolean usesLogicalGrid;
        Composite container = this.getEnvironment().getFormToolkit().createComposite(parent);
        int labelStyle = UiDecorationExtensionPoint.getLookAndFeel().getFormFieldLabelAlignment();
        StatusLabelEx label = new StatusLabelEx(container, labelStyle, this.getEnvironment());
        this.getEnvironment().getFormToolkit().getFormToolkit().adapt((Control)label, false, false);
        P_RadioButtonComposite buttonArea = new P_RadioButtonComposite(container);
        this.getEnvironment().getFormToolkit().adapt(buttonArea);
        IFormField[] iFormFieldArray = ((IRadioButtonGroup)this.getScoutObject()).getFields();
        int n = iFormFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFormField scoutField = iFormFieldArray[n2];
            ISwtScoutFormField swtField = this.getEnvironment().createFormField(buttonArea, scoutField);
            if (swtField.getSwtField() instanceof Button) {
                Button swtButton = (Button)swtField.getSwtField();
                swtButton.addListener(13, (Listener)this.m_swtButtonListener);
                swtButton.addListener(1, (Listener)this.m_swtButtonListener);
                this.m_swtRadioButtons.add(swtButton);
                if (swtButton.getSelection()) {
                    buttonArea.setTabList(new Control[]{swtButton.getParent()});
                }
            }
            ++n2;
        }
        this.setSwtContainer(container);
        this.setSwtLabel(label);
        this.setSwtField((Control)buttonArea);
        this.getSwtContainer().setLayout((Layout)new LogicalGridLayout(1, 0));
        GridData scoutGridData = ((IRadioButtonGroup)this.getScoutObject()).getGridData();
        boolean bl = usesLogicalGrid = ((IRadioButtonGroup)this.getScoutObject()).getGridRowCount() == scoutGridData.h && !scoutGridData.useUiHeight;
        if (usesLogicalGrid) {
            IUiDecoration deco = UiDecorationExtensionPoint.getLookAndFeel();
            this.getSwtField().setLayout((Layout)new RadioButtonGroupLayout((IRadioButtonGroup)this.getScoutObject(), deco.getLogicalGridLayoutHorizontalGap(), deco.getLogicalGridLayoutVerticalGap()));
        } else {
            this.getSwtField().setLayout((Layout)new RadioButtonGroupLayout((IRadioButtonGroup)this.getScoutObject(), 0, 4));
        }
    }

    public Composite getSwtField() {
        return (Composite)super.getSwtField();
    }

    @Override
    protected void setFocusRequestedFromScout(boolean b) {
        Control[] tabList = this.getSwtField().getTabList();
        if (b && tabList != null && tabList.length > 0) {
            tabList[0].setFocus();
        }
    }

    @Override
    protected void setBackgroundFromScout(String scoutColor) {
        if (this.getSwtField() != null) {
            Composite fld = this.getSwtField();
            if (fld.getData("scoutInitialBackground") == null) {
                fld.setData("scoutInitialBackground", (Object)fld.getBackground());
            }
            Color initCol = (Color)fld.getData("scoutInitialBackground");
            Color c = this.getEnvironment().getColor(scoutColor);
            if (c == null) {
                c = initCol;
            }
            fld.setBackground(c);
            for (Button b : this.m_swtRadioButtons) {
                b.setBackground(c);
            }
        }
    }

    private class P_RadioButtonComposite
    extends Composite {
        public P_RadioButtonComposite(Composite parent) {
            super(parent, 0);
        }

        protected void checkSubclass() {
        }

        public boolean setFocus() {
            for (Button b : SwtScoutRadioButtonGroup.this.m_swtRadioButtons) {
                if (!b.getSelection()) continue;
                return b.getParent().setFocus();
            }
            return super.setFocus();
        }
    }

    private class P_SwtButtonListener
    implements Listener {
        private P_SwtButtonListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 13: {
                    Button button = (Button)event.widget;
                    this.handleSelectionChanged(button);
                    break;
                }
                case 1: {
                    this.handleKeyDown(event);
                }
            }
        }

        private void handleSelectionChanged(Button selectedButton) {
            SwtScoutRadioButtonGroup.this.getSwtField().setTabList(new Control[]{selectedButton.getParent()});
        }

        private void handleKeyDown(Event event) {
            int index = SwtScoutRadioButtonGroup.this.m_swtRadioButtons.indexOf(event.widget);
            switch (event.keyCode) {
                case 0x1000002: 
                case 0x1000004: {
                    ++index;
                    break;
                }
                case 0x1000001: 
                case 0x1000003: {
                    index = index + SwtScoutRadioButtonGroup.this.m_swtRadioButtons.size() - 1;
                    break;
                }
                case 0x1000007: {
                    index = 0;
                    break;
                }
                case 0x1000008: {
                    index = SwtScoutRadioButtonGroup.this.m_swtRadioButtons.size() - 1;
                }
            }
            ((Button)SwtScoutRadioButtonGroup.this.m_swtRadioButtons.get(index %= SwtScoutRadioButtonGroup.this.m_swtRadioButtons.size())).setFocus();
        }
    }
}

