/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.internal;

import java.util.Stack;
import org.eclipse.scout.rt.ui.swt.ext.StyledTextEx;
import org.eclipse.scout.rt.ui.swt.util.SwtUtility;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ExtendedModifyEvent;
import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MenuItem;

public class StyledTextFieldUndoRedoSupport {
    private StyledTextEx m_styledText;
    private MenuListener m_menuListener;
    private MenuItem m_undoRedoSeparator;
    private MenuItem m_undoItem;
    private MenuItem m_redoItem;
    private SelectionAdapter m_undoSelectionAdapter;
    private SelectionAdapter m_redoSelectionAdapter;
    private ExtendedModifyListener m_modifyListener;
    private KeyAdapter m_keyAdapter;
    private static final int MAX_STACK_SIZE = 25;
    private boolean fillUndo = true;
    private boolean clearRedo = true;
    private Stack<P_TextChange> undoStack;
    private Stack<P_TextChange> redoStack;
    private boolean disposed = true;

    public StyledTextFieldUndoRedoSupport(StyledTextEx styledText) {
        this.m_styledText = styledText;
        this.init();
    }

    private void init() {
        this.m_menuListener = new MenuListener(){

            public void menuHidden(MenuEvent e) {
            }

            public void menuShown(MenuEvent e) {
                if (StyledTextFieldUndoRedoSupport.this.m_styledText.isEnabled()) {
                    StyledTextFieldUndoRedoSupport.this.m_undoItem.setEnabled(!StyledTextFieldUndoRedoSupport.this.undoStack.isEmpty() && StyledTextFieldUndoRedoSupport.this.m_styledText.getEditable());
                    StyledTextFieldUndoRedoSupport.this.m_redoItem.setEnabled(!StyledTextFieldUndoRedoSupport.this.redoStack.isEmpty() && StyledTextFieldUndoRedoSupport.this.m_styledText.getEditable());
                }
            }
        };
        this.m_styledText.getMenu().addMenuListener(this.m_menuListener);
        this.undoStack = new Stack();
        this.redoStack = new Stack();
        this.m_modifyListener = new ExtendedModifyListener(){

            public void modifyText(ExtendedModifyEvent event) {
                if (StyledTextFieldUndoRedoSupport.this.fillUndo) {
                    if (StyledTextFieldUndoRedoSupport.this.clearRedo) {
                        StyledTextFieldUndoRedoSupport.this.redoStack.clear();
                    }
                    if (StyledTextFieldUndoRedoSupport.this.undoStack.size() == 25) {
                        StyledTextFieldUndoRedoSupport.this.undoStack.remove(0);
                    }
                    StyledTextFieldUndoRedoSupport.this.undoStack.push(new P_TextChange(event.start, event.length, event.replacedText));
                } else {
                    if (StyledTextFieldUndoRedoSupport.this.redoStack.size() == 25) {
                        StyledTextFieldUndoRedoSupport.this.redoStack.remove(0);
                    }
                    StyledTextFieldUndoRedoSupport.this.redoStack.push(new P_TextChange(event.start, event.length, event.replacedText));
                }
            }
        };
        this.m_styledText.addExtendedModifyListener(this.m_modifyListener);
        this.m_undoRedoSeparator = new MenuItem(this.m_styledText.getMenu(), 2);
        this.m_undoItem = new MenuItem(this.m_styledText.getMenu(), 8);
        this.m_undoSelectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StyledTextFieldUndoRedoSupport.this.undo();
            }
        };
        this.m_undoItem.addSelectionListener((SelectionListener)this.m_undoSelectionAdapter);
        this.m_undoItem.setText(SwtUtility.getNlsText(Display.getCurrent(), "Undo", new String[0]));
        this.m_redoItem = new MenuItem(this.m_styledText.getMenu(), 8);
        this.m_redoSelectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StyledTextFieldUndoRedoSupport.this.redo();
            }
        };
        this.m_redoItem.addSelectionListener((SelectionListener)this.m_redoSelectionAdapter);
        this.m_redoItem.setText(SwtUtility.getNlsText(Display.getCurrent(), "Redo", new String[0]));
        this.m_keyAdapter = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if ((e.stateMask & SWT.MODIFIER_MASK) == 262144) {
                    switch (e.keyCode) {
                        case 89: 
                        case 121: {
                            StyledTextFieldUndoRedoSupport.this.redo();
                            break;
                        }
                        case 90: 
                        case 122: {
                            StyledTextFieldUndoRedoSupport.this.undo();
                        }
                    }
                }
            }
        };
        this.m_styledText.addKeyListener((KeyListener)this.m_keyAdapter);
        this.disposed = false;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public void dispose() {
        if (!this.m_styledText.isDisposed()) {
            this.m_styledText.removeExtendedModifyListener(this.m_modifyListener);
            this.m_styledText.removeKeyListener((KeyListener)this.m_keyAdapter);
            if (this.m_styledText.getMenu() != null && !this.m_styledText.getMenu().isDisposed()) {
                this.m_styledText.getMenu().removeMenuListener(this.m_menuListener);
            }
        }
        if (!this.m_undoRedoSeparator.isDisposed()) {
            this.m_undoRedoSeparator.dispose();
        }
        if (!this.m_undoItem.isDisposed()) {
            this.m_undoItem.removeSelectionListener((SelectionListener)this.m_undoSelectionAdapter);
            this.m_undoItem.dispose();
        }
        if (!this.m_redoItem.isDisposed()) {
            this.m_redoItem.removeSelectionListener((SelectionListener)this.m_redoSelectionAdapter);
            this.m_redoItem.dispose();
        }
        this.undoStack.clear();
        this.redoStack.clear();
        this.disposed = true;
    }

    public void clearStacks() {
        this.undoStack.clear();
        this.redoStack.clear();
    }

    private void undo() {
        if (!this.undoStack.isEmpty()) {
            P_TextChange change = this.undoStack.pop();
            this.fillUndo = false;
            this.m_styledText.replaceTextRange(change.getStart(), change.getLength(), change.getReplacedText());
            this.m_styledText.setCaretOffset(change.getStart());
            this.m_styledText.setTopIndex(this.m_styledText.getLineAtOffset(change.getStart()));
            int length = change.getLength() == 0 ? change.getReplacedText().length() : change.getLength();
            this.m_styledText.setSelectionRange(change.getStart(), length);
            this.fillUndo = true;
        }
    }

    private void redo() {
        if (this.redoStack.size() > 0) {
            P_TextChange change = this.redoStack.pop();
            this.clearRedo = false;
            this.m_styledText.replaceTextRange(change.getStart(), change.getLength(), change.getReplacedText());
            this.m_styledText.setCaretOffset(change.getStart());
            this.m_styledText.setTopIndex(this.m_styledText.getLineAtOffset(change.getStart()));
            int length = change.getLength() == 0 ? change.getReplacedText().length() : change.getLength();
            this.m_styledText.setSelectionRange(change.getStart(), length);
            this.clearRedo = true;
        }
    }

    class P_TextChange {
        private int start;
        private int length;
        String replacedText;

        public P_TextChange(int start, int length, String replacedText) {
            this.start = start;
            this.length = length;
            this.replacedText = replacedText;
        }

        public int getStart() {
            return this.start;
        }

        public int getLength() {
            return this.length;
        }

        public String getReplacedText() {
            return this.replacedText;
        }
    }
}

