/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.login.internal;

import org.eclipse.scout.rt.ui.swt.login.internal.AuthStatus;
import org.eclipse.scout.rt.ui.swt.login.internal.InternalNetAuthenticator;
import org.eclipse.scout.rt.ui.swt.util.SwtUtility;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LoginDialog
extends Dialog {
    private AuthStatus m_status;
    private Button m_saveCheckbox;
    private Button m_okButton;

    public LoginDialog(Shell parent, int style, AuthStatus status) {
        super(parent, style | 0x860 | 0x10000);
        this.setText(SwtUtility.getNlsText(parent.getDisplay(), "Login", new String[0]));
        this.m_status = status;
    }

    public void open() {
        Shell shell = this.getParent();
        shell.setText(this.getText());
        this.createContents(shell);
        this.updateOkButton();
        shell.setLocation(shell.getBounds().width / 2, shell.getBounds().height / 2);
        shell.pack();
        shell.open();
        Display display = this.getParent().getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private void createContents(final Shell shell) {
        GridLayout gridLayout = new GridLayout(3, true);
        gridLayout.marginLeft = 10;
        gridLayout.marginRight = 10;
        gridLayout.marginTop = 10;
        gridLayout.marginBottom = 10;
        gridLayout.makeColumnsEqualWidth = true;
        shell.setLayout((Layout)gridLayout);
        Label urlLabel = new Label((Composite)shell, 0);
        GridData data = new GridData(128);
        data.horizontalSpan = 1;
        urlLabel.setLayoutData((Object)data);
        Label url = new Label((Composite)shell, 0);
        data = new GridData(800);
        data.horizontalSpan = 2;
        data.widthHint = 120;
        url.setLayoutData((Object)data);
        if (this.m_status.isProxy()) {
            url.setText("PROXY " + this.m_status.getUrl().getHost());
        } else {
            url.setText(this.m_status.getUrl().getHost());
        }
        Label userLabel = new Label((Composite)shell, 0);
        userLabel.setText(SwtUtility.getNlsText(Display.getCurrent(), "Username", new String[0]));
        data = new GridData(128);
        data.horizontalSpan = 1;
        userLabel.setLayoutData((Object)data);
        final Text user = new Text((Composite)shell, 2048);
        data = new GridData(800);
        data.horizontalSpan = 2;
        data.widthHint = 120;
        user.setLayoutData((Object)data);
        if (this.m_status.getUsername() != null) {
            user.setText(this.m_status.getUsername());
        }
        user.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LoginDialog.this.m_status.setUsername(user.getText());
                LoginDialog.this.updateOkButton();
            }
        });
        Label passLabel = new Label((Composite)shell, 0);
        passLabel.setText(SwtUtility.getNlsText(Display.getCurrent(), "Password", new String[0]));
        data = new GridData(128);
        data.horizontalSpan = 1;
        passLabel.setLayoutData((Object)data);
        final Text pass = new Text((Composite)shell, 0x400800);
        data = new GridData(800);
        data.horizontalSpan = 2;
        data.widthHint = 120;
        pass.setLayoutData((Object)data);
        if (this.m_status.getPassword() != null) {
            pass.setText(this.m_status.getPassword());
        }
        pass.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LoginDialog.this.m_status.setPassword(pass.getText());
                LoginDialog.this.updateOkButton();
            }
        });
        if (InternalNetAuthenticator.NET_AUTHENTICATION_CACHE_ENABLED) {
            Label saveLabel = new Label((Composite)shell, 0);
            data = new GridData(128);
            data.horizontalSpan = 1;
            saveLabel.setLayoutData((Object)data);
            this.m_saveCheckbox = new Button((Composite)shell, 32);
            this.m_saveCheckbox.setText(SwtUtility.getNlsText(Display.getCurrent(), "SavePassword", new String[0]));
            this.m_saveCheckbox.setSelection(false);
            this.m_saveCheckbox.setVisible(this.m_status.isAllowSavePassword());
            data = new GridData(800);
            data.horizontalSpan = 2;
            data.widthHint = 120;
            this.m_saveCheckbox.setLayoutData((Object)data);
        }
        this.m_okButton = new Button((Composite)shell, 8);
        this.m_okButton.setText(SwtUtility.getNlsText(Display.getCurrent(), "Ok", new String[0]));
        data = new GridData(132);
        data.horizontalSpan = 2;
        data.widthHint = 60;
        this.m_okButton.setLayoutData((Object)data);
        this.m_okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (LoginDialog.this.m_saveCheckbox != null) {
                    LoginDialog.this.m_status.setSavePassword(LoginDialog.this.m_saveCheckbox.getSelection());
                }
                LoginDialog.this.m_status.setOk();
                LoginDialog.this.m_status = null;
                shell.close();
            }
        });
        this.m_okButton.setEnabled(false);
        Button cancel = new Button((Composite)shell, 8);
        cancel.setText(SwtUtility.getNlsText(Display.getCurrent(), "Cancel", new String[0]));
        data = new GridData(132);
        data.horizontalSpan = 1;
        data.widthHint = 60;
        cancel.setLayoutData((Object)data);
        cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LoginDialog.this.m_status.setCancel();
                LoginDialog.this.m_status = null;
                shell.close();
            }
        });
        shell.setDefaultButton(this.m_okButton);
    }

    private void updateOkButton() {
        if (this.m_status.getUsername() != null && this.m_status.getUsername().length() > 0 && this.m_status.getPassword() != null && this.m_status.getPassword().length() > 0) {
            this.m_okButton.setEnabled(true);
        } else {
            this.m_okButton.setEnabled(false);
        }
    }
}

