/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.services;

import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.service.AbstractService;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class SwtScoutProgressService
extends AbstractService {
    private static IScoutLogger LOG = ScoutLogManager.getLogger(SwtScoutProgressService.class);
    public static final String BUSYID_NAME = "SWT BusyIndicator";
    public static final String CURSOR_BACKUP = "CursorBackup";
    private Object m_requestorListLock = new Object();
    private HashSet<Object> m_requestorList = new HashSet();
    private int m_currentBusyId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWaitingCursor(boolean busyRequest, Object requestor) {
        block8: {
            Shell[] shells;
            Cursor cursor;
            Display display;
            block9: {
                boolean newValue;
                boolean oldValue;
                Object object = this.m_requestorListLock;
                synchronized (object) {
                    boolean bl = oldValue = this.m_requestorList.size() > 0;
                    if (busyRequest) {
                        this.m_requestorList.add(requestor);
                    } else {
                        this.m_requestorList.remove(requestor);
                    }
                    newValue = this.m_requestorList.size() > 0;
                }
                if (oldValue == newValue || (display = this.getDisplay()) == null) break block8;
                cursor = display.getSystemCursor(1);
                if (!newValue) break block9;
                final Shell[] shells2 = display.getShells();
                final AtomicInteger busyId = new AtomicInteger(Integer.MIN_VALUE);
                BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        int max = Integer.MIN_VALUE;
                        Shell[] shellArray = shells2;
                        int n = shells2.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Shell shell = shellArray[n2];
                            Integer id = (Integer)shell.getData(SwtScoutProgressService.BUSYID_NAME);
                            if (id != null) {
                                max = Math.max(max, id);
                            }
                            ++n2;
                        }
                        busyId.set(max);
                    }
                });
                if (busyId.get() <= Integer.MIN_VALUE) break block8;
                this.m_currentBusyId = busyId.get();
                Shell[] shellArray = shells2;
                int n = shells2.length;
                int n2 = 0;
                while (n2 < n) {
                    Shell shell = shellArray[n2];
                    shell.setCursor(cursor);
                    shell.setData(BUSYID_NAME, (Object)this.m_currentBusyId);
                    this.setWaitCursorOnCustomFieldsRec(cursor, shell.getChildren());
                    ++n2;
                }
                break block8;
            }
            Shell[] shellArray = shells = display.getShells();
            int n = shells.length;
            int n3 = 0;
            while (n3 < n) {
                Shell shell = shellArray[n3];
                Integer id = (Integer)shell.getData(BUSYID_NAME);
                if (id != null && id <= this.m_currentBusyId) {
                    shell.setCursor(null);
                    shell.setData(BUSYID_NAME, null);
                    this.unsetWaitCursorOnCustomFieldsRec(shell.getChildren(), cursor);
                }
                ++n3;
            }
        }
    }

    private void setWaitCursorOnCustomFieldsRec(Cursor waitCursor, Control[] items) {
        if (items == null) {
            return;
        }
        Control[] controlArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (!(c instanceof Browser) && c instanceof StyledText) {
                StyledText text = (StyledText)c;
                Cursor backupCursor = text.getCursor();
                if (backupCursor != null) {
                    text.setData(CURSOR_BACKUP, (Object)backupCursor);
                }
                text.setCursor(waitCursor);
            }
            if (c instanceof Composite) {
                this.setWaitCursorOnCustomFieldsRec(waitCursor, ((Composite)c).getChildren());
            }
            ++n2;
        }
    }

    private void unsetWaitCursorOnCustomFieldsRec(Control[] items, Cursor waitCursor) {
        if (items == null) {
            return;
        }
        Control[] controlArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            StyledText text;
            Control c = controlArray[n2];
            if (!(c instanceof Browser) && c instanceof StyledText && (text = (StyledText)c).getCursor() == waitCursor) {
                Cursor backupCursor = (Cursor)text.getData(CURSOR_BACKUP);
                text.setData(CURSOR_BACKUP, null);
                text.setCursor(backupCursor);
            }
            if (c instanceof Composite) {
                this.unsetWaitCursorOnCustomFieldsRec(((Composite)c).getChildren(), waitCursor);
            }
            ++n2;
        }
    }

    private Display getDisplay() {
        Display d = null;
        if (PlatformUI.isWorkbenchRunning() && PlatformUI.getWorkbench() != null) {
            d = PlatformUI.getWorkbench().getDisplay();
        }
        if (d == null) {
            d = Display.getCurrent();
        }
        if (d == null) {
            d = Display.getDefault();
        }
        return d;
    }
}

