/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.services.common.clipboard;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.commons.annotations.Priority;
import org.eclipse.scout.commons.dnd.ImageTransferObject;
import org.eclipse.scout.commons.dnd.TextTransferObject;
import org.eclipse.scout.commons.dnd.TransferObject;
import org.eclipse.scout.commons.dnd.TransferObjectRequest;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.services.common.clipboard.IClipboardConsumer;
import org.eclipse.scout.rt.client.services.common.clipboard.IClipboardService;
import org.eclipse.scout.rt.ui.swt.util.SwtUtility;
import org.eclipse.scout.service.AbstractService;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.ImageTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

@Priority(value=-2.0f)
public class SwtScoutClipboardService
extends AbstractService
implements IClipboardService {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwtScoutClipboardService.class);
    private Clipboard m_clipboard;

    public void consumeContents(final IClipboardConsumer clipboardConsumer, final TransferObjectRequest ... requests) throws ProcessingException {
        final IClientSession clientSession = ClientSyncJob.getCurrentSession();
        try {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        final TransferObject[] transferObjects = SwtScoutClipboardService.this.createScoutTransferables(requests);
                        ClientSyncJob clipboardConsumerJob = new ClientSyncJob(String.valueOf(SwtScoutClipboardService.class.getSimpleName()) + " consume", clientSession){

                            protected void runVoid(IProgressMonitor monitor) throws Throwable {
                                clipboardConsumer.consume(transferObjects);
                            }
                        };
                        clipboardConsumerJob.schedule();
                    }
                    catch (Throwable t) {
                        LOG.warn("Cannot get system clipboard's contents", t);
                    }
                }
            });
        }
        catch (Throwable t) {
            throw new ProcessingException("Cannot get system clipboard's contents", t);
        }
    }

    public void setContents(final TransferObject transferObject) throws ProcessingException {
        try {
            if (transferObject == null) {
                return;
            }
            final Transfer transfer = this.createSwtTransfer(transferObject.getClass());
            if (transfer == null) {
                throw new IllegalArgumentException("unsupported transfer object type: " + transferObject);
            }
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        Object contents = SwtUtility.createSwtTransferable(transferObject);
                        if (contents != null) {
                            SwtScoutClipboardService.this.getSwtClipboard().setContents(new Object[]{contents}, new Transfer[]{transfer});
                        }
                    }
                    catch (Throwable t) {
                        LOG.warn("Cannot set system clipboard's contents", t);
                    }
                }
            });
        }
        catch (Throwable t) {
            throw new ProcessingException("Cannot set system clipboard's contents", t);
        }
    }

    public void setTextContents(String textContents) throws ProcessingException {
        this.setContents((TransferObject)new TextTransferObject(textContents));
    }

    private TransferObject[] createScoutTransferables(TransferObjectRequest ... requests) {
        ArrayList<TransferObject> result = new ArrayList<TransferObject>();
        if (requests != null) {
            TransferObjectRequest[] transferObjectRequestArray = requests;
            int n = requests.length;
            int n2 = 0;
            while (n2 < n) {
                TransferObjectRequest request = transferObjectRequestArray[n2];
                try {
                    Transfer swtTransfer = this.createSwtTransfer(request.getTransferObjectType());
                    Object contents = this.getSwtClipboard().getContents(swtTransfer);
                    TransferObject scoutTransferObject = this.createScoutTransferObject(swtTransfer, contents);
                    if (scoutTransferObject != null) {
                        result.add(scoutTransferObject);
                    }
                }
                catch (Exception e) {
                    LOG.warn("Cannot create scout transform object", (Throwable)e);
                }
                ++n2;
            }
        }
        return result.toArray(new TransferObject[result.size()]);
    }

    private Transfer createSwtTransfer(Class<? extends TransferObject> transferObjectType) {
        if (TextTransferObject.class.equals(transferObjectType)) {
            return TextTransfer.getInstance();
        }
        if (ImageTransferObject.class.equals(transferObjectType)) {
            return ImageTransfer.getInstance();
        }
        return null;
    }

    private TransferObject createScoutTransferObject(Transfer transfer, Object contents) {
        if (transfer instanceof ImageTransfer) {
            return new ImageTransferObject(contents);
        }
        if (transfer instanceof TextTransfer) {
            return new TextTransferObject((String)contents);
        }
        return null;
    }

    private Clipboard getSwtClipboard() {
        if (this.m_clipboard == null || this.m_clipboard.isDisposed()) {
            this.m_clipboard = new Clipboard(this.getDisplay());
        }
        return this.m_clipboard;
    }

    private Display getDisplay() {
        if (PlatformUI.isWorkbenchRunning()) {
            return PlatformUI.getWorkbench().getDisplay();
        }
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }
}

