/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.util;

import java.util.HashMap;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;

public class FontRegistry {
    private final Display m_display;
    private HashMap<String, Font> m_fontCache = new HashMap();

    public FontRegistry(Display display) {
        this.m_display = display;
    }

    public Font getFont(FontSpec scoutFont, Font templateFont) {
        if (scoutFont == null) {
            return templateFont;
        }
        Font font = this.m_fontCache.get(scoutFont.toPattern());
        if (font == null) {
            int size;
            String name = scoutFont.getName();
            if (name == null || name.equalsIgnoreCase("null")) {
                name = templateFont != null ? templateFont.getFontData()[0].getName() : "Dialog";
            }
            int style = 0;
            if (scoutFont.isBold()) {
                style |= 1;
            }
            if (scoutFont.isItalic()) {
                style |= 2;
            }
            if ((size = scoutFont.getSize()) <= 0) {
                size = templateFont != null ? templateFont.getFontData()[0].getHeight() : 11;
            }
            font = new Font((Device)this.m_display, name, size, style);
            this.m_fontCache.put(scoutFont.toPattern(), font);
        }
        return font;
    }

    public void dispose() {
        for (Font f : this.m_fontCache.values()) {
            f.dispose();
        }
        this.m_fontCache.clear();
    }
}

