/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.services.common.icon.IconSpec;
import org.eclipse.scout.rt.client.ui.IIconLocator;
import org.eclipse.scout.rt.shared.AbstractIcons;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class SwtIconLocator {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwtIconLocator.class);
    private final ImageRegistry imageRegistry;
    private final Set<String> m_missingImages = new HashSet<String>();
    private final IIconLocator m_iconLocator;

    public SwtIconLocator(IIconLocator iconLocator) {
        this.m_iconLocator = iconLocator;
        this.imageRegistry = new ImageRegistry();
        this.imageRegistry.put("close_a_16", this.getFalse());
    }

    public ImageDescriptor getImageDescriptor(String name) {
        if (name == null) {
            return null;
        }
        if (this.m_missingImages.contains(name)) {
            return null;
        }
        ImageDescriptor desc = this.imageRegistry.getDescriptor(name);
        if (desc == null) {
            desc = this.createImageDescriptor(name);
            if (desc == null) {
                this.m_missingImages.add(name);
            } else {
                this.imageRegistry.put(name, desc);
            }
        }
        return desc;
    }

    public Image getIcon(String name) {
        if (name == null || AbstractIcons.Null.equals(name)) {
            return null;
        }
        if (this.m_missingImages.contains(name)) {
            return null;
        }
        Image image = this.imageRegistry.get(name);
        if (image == null) {
            ImageDescriptor desc = this.createImageDescriptor(name);
            if (desc != null) {
                this.imageRegistry.put(name, desc);
                image = this.imageRegistry.get(name);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("image found '" + name + "'.");
                }
            } else {
                LOG.warn("image '" + name + "' could not be found!");
                this.m_missingImages.add(name);
            }
        }
        return image;
    }

    protected ImageDescriptor createImageDescriptor(String name) {
        ImageDescriptor desc = null;
        IconSpec spec = this.m_iconLocator.getIconSpec(name);
        if (spec != null) {
            desc = ImageDescriptor.createFromImageData((ImageData)new ImageData((InputStream)new ByteArrayInputStream(spec.getContent())));
            if (LOG.isDebugEnabled()) {
                LOG.debug("image found '" + name + "'.");
            }
        } else {
            LOG.warn("image '" + name + "' could not be found!");
            this.m_missingImages.add(name);
        }
        return desc;
    }

    public void dispose() {
        this.imageRegistry.dispose();
    }

    private Image getFalse() {
        Display display = PlatformUI.getWorkbench().getDisplay();
        Image img = new Image((Device)display, 16, 16);
        GC gc = null;
        try {
            gc = new GC((Drawable)img);
            gc.setBackground(display.getSystemColor(2));
            gc.drawRectangle(2, 2, 12, 12);
        }
        finally {
            if (gc != null) {
                gc.dispose();
            }
        }
        return img;
    }
}

