/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.ui.swt.LayoutValidateManager;
import org.eclipse.scout.rt.ui.swt.LogicalGridLayout;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scrollable;

public final class SwtLayoutUtility {
    private static IScoutLogger LOG = ScoutLogManager.getLogger(SwtLayoutUtility.class);
    private static LayoutValidateManager layoutValidateManager = new LayoutValidateManager();
    private static boolean dumpSizeTreeRunning;

    private SwtLayoutUtility() {
    }

    public static void invalidateLayout(Control c) {
        layoutValidateManager.invalidate(c);
    }

    public static Point computeSizeEx(Control control, int wHint, int hHint, boolean flushCache) {
        Point size = null;
        if (wHint == -1 && hHint == -1) {
            size = control.computeSize(wHint, hHint, flushCache);
        } else {
            int trimH;
            int trimW;
            if (control instanceof Scrollable) {
                Rectangle rect = ((Scrollable)control).computeTrim(0, 0, 0, 0);
                trimW = rect.width;
                trimH = rect.height;
            } else {
                trimW = trimH = control.getBorderWidth() * 2;
            }
            int wHintFixed = wHint == -1 ? wHint : Math.max(0, wHint - trimW);
            int hHintFixed = hHint == -1 ? hHint : Math.max(0, hHint - trimH);
            size = control.computeSize(wHintFixed, hHintFixed, flushCache);
        }
        return size;
    }

    public static void dumpSizeTree(Control c) {
        if (!dumpSizeTreeRunning) {
            try {
                dumpSizeTreeRunning = true;
                SwtLayoutUtility.dumpSizeTreeRec(c, "");
            }
            finally {
                dumpSizeTreeRunning = false;
            }
        }
    }

    private static void dumpSizeTreeRec(Control c, String prefix) {
        Layout layout;
        Layout lm;
        Point d = c.computeSize(-1, -1, false);
        String lay = "null";
        if (c instanceof Composite && (lm = ((Composite)c).getLayout()) != null) {
            lay = lm.getClass().getSimpleName();
        }
        Rectangle r = c.getBounds();
        StringBuffer buf = new StringBuffer();
        buf.append("[" + r.x + "," + r.y + "," + r.width + "," + r.height + "]");
        buf.append(" pref=(" + d.x + "," + d.y + ")");
        buf.append(" " + c.getClass().getSimpleName());
        buf.append(" layout=" + lay);
        buf.append(c.getVisible() ? " VISIBLE" : " INVISIBLE");
        Object gd = c.getLayoutData();
        if (gd != null) {
            buf.append(" logicalGridData=" + gd);
        }
        if (c instanceof Composite && (layout = ((Composite)c).getLayout()) instanceof LogicalGridLayout) {
            StringWriter w = new StringWriter();
            ((LogicalGridLayout)layout).dumpLayoutInfo((Composite)c, new PrintWriter((Writer)w, true));
            buf.append("\n  " + w.toString().replace("\n", "\n  "));
        }
        String msg = String.valueOf(prefix) + buf.toString().replace("\n", "\n" + prefix);
        System.out.println(msg);
        if (c instanceof Composite) {
            Control[] controlArray = ((Composite)c).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                SwtLayoutUtility.dumpSizeTreeRec(child, String.valueOf(prefix) + "  ");
                ++n2;
            }
        }
    }
}

