/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.window.desktop.menu;

import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.tree.IActionNode;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;

public final class DesktopUtility {
    private DesktopUtility() {
    }

    public static IAction findDesktopMenu(String qName, ISwtEnvironment environment) {
        IClientSession clientSession = environment.getClientSession();
        if (clientSession != null && clientSession.getDesktop() != null) {
            IMenu[] iMenuArray = clientSession.getDesktop().getMenus();
            int n = iMenuArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMenu menu = iMenuArray[n2];
                IAction found = DesktopUtility.findActionImplRec(qName, (IAction)menu);
                if (found != null) {
                    return found;
                }
                ++n2;
            }
        }
        return null;
    }

    private static IAction findActionImplRec(String qName, IAction action) {
        if (action.getClass().getName().equals(qName)) {
            return action;
        }
        if (action instanceof IActionNode) {
            IActionNode actionNode = (IActionNode)action;
            for (IAction subMenu : actionNode.getChildActions()) {
                IAction found = DesktopUtility.findActionImplRec(qName, subMenu);
                if (found == null) continue;
                return found;
            }
        }
        return null;
    }

    public static IAction findToolAction(String qName, ISwtEnvironment environment) {
        IClientSession clientSession = environment.getClientSession();
        if (clientSession != null && clientSession.getDesktop() != null) {
            IAction[] iActionArray = clientSession.getDesktop().getActions();
            int n = iActionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAction a = iActionArray[n2];
                IAction found = DesktopUtility.findActionImplRec(qName, a);
                if (found != null) {
                    return found;
                }
                ++n2;
            }
        }
        return null;
    }
}

