/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.window.desktop.tray;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.ui.swt.SwtMenuUtility;
import org.eclipse.scout.rt.ui.swt.basic.SwtScoutComposite;
import org.eclipse.scout.rt.ui.swt.window.desktop.tray.ISwtScoutTray;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;

public class SwtScoutTray
extends SwtScoutComposite<IDesktop>
implements ISwtScoutTray {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwtScoutTray.class);
    private TrayItem m_trayIcon;
    private Menu m_popupMenu;

    @Override
    protected void initializeSwt(Composite parent) {
        super.initializeSwt(parent);
        Tray tray = this.getEnvironment().getDisplay().getSystemTray();
        if (tray != null) {
            this.m_trayIcon = new TrayItem(tray, 0);
            this.m_trayIcon.setImage(this.getEnvironment().getIcon("window"));
            this.m_trayIcon.addMenuDetectListener(new MenuDetectListener(){

                public void menuDetected(MenuDetectEvent e) {
                    if (SwtScoutTray.this.m_popupMenu != null) {
                        SwtScoutTray.this.m_popupMenu.setVisible(true);
                    }
                }
            });
            Shell shell = new Shell(this.getEnvironment().getDisplay());
            this.m_popupMenu = new Menu((Decorations)shell, 8);
            this.updatePopupMenus();
        }
    }

    protected void updatePopupMenus() {
        if (this.m_popupMenu == null) {
            return;
        }
        MenuItem[] menuItemArray = this.m_popupMenu.getItems();
        int n = menuItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem mi = menuItemArray[n2];
            if (!mi.isDisposed()) {
                mi.dispose();
            }
            ++n2;
        }
        if (this.getScoutObject() != null) {
            final AtomicReference scoutMenusRef = new AtomicReference();
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    scoutMenusRef.set(((IDesktop)SwtScoutTray.this.getScoutObject()).getUIFacade().fireTrayPopupFromUI());
                }
            };
            try {
                this.getEnvironment().invokeScoutLater(t, 5678L).join(5678L);
            }
            catch (InterruptedException interruptedException) {}
            if (scoutMenusRef.get() != null && ((IMenu[])scoutMenusRef.get()).length > 0) {
                SwtMenuUtility.fillContextMenu((IMenu[])scoutMenusRef.get(), this.m_popupMenu, this.getEnvironment());
            }
        }
    }

    @Override
    public TrayItem getSwtTrayItem() {
        return this.m_trayIcon;
    }
}

