/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.window.dialog;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.IProcessingStatus;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.button.IButton;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.scout.rt.ui.swt.form.ISwtScoutForm;
import org.eclipse.scout.rt.ui.swt.window.ISwtScoutPart;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.Form;

public class SwtScoutDialog
extends Dialog
implements ISwtScoutPart {
    private static IScoutLogger LOG = ScoutLogManager.getLogger(SwtScoutDialog.class);
    private final ISwtEnvironment m_environment;
    private Composite m_contentPane;
    private Form m_rootForm;
    private IForm m_scoutForm;
    private Point m_initialLocation;
    private boolean m_opened;
    private PropertyChangeListener m_formPropertyListener;
    private ISwtScoutForm m_uiForm;

    public SwtScoutDialog(Shell parentShell, ISwtEnvironment environment) {
        this(parentShell, environment, 68720);
    }

    public SwtScoutDialog(Shell parentShell, ISwtEnvironment environment, int style) {
        super((Shell)((style & 0x10000) != 0 ? parentShell : null));
        this.m_environment = environment;
        this.m_formPropertyListener = new P_ScoutPropertyChangeListener();
        this.setShellStyle(style);
    }

    public void showForm(IForm scoutForm) throws ProcessingException {
        this.m_opened = true;
        if (this.m_scoutForm == null) {
            this.create();
            this.m_scoutForm = scoutForm;
            try {
                this.m_contentPane.setRedraw(false);
                this.m_uiForm = this.m_environment.createForm(this.m_contentPane, scoutForm);
                GridData d = new GridData(1808);
                this.m_uiForm.getSwtContainer().setLayoutData((Object)d);
                this.attachScout(scoutForm);
            }
            finally {
                this.m_contentPane.setRedraw(true);
            }
        } else {
            throw new ProcessingException("The form dialog is already open. The form '" + scoutForm.getTitle() + " (" + scoutForm.getClass().getName() + ")' can not be opened!");
        }
        this.open();
    }

    @Override
    public void closePart() throws ProcessingException {
        if (this.m_scoutForm != null) {
            this.detachScout(this.m_scoutForm);
        }
        super.close();
    }

    @Override
    public IForm getForm() {
        return this.m_scoutForm;
    }

    @Override
    public ISwtScoutForm getUiForm() {
        return this.m_uiForm;
    }

    public Form getRootForm() {
        return this.m_rootForm;
    }

    protected void attachScout(IForm form) {
        this.setTitleFromScout(form.getTitle());
        this.setImageFromScout(form.getIconId());
        this.setMaximizeEnabledFromScout(form.isMaximizeEnabled());
        this.setMaximizedFromScout(form.isMaximized());
        this.setMinimizeEnabledFromScout(form.isMinimizeEnabled());
        this.setMinimizedFromScout(form.isMinimized());
        boolean closable = false;
        IFormField[] iFormFieldArray = form.getAllFields();
        int n = iFormFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFormField f = iFormFieldArray[n2];
            if (f.isEnabled() && f.isVisible() && f instanceof IButton) {
                switch (((IButton)f).getSystemType()) {
                    case 1: 
                    case 2: {
                        closable = true;
                    }
                }
            }
            if (closable) break;
            ++n2;
        }
        this.setCloseEnabledFromScout(closable);
        form.addPropertyChangeListener(this.m_formPropertyListener);
    }

    protected void detachScout(IForm form) {
        form.removePropertyChangeListener(this.m_formPropertyListener);
    }

    protected void setImageFromScout(String iconId) {
        this.getShell().setImage(this.m_environment.getIcon(iconId));
    }

    protected void setTitleFromScout(String title) {
        if (title == null) {
            title = "";
        }
        title = StringUtility.removeNewLines((String)title);
        this.getShell().setText(title);
    }

    protected void setMaximizeEnabledFromScout(boolean maximizable) {
    }

    protected void setMaximizedFromScout(boolean maximized) {
    }

    protected void setMinimizeEnabledFromScout(boolean minized) {
    }

    protected void setMinimizedFromScout(boolean minimized) {
    }

    protected void setCloseEnabledFromScout(boolean closebale) {
    }

    public void setStatusFromScout(IProcessingStatus newValue) {
    }

    protected final Control createButtonBar(Composite parent) {
        return null;
    }

    public void setMinSize(Point size) {
        if (size != null) {
            this.getShell().setSize(size);
            this.getShell().setMinimumSize(size);
        }
    }

    public Point getInitialLocation(Point initialSize) {
        if (this.m_initialLocation != null) {
            return this.m_initialLocation;
        }
        return super.getInitialLocation(initialSize);
    }

    public void setInitialLocation(Point initialLocation) {
        this.m_initialLocation = initialLocation;
    }

    public int open() {
        if ((this.getShellStyle() & 0x10000) == 0) {
            this.setBlockOnOpen(false);
        }
        this.initializeBounds();
        if (this.m_opened) {
            return super.open();
        }
        return 1;
    }

    public boolean close() {
        this.m_opened = false;
        Control focusControl = this.getShell().getDisplay().getFocusControl();
        if (focusControl != null && !focusControl.isDisposed()) {
            focusControl.traverse(16);
        }
        Runnable job = new Runnable(){

            @Override
            public void run() {
                SwtScoutDialog.this.m_scoutForm.getUIFacade().fireFormClosingFromUI();
            }
        };
        this.m_environment.invokeScoutLater(job, 0L);
        return false;
    }

    protected Control createContents(Composite parent) {
        this.m_rootForm = this.getEnvironment().getFormToolkit().createForm(parent);
        this.m_contentPane = this.m_rootForm.getBody();
        GridLayout gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginHeight = 2;
        gridLayout.marginWidth = 2;
        gridLayout.verticalSpacing = 0;
        this.m_contentPane.setLayout((Layout)gridLayout);
        GridData d = new GridData(1808);
        this.m_rootForm.setLayoutData((Object)d);
        return this.m_rootForm;
    }

    public ISwtEnvironment getEnvironment() {
        return this.m_environment;
    }

    @Override
    public void activate() {
        super.getShell().setActive();
    }

    @Override
    public boolean isActive() {
        return this.getShell() == this.getEnvironment().getDisplay().getActiveShell();
    }

    @Override
    public boolean isVisible() {
        return this.getShell().isVisible();
    }

    @Override
    public void setStatusLineMessage(Image image, String message) {
    }

    protected void handleScoutPropertyChange(String name, Object newValue) {
        if (name.equals("title")) {
            this.setTitleFromScout((String)newValue);
        } else if (name.equals("iconId")) {
            this.setImageFromScout((String)newValue);
        } else if (name.equals("minimizeEnabled")) {
            this.setMinimizeEnabledFromScout((Boolean)newValue);
        } else if (name.equals("maximizeEnabled")) {
            this.setMaximizeEnabledFromScout((Boolean)newValue);
        } else if (name.equals("minimized")) {
            this.setMinimizedFromScout((Boolean)newValue);
        } else if (name.equals("maximized")) {
            this.setMaximizedFromScout((Boolean)newValue);
        }
    }

    private class P_ScoutPropertyChangeListener
    implements PropertyChangeListener {
        private P_ScoutPropertyChangeListener() {
        }

        @Override
        public void propertyChange(final PropertyChangeEvent e) {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    SwtScoutDialog.this.handleScoutPropertyChange(e.getPropertyName(), e.getNewValue());
                }
            };
            SwtScoutDialog.this.m_environment.invokeSwtLater(t);
        }
    }
}

