/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.window.messagebox;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.scout.rt.client.ui.messagebox.IMessageBox;
import org.eclipse.scout.rt.client.ui.messagebox.MessageBoxEvent;
import org.eclipse.scout.rt.client.ui.messagebox.MessageBoxListener;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.scout.rt.ui.swt.extension.UiDecorationExtensionPoint;
import org.eclipse.scout.rt.ui.swt.form.fields.groupbox.layout.ButtonBarLayout;
import org.eclipse.scout.rt.ui.swt.form.fields.groupbox.layout.ButtonBarLayoutData;
import org.eclipse.scout.rt.ui.swt.util.SwtUtility;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SwtScoutMessageBoxDialog
extends Dialog {
    private P_ScoutMessageBoxListener m_scoutMessageBoxListener;
    private final ISwtEnvironment m_environment;
    private final IMessageBox m_scoutObject;
    private Label m_imageLabel;
    private Label m_introLabel;
    private StyledText m_actionText;

    public SwtScoutMessageBoxDialog(Shell parentShell, IMessageBox scoutObject, ISwtEnvironment environment) {
        super(parentShell);
        this.m_scoutObject = scoutObject;
        this.m_environment = environment;
        int dialogStyle = 67680;
        this.setShellStyle(dialogStyle);
        this.setBlockOnOpen(false);
    }

    public void create() {
        super.create();
        this.attachScout();
    }

    void attachScout() {
        if (this.m_scoutMessageBoxListener == null) {
            this.m_scoutMessageBoxListener = new P_ScoutMessageBoxListener();
            this.getScoutObject().addMessageBoxListener((MessageBoxListener)this.m_scoutMessageBoxListener);
        }
        this.setTitleTextFromScout(this.getScoutObject().getTitle());
        this.setIntoTextFromScout(this.getScoutObject().getIntroText());
        this.setActionTextFromScout(this.getScoutObject().getActionText());
        this.setImageFromScout(this.getScoutObject().getIconId());
        this.setSeverityFromScout(this.getScoutObject().getSeverity());
    }

    protected void setImageFromScout(String iconId) {
        Image icon = this.getEnvironment().getIcon(iconId);
        this.setImageInternal(icon);
    }

    private void setImageInternal(Image img) {
        boolean exclude = false;
        if (img == null) {
            exclude = true;
        }
        this.m_imageLabel.setImage(img);
        if (this.m_imageLabel.getLayoutData() instanceof GridData && ((GridData)this.m_imageLabel.getLayoutData()).exclude != exclude) {
            GridData gridData = (GridData)this.m_imageLabel.getLayoutData();
            if (gridData.exclude != exclude) {
                gridData.exclude = exclude;
                this.m_imageLabel.getParent().getParent().layout(true, true);
            }
        }
    }

    protected void setSeverityFromScout(int severity) {
        if (this.getScoutObject().getIconId() == null) {
            Image icon = null;
            switch (severity) {
                case 4: {
                    icon = this.getShell().getDisplay().getSystemImage(1);
                    break;
                }
                case 2: {
                    icon = this.getShell().getDisplay().getSystemImage(8);
                    break;
                }
                case 1: {
                    icon = this.getShell().getDisplay().getSystemImage(2);
                    break;
                }
            }
            this.setImageInternal(icon);
        }
    }

    protected void setTitleTextFromScout(String titleText) {
        if (titleText == null) {
            titleText = "";
        }
        this.getShell().setText(titleText);
    }

    protected void setIntoTextFromScout(String introText) {
        boolean exclude = false;
        if (introText == null) {
            introText = "";
            exclude = true;
        }
        this.m_introLabel.setText(introText);
        if (this.m_introLabel.getLayoutData() instanceof GridData) {
            GridData gridData = (GridData)this.m_introLabel.getLayoutData();
            if (gridData.exclude != exclude) {
                gridData.exclude = exclude;
                this.m_introLabel.getParent().getParent().layout(true, true);
            }
        }
    }

    protected void setActionTextFromScout(String actionText) {
        if (this.getScoutObject().getIntroText() == null) {
            this.setIntoTextFromScout(actionText);
            actionText = null;
        }
        boolean exclude = false;
        if (actionText == null) {
            actionText = "";
            exclude = true;
        }
        this.m_actionText.setText(actionText);
        if (this.m_actionText.getLayoutData() instanceof GridData) {
            GridData gridData = (GridData)this.m_actionText.getLayoutData();
            if (gridData.exclude != exclude) {
                gridData.exclude = exclude;
                this.getShell().layout(true, true);
                this.m_actionText.getParent().getParent().layout(true, true);
            }
        }
    }

    protected void dettachScout() {
        if (this.m_scoutMessageBoxListener == null) {
            this.m_scoutMessageBoxListener = new P_ScoutMessageBoxListener();
            this.getScoutObject().addMessageBoxListener((MessageBoxListener)this.m_scoutMessageBoxListener);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = this.getEnvironment().getFormToolkit().createComposite(parent);
        Control header = this.createHeaderArea(container);
        this.m_actionText = this.getEnvironment().getFormToolkit().createStyledText(container, 520);
        this.m_actionText.setWordWrap(true);
        container.setLayoutData((Object)new GridData(1808));
        GridLayout dialogAreaLayout = new GridLayout(1, true);
        dialogAreaLayout.marginHeight = 12;
        dialogAreaLayout.marginWidth = 12;
        container.setLayout((Layout)dialogAreaLayout);
        GridData gridData = new GridData(512);
        header.setLayoutData((Object)gridData);
        gridData = new GridData(1808);
        gridData.horizontalIndent = 5;
        this.m_actionText.setLayoutData((Object)gridData);
        container.setTabList(new Control[0]);
        return container;
    }

    private Control createHeaderArea(Composite parent) {
        Composite container = this.getEnvironment().getFormToolkit().createComposite(parent);
        this.m_imageLabel = this.getEnvironment().getFormToolkit().createLabel(container, "");
        this.m_introLabel = this.getEnvironment().getFormToolkit().createLabel(container, "", 16448);
        GridLayout headerLayout = new GridLayout(2, false);
        headerLayout.marginBottom = 7;
        headerLayout.marginWidth = 0;
        headerLayout.horizontalSpacing = 5;
        container.setLayout((Layout)headerLayout);
        GridData gridData = new GridData(2);
        gridData.exclude = true;
        this.m_imageLabel.setLayoutData((Object)gridData);
        gridData = new GridData(1840);
        gridData.horizontalIndent = 7;
        gridData.verticalIndent = 0;
        gridData.exclude = true;
        this.m_introLabel.setLayoutData((Object)gridData);
        return container;
    }

    protected Control createButtonBar(Composite parent) {
        ButtonBarLayoutData data;
        Composite buttonArea = this.getEnvironment().getFormToolkit().createComposite(parent);
        int inset = 10;
        buttonArea.setBackground(this.getEnvironment().getDisplay().getSystemColor(22));
        if (this.getScoutObject().getYesButtonText() != null) {
            Button yesButton = this.createButton(buttonArea, this.getScoutObject().getYesButtonText(), null, 0);
            data = new ButtonBarLayoutData();
            data.insetTop = inset;
            data.insetBottom = inset;
            data.insetRight = inset;
            yesButton.setLayoutData((Object)data);
        }
        if (this.getScoutObject().getNoButtonText() != null) {
            Button noButton = this.createButton(buttonArea, this.getScoutObject().getNoButtonText(), null, 1);
            data = new ButtonBarLayoutData();
            data.insetTop = inset;
            data.insetBottom = inset;
            data.insetRight = inset;
            noButton.setLayoutData((Object)data);
        }
        if (this.getScoutObject().getCancelButtonText() != null) {
            Button cancelButton = this.createButton(buttonArea, this.getScoutObject().getCancelButtonText(), null, 2);
            data = new ButtonBarLayoutData();
            data.insetTop = inset;
            data.insetBottom = inset;
            data.insetRight = inset;
            cancelButton.setLayoutData((Object)data);
        }
        if (this.getScoutObject().getHiddenText() != null) {
            Button copyButton = this.createButton(buttonArea, SwtUtility.getNlsText(Display.getCurrent(), "Copy", new String[0]), null, -1);
            copyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Clipboard clipboard = null;
                    try {
                        clipboard = new Clipboard(SwtScoutMessageBoxDialog.this.getEnvironment().getDisplay());
                        String hiddenText = SwtScoutMessageBoxDialog.this.getScoutObject().getHiddenText();
                        if (hiddenText != null) {
                            clipboard.setContents(new Object[]{hiddenText}, new Transfer[]{TextTransfer.getInstance()});
                        }
                    }
                    finally {
                        if (clipboard != null) {
                            clipboard.dispose();
                            clipboard = null;
                        }
                    }
                }
            });
            data = new ButtonBarLayoutData();
            data.insetTop = inset;
            data.insetBottom = inset;
            data.insetRight = inset;
            copyButton.setLayoutData((Object)data);
        }
        GridData gridData = new GridData(768);
        buttonArea.setLayoutData((Object)gridData);
        ButtonBarLayout layout = new ButtonBarLayout(131072);
        layout.horizontalGap = 0;
        buttonArea.setLayout((Layout)layout);
        return buttonArea;
    }

    protected Button createButton(Composite parent, String text, String iconId, int buttonId) {
        Button b = this.getEnvironment().getFormToolkit().createButton(parent, text, 8);
        if (iconId != null) {
            b.setImage(this.getEnvironment().getIcon(iconId));
        }
        if (buttonId >= 0) {
            b.addSelectionListener((SelectionListener)new P_SwtButtonListener(buttonId));
        }
        return b;
    }

    protected Point getInitialSize() {
        Point buttonBarSize = this.getButtonBar().computeSize(-1, -1, true);
        Point initialSize = this.getShell().computeSize(UiDecorationExtensionPoint.getLookAndFeel().getMessageBoxMinWidth(), -1, true);
        initialSize.x = Math.max(buttonBarSize.x + 20, UiDecorationExtensionPoint.getLookAndFeel().getMessageBoxMinWidth());
        initialSize.y = Math.max(initialSize.y, UiDecorationExtensionPoint.getLookAndFeel().getMessageBoxMinHeight());
        return initialSize;
    }

    public int open() {
        if (this.getShell() == null || this.getShell().isDisposed()) {
            this.create();
        }
        this.initializeBounds();
        return super.open();
    }

    public boolean close() {
        this.handleSwtButtonSelection(2);
        return false;
    }

    public void closeNoFire() {
        super.close();
    }

    public ISwtEnvironment getEnvironment() {
        return this.m_environment;
    }

    public IMessageBox getScoutObject() {
        return this.m_scoutObject;
    }

    protected void handleScoutMessageBoxClosed(MessageBoxEvent e) {
        this.dettachScout();
        this.closeNoFire();
    }

    private void handleSwtButtonSelection(final int buttonId) {
        Runnable j = new Runnable(){

            @Override
            public void run() {
                SwtScoutMessageBoxDialog.this.getScoutObject().getUIFacade().setResultFromUI(buttonId);
            }
        };
        this.getEnvironment().invokeScoutLater(j, 0L);
    }

    private class P_ScoutMessageBoxListener
    implements MessageBoxListener {
        private P_ScoutMessageBoxListener() {
        }

        public void messageBoxChanged(final MessageBoxEvent e) {
            switch (e.getType()) {
                case 900: {
                    Runnable t = new Runnable(){

                        @Override
                        public void run() {
                            switch (e.getType()) {
                                case 900: {
                                    SwtScoutMessageBoxDialog.this.handleScoutMessageBoxClosed(e);
                                }
                            }
                        }
                    };
                    SwtScoutMessageBoxDialog.this.getEnvironment().invokeSwtLater(t);
                }
            }
        }
    }

    private class P_SwtButtonListener
    extends SelectionAdapter {
        private final int m_buttonId;

        P_SwtButtonListener(int buttonId) {
            this.m_buttonId = buttonId;
        }

        public void widgetSelected(SelectionEvent e) {
            SwtScoutMessageBoxDialog.this.handleSwtButtonSelection(this.m_buttonId);
        }
    }
}

