/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.window.popup;

import java.util.EventListener;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.scout.rt.ui.swt.extension.UiDecorationExtensionPoint;
import org.eclipse.scout.rt.ui.swt.form.ISwtScoutForm;
import org.eclipse.scout.rt.ui.swt.util.SwtUtility;
import org.eclipse.scout.rt.ui.swt.window.ISwtScoutPart;
import org.eclipse.scout.rt.ui.swt.window.SwtScoutPartEvent;
import org.eclipse.scout.rt.ui.swt.window.SwtScoutPartListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SwtScoutPopup
implements ISwtScoutPart {
    private static IScoutLogger LOG = ScoutLogManager.getLogger(SwtScoutPopup.class);
    private ISwtEnvironment m_env;
    private Control m_ownerComponent;
    private Rectangle m_ownerBounds;
    private Shell m_swtWindow;
    private Composite m_swtWindowContentPane;
    private EventListenerList m_listenerList;
    private IForm m_scoutForm;
    private boolean m_positionBelowReferenceField;
    private boolean m_opened;
    private ISwtScoutForm m_uiForm;

    public SwtScoutPopup(ISwtEnvironment env, Control ownerComponent, Rectangle ownerBounds) {
        this.m_env = env;
        this.m_positionBelowReferenceField = true;
        this.m_ownerComponent = ownerComponent;
        this.m_ownerBounds = ownerBounds;
        this.m_listenerList = new EventListenerList();
        this.m_swtWindow = new Shell(ownerComponent.getShell(), 16);
        this.m_swtWindow.setData("extendedStyle", (Object)8);
        this.m_swtWindow.setLayout((Layout)new FillLayout());
        this.m_swtWindow.addDisposeListener((DisposeListener)new P_SwtWindowDisposeListener());
        this.m_swtWindowContentPane = env.getFormToolkit().createComposite((Composite)this.m_swtWindow, 0);
        this.m_swtWindowContentPane.setLayout((Layout)new FillLayout());
    }

    public Shell getShell() {
        return this.m_swtWindow;
    }

    public void showForm(IForm scoutForm) throws ProcessingException {
        this.m_opened = true;
        if (this.m_scoutForm == null) {
            this.m_scoutForm = scoutForm;
            this.m_uiForm = this.m_env.createForm(this.getSwtContentPane(), scoutForm);
            this.autoAdjustBounds();
            if (this.m_opened) {
                this.m_swtWindow.open();
                this.autoAdjustBounds();
                if (this.m_opened) {
                    this.handleSwtWindowOpened();
                }
            }
        } else {
            throw new ProcessingException("The popup is already open. The form '" + scoutForm.getTitle() + " (" + scoutForm.getClass().getName() + ")' can not be opened!");
        }
    }

    @Override
    public void closePart() {
        this.m_opened = false;
        try {
            if (!this.m_swtWindow.isDisposed()) {
                this.m_swtWindow.setVisible(false);
                this.m_swtWindow.dispose();
            }
        }
        catch (Throwable e1) {
            LOG.error("Failed closing popup for " + this.m_scoutForm, e1);
        }
    }

    @Override
    public IForm getForm() {
        return this.m_scoutForm;
    }

    @Override
    public ISwtScoutForm getUiForm() {
        return this.m_uiForm;
    }

    public void autoAdjustBounds() {
        if (!this.getShell().isDisposed()) {
            Rectangle newView;
            Rectangle alternateView;
            this.getShell().layout(true, true);
            Point d = this.getShell().computeSize(-1, -1, true);
            d.x = Math.max(d.x, UiDecorationExtensionPoint.getLookAndFeel().getLogicalGridLayoutDefaultColumnWidth());
            d.y = Math.max(UiDecorationExtensionPoint.getLookAndFeel().getLogicalGridLayoutRowHeight(), d.y);
            Point p = new Point(this.m_ownerBounds.x, this.m_ownerBounds.y);
            Point above = new Point(p.x, p.y);
            Rectangle aboveView = SwtUtility.intersectRectangleWithScreen(this.getShell().getDisplay(), new Rectangle(above.x, above.y - d.y, d.x, d.y), false, false);
            Point below = new Point(p.x, p.y + this.m_ownerBounds.height);
            Rectangle belowView = SwtUtility.intersectRectangleWithScreen(this.getShell().getDisplay(), new Rectangle(below.x, below.y, d.x, d.y), false, false);
            Rectangle currentView = this.m_positionBelowReferenceField ? belowView : aboveView;
            Rectangle rectangle = alternateView = this.m_positionBelowReferenceField ? aboveView : belowView;
            if (currentView.height >= alternateView.height) {
                newView = currentView;
            } else {
                newView = alternateView;
                boolean bl = this.m_positionBelowReferenceField = !this.m_positionBelowReferenceField;
            }
            if (!newView.equals((Object)this.getShell().getBounds())) {
                this.getShell().setBounds(newView);
                this.getShell().layout(true, true);
            }
        }
    }

    public Composite getSwtContentPane() {
        return this.m_swtWindowContentPane;
    }

    public void addSwtScoutPartListener(SwtScoutPartListener listener) {
        this.m_listenerList.add(SwtScoutPartListener.class, (EventListener)listener);
    }

    public void removeSwtScoutPartListener(SwtScoutPartListener listener) {
        this.m_listenerList.remove(SwtScoutPartListener.class, (EventListener)listener);
    }

    private void fireSwtScoutPartEvent(SwtScoutPartEvent e) {
        EventListener[] listeners;
        if (this.m_swtWindow != null && (listeners = this.m_listenerList.getListeners(SwtScoutPartListener.class)) != null && listeners.length > 0) {
            EventListener[] eventListenerArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                EventListener listener = eventListenerArray[n2];
                try {
                    ((SwtScoutPartListener)listener).partChanged(e);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                ++n2;
            }
        }
    }

    @Override
    public boolean isVisible() {
        return this.m_swtWindow != null && this.m_swtWindow.getVisible();
    }

    @Override
    public void activate() {
        this.m_swtWindow.getShell().setActive();
    }

    @Override
    public boolean isActive() {
        return this.m_swtWindow != null && this.m_swtWindow.getDisplay().getActiveShell() == this.m_swtWindow;
    }

    @Override
    public void setStatusLineMessage(Image image, String message) {
    }

    private void handleSwtWindowOpened() {
        this.fireSwtScoutPartEvent(new SwtScoutPartEvent(this, 10));
        this.fireSwtScoutPartEvent(new SwtScoutPartEvent(this, 20));
    }

    private void handleSwtWindowClosed() {
        this.fireSwtScoutPartEvent(new SwtScoutPartEvent(this, 40));
        Runnable job = new Runnable(){

            @Override
            public void run() {
                SwtScoutPopup.this.m_scoutForm.getUIFacade().fireFormKilledFromUI();
            }
        };
        this.m_env.invokeScoutLater(job, 0L);
    }

    private class P_SwtWindowDisposeListener
    implements DisposeListener {
        private P_SwtWindowDisposeListener() {
        }

        public void widgetDisposed(DisposeEvent e) {
            SwtScoutPopup.this.handleSwtWindowClosed();
        }
    }
}

