/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.window.popup;

import java.util.EventListener;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.ui.swt.DefaultValidateRoot;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.scout.rt.ui.swt.extension.UiDecorationExtensionPoint;
import org.eclipse.scout.rt.ui.swt.form.ISwtScoutForm;
import org.eclipse.scout.rt.ui.swt.util.SwtUtility;
import org.eclipse.scout.rt.ui.swt.window.ISwtScoutPart;
import org.eclipse.scout.rt.ui.swt.window.SwtScoutPartEvent;
import org.eclipse.scout.rt.ui.swt.window.SwtScoutPartListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;

public class SwtScoutSmartFieldPopup
implements ISwtScoutPart {
    private static IScoutLogger LOG = ScoutLogManager.getLogger(SwtScoutSmartFieldPopup.class);
    private ISwtEnvironment m_env;
    private EventListenerList m_listenerList;
    private Composite m_ownerComponent;
    private Composite m_focusComponent;
    private FocusListener m_focusComponentListener;
    private Shell m_swtWindow;
    private Composite m_swtWindowContentPane;
    private boolean m_nonFocusable;
    private P_ScrollBarListener m_scrollbarListener;
    private IForm m_scoutForm;
    private boolean m_positionBelowReferenceField;
    private boolean m_opened;
    private ISwtScoutForm m_uiForm;

    public SwtScoutSmartFieldPopup(ISwtEnvironment env, Composite ownerComponent, Composite focusComponent) {
        this.m_env = env;
        this.m_ownerComponent = ownerComponent;
        this.m_positionBelowReferenceField = true;
        this.m_focusComponent = focusComponent;
        this.m_listenerList = new EventListenerList();
        this.m_swtWindow = new Shell(ownerComponent.getShell(), 16);
        this.m_swtWindow.setData("extendedStyle", (Object)8);
        this.m_swtWindow.setData("LayoutValidateManager.validateRoot", (Object)new DefaultValidateRoot((Composite)this.m_swtWindow){

            @Override
            public void validate() {
                SwtScoutSmartFieldPopup.this.autoAdjustBounds();
            }
        });
        this.m_swtWindow.setLayout((Layout)new FillLayout());
        this.m_swtWindow.addDisposeListener((DisposeListener)new P_SwtWindowDisposeListener());
        this.m_swtWindowContentPane = env.getFormToolkit().createComposite((Composite)this.m_swtWindow, 0);
        this.m_swtWindowContentPane.setLayout((Layout)new FillLayout());
    }

    public Shell getShell() {
        return this.m_swtWindow;
    }

    public void showForm(IForm scoutForm) throws ProcessingException {
        this.m_opened = true;
        if (this.m_scoutForm == null) {
            this.m_scoutForm = scoutForm;
            this.m_uiForm = this.m_env.createForm(this.getSwtContentPane(), scoutForm);
            this.autoAdjustBounds();
            if (this.m_opened) {
                this.m_swtWindow.setVisible(true);
                this.autoAdjustBounds();
                if (this.m_opened) {
                    this.handleSwtWindowOpened();
                }
            }
        } else {
            throw new ProcessingException("The popup is already open. The form '" + scoutForm.getTitle() + " (" + scoutForm.getClass().getName() + ")' can not be opened!");
        }
    }

    @Override
    public void closePart() throws ProcessingException {
        this.m_opened = false;
        if (!this.m_swtWindow.isDisposed()) {
            this.m_swtWindow.setVisible(false);
            this.m_swtWindow.dispose();
        }
    }

    @Override
    public IForm getForm() {
        return this.m_scoutForm;
    }

    @Override
    public ISwtScoutForm getUiForm() {
        return this.m_uiForm;
    }

    private void reqRemoveScrollbarListener(Listener l, Composite comp) {
        if (comp == null) {
            return;
        }
        if (comp.getData("SCROLLED_FORM") != null) {
            ScrollBar vBar;
            comp.removeListener(11, l);
            comp.removeListener(10, l);
            ScrollBar hBar = comp.getHorizontalBar();
            if (hBar != null) {
                hBar.removeListener(13, l);
            }
            if ((vBar = comp.getVerticalBar()) != null) {
                vBar.removeListener(13, l);
            }
        }
        this.reqRemoveScrollbarListener(l, comp.getParent());
    }

    private void reqAddScrollbarListener(Listener l, Composite comp) {
        if (comp == null) {
            return;
        }
        if (comp.getData("SCROLLED_FORM") != null) {
            ScrollBar vBar;
            comp.addListener(11, l);
            comp.addListener(10, l);
            ScrollBar hBar = comp.getHorizontalBar();
            if (hBar != null) {
                hBar.addListener(13, l);
            }
            if ((vBar = comp.getVerticalBar()) != null) {
                vBar.addListener(13, l);
            }
        }
        this.reqAddScrollbarListener(l, comp.getParent());
    }

    public void makeNonFocusable() {
        this.m_nonFocusable = true;
    }

    public void setBounds(Rectangle bounds) {
        this.getShell().setBounds(bounds);
        this.getShell().layout(true, true);
    }

    public void autoAdjustBounds() {
        if (!this.getShell().isDisposed()) {
            Rectangle alternateView;
            this.getShell().layout(true, true);
            Point d = this.getShell().computeSize(-1, -1, true);
            d.x = Math.max(d.x, UiDecorationExtensionPoint.getLookAndFeel().getLogicalGridLayoutDefaultColumnWidth());
            d.y = Math.min(d.y, 280);
            d.y = Math.max(UiDecorationExtensionPoint.getLookAndFeel().getLogicalGridLayoutRowHeight(), d.y);
            Point p = this.m_ownerComponent.toDisplay(new Point(-this.m_ownerComponent.getBorderWidth(), 0));
            Point above = new Point(p.x, p.y);
            Rectangle aboveView = SwtUtility.intersectRectangleWithScreen(this.getShell().getDisplay(), new Rectangle(above.x, above.y - d.y, d.x, d.y), false, false);
            Point below = new Point(p.x, p.y + this.m_ownerComponent.getBounds().height);
            Rectangle belowView = SwtUtility.intersectRectangleWithScreen(this.getShell().getDisplay(), new Rectangle(below.x, below.y, d.x, d.y), false, false);
            Rectangle currentView = this.m_positionBelowReferenceField ? belowView : aboveView;
            Rectangle rectangle = alternateView = this.m_positionBelowReferenceField ? aboveView : belowView;
            if (currentView.height >= alternateView.height) {
                this.getShell().setBounds(currentView);
            } else {
                this.getShell().setBounds(alternateView);
                this.m_positionBelowReferenceField = !this.m_positionBelowReferenceField;
            }
        }
    }

    public Composite getSwtContentPane() {
        return this.m_swtWindowContentPane;
    }

    public void addSwtScoutPartListener(SwtScoutPartListener listener) {
        this.m_listenerList.add(SwtScoutPartListener.class, (EventListener)listener);
    }

    public void removeSwtScoutPartListener(SwtScoutPartListener listener) {
        this.m_listenerList.remove(SwtScoutPartListener.class, (EventListener)listener);
    }

    private void fireSwtScoutPartEvent(SwtScoutPartEvent e) {
        EventListener[] listeners;
        if (this.m_swtWindow != null && (listeners = this.m_listenerList.getListeners(SwtScoutPartListener.class)) != null && listeners.length > 0) {
            EventListener[] eventListenerArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                EventListener listener = eventListenerArray[n2];
                try {
                    ((SwtScoutPartListener)listener).partChanged(e);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                ++n2;
            }
        }
    }

    @Override
    public boolean isVisible() {
        return this.m_swtWindow != null && this.m_swtWindow.getVisible();
    }

    @Override
    public void activate() {
        this.m_swtWindow.getShell().setActive();
    }

    @Override
    public boolean isActive() {
        return this.m_swtWindow != null && this.m_swtWindow.getDisplay().getActiveShell() == this.m_swtWindow;
    }

    @Override
    public void setStatusLineMessage(Image image, String message) {
    }

    private void handleSwtWindowOpened() {
        if (this.m_ownerComponent != null && !this.m_ownerComponent.isDisposed()) {
            if (this.m_scrollbarListener == null) {
                this.m_scrollbarListener = new P_ScrollBarListener();
            }
            this.reqAddScrollbarListener(this.m_scrollbarListener, this.m_ownerComponent);
            this.m_ownerComponent.getShell().addListener(10, (Listener)this.m_scrollbarListener);
        }
        if (this.m_focusComponent != null && this.m_focusComponentListener == null) {
            this.m_focusComponentListener = new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    SwtScoutSmartFieldPopup.this.m_swtWindow.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!SwtScoutSmartFieldPopup.this.m_swtWindow.isDisposed()) {
                                if (SwtScoutSmartFieldPopup.this.m_swtWindow == SwtScoutSmartFieldPopup.this.m_swtWindow.getDisplay().getActiveShell()) {
                                    Control c = SwtScoutSmartFieldPopup.this.m_swtWindow.getDisplay().getFocusControl();
                                    if (c != null && c != SwtScoutSmartFieldPopup.this.m_swtWindow && c.getShell() == SwtScoutSmartFieldPopup.this.m_swtWindow) {
                                        c.addMouseListener((MouseListener)new MouseAdapter(){

                                            public void mouseUp(MouseEvent event) {
                                                if (!((Control)event.getSource()).isDisposed()) {
                                                    ((Control)event.getSource()).removeMouseListener((MouseListener)this);
                                                }
                                                if (!SwtScoutSmartFieldPopup.this.m_focusComponent.isDisposed()) {
                                                    SwtScoutSmartFieldPopup.this.m_focusComponent.setFocus();
                                                }
                                            }
                                        });
                                    } else {
                                        SwtScoutSmartFieldPopup.this.m_focusComponent.setFocus();
                                    }
                                } else {
                                    try {
                                        SwtScoutSmartFieldPopup.this.closePart();
                                    }
                                    catch (ProcessingException ex) {
                                        LOG.warn("closing part", (Throwable)ex);
                                    }
                                    SwtScoutSmartFieldPopup.this.fireSwtScoutPartEvent(new SwtScoutPartEvent(SwtScoutSmartFieldPopup.this, 40));
                                }
                            }
                        }
                    });
                }
            };
            this.m_focusComponent.addFocusListener(this.m_focusComponentListener);
        }
        this.fireSwtScoutPartEvent(new SwtScoutPartEvent(this, 10));
        this.fireSwtScoutPartEvent(new SwtScoutPartEvent(this, 20));
        if (this.m_nonFocusable) {
            if (this.m_swtWindow.getDisplay().getActiveShell() == this.m_swtWindow) {
                this.m_focusComponent.setFocus();
            }
            if (!this.m_focusComponent.isFocusControl()) {
                try {
                    this.closePart();
                }
                catch (ProcessingException e) {
                    LOG.warn("closing part", (Throwable)e);
                }
                this.fireSwtScoutPartEvent(new SwtScoutPartEvent(this, 40));
            }
        }
    }

    private void handleSwtWindowClosed() {
        if (this.m_ownerComponent != null && !this.m_ownerComponent.isDisposed() && this.m_scrollbarListener != null) {
            this.reqRemoveScrollbarListener(this.m_scrollbarListener, this.m_ownerComponent);
            if (this.m_ownerComponent.getShell() != null && !this.m_ownerComponent.getShell().isDisposed()) {
                this.m_ownerComponent.getShell().removeListener(10, (Listener)this.m_scrollbarListener);
            }
        }
        this.m_scrollbarListener = null;
        if (this.m_focusComponent != null && this.m_focusComponentListener != null) {
            if (!this.m_focusComponent.isDisposed()) {
                this.m_focusComponent.removeFocusListener(this.m_focusComponentListener);
            }
            this.m_focusComponentListener = null;
        }
        this.fireSwtScoutPartEvent(new SwtScoutPartEvent(this, 40));
        Runnable job = new Runnable(){

            @Override
            public void run() {
                SwtScoutSmartFieldPopup.this.m_scoutForm.getUIFacade().fireFormKilledFromUI();
            }
        };
        this.m_env.invokeScoutLater(job, 0L);
    }

    private class P_ScrollBarListener
    implements Listener {
        private P_ScrollBarListener() {
        }

        public void handleEvent(Event event) {
            try {
                SwtScoutSmartFieldPopup.this.closePart();
            }
            catch (ProcessingException e) {
                LOG.warn("could not close popup.", (Throwable)e);
            }
        }
    }

    private class P_SwtWindowDisposeListener
    implements DisposeListener {
        private P_SwtWindowDisposeListener() {
        }

        public void widgetDisposed(DisposeEvent e) {
            SwtScoutSmartFieldPopup.this.handleSwtWindowClosed();
        }
    }
}

