/*******************************************************************************
 * Copyright (c) 2010 BSI Business Systems Integration AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BSI Business Systems Integration AG - initial API and implementation
 ******************************************************************************/
package org.eclipse.scout.sdk;

/**
 * <h3>{@link RuntimeClasses}</h3> ...
 * 
 * @author Andreas Hoegger
 * @since 1.0.8 24.01.2009
 */
public final class RuntimeClasses {
  private RuntimeClasses() {
  }

// CHECKSTYLE:OFF
  public static final String ScoutSharedBundleId = "org.eclipse.scout.rt.shared";
  public static final String ScoutClientBundleId = "org.eclipse.scout.rt.client";
  public static final String ScoutServerBundleId = "org.eclipse.scout.rt.server";
  public static final String ScoutUiSwtBundleId = "org.eclipse.scout.rt.ui.swt";
  public static final String ScoutUiSwingBundleId = "org.eclipse.scout.rt.ui.swing";

  public static final String AbstractActivityMap = "org.eclipse.scout.rt.client.ui.basic.activitymap.AbstractActivityMap";
  public static final String AbstractBigDecimalField = "org.eclipse.scout.rt.client.ui.form.fields.bigdecimalfield.AbstractBigDecimalField";
  public static final String AbstractBookmarkMenu = "org.eclipse.scout.rt.client.ui.desktop.bookmark.menu.AbstractBookmarkMenu";
  public static final String AbstractBookmarkStorageService = "org.eclipse.scout.rt.server.services.common.bookmark.AbstractSqlBookmarkStorageService";
  public static final String AbstractBooleanField = "org.eclipse.scout.rt.client.ui.form.fields.booleanfield.AbstractBooleanField";
  public static final String AbstractButton = "org.eclipse.scout.rt.client.ui.form.fields.button.AbstractButton";
  public static final String AbstractCalendar = "org.eclipse.scout.rt.client.ui.basic.calendar.AbstractCalendar";
  public static final String AbstractCalendarField = "org.eclipse.scout.rt.client.ui.form.fields.calendarfield.AbstractCalendarField";
  public static final String AbstractCalendarItem = "org.eclipse.scout.rt.shared.services.common.calendar.AbstractCalendarItem";
  public static final String AbstractCalendarItemProvider = "org.eclipse.scout.rt.client.ui.basic.calendar.provider.AbstractCalendarItemProvider";
  public static final String AbstractCancelButton = "org.eclipse.scout.rt.client.ui.form.fields.button.AbstractCancelButton";
  public static final String AbstractChartBox = "org.eclipse.scout.rt.client.ui.form.fields.chartbox.AbstractChartBox";
  public static final String AbstractCheckBox = "org.eclipse.scout.rt.client.ui.form.fields.checkbox.AbstractCheckBox";
  public static final String AbstractCheckBoxMenu = "org.eclipse.scout.rt.client.ui.action.menu.checkbox.AbstractCheckBoxMenu";
  public static final String AbstractCloseButton = "org.eclipse.scout.rt.client.ui.form.fields.button.AbstractCloseButton";
  public static final String AbstractCode = "org.eclipse.scout.rt.shared.services.common.code.AbstractCode";
  public static final String AbstractCodeType = "org.eclipse.scout.rt.shared.services.common.code.AbstractCodeType";
  public static final String AbstractColumn = "org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractColumn";
  public static final String AbstractBooleanColumn = "org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractBooleanColumn";
  public static final String AbstractBigDecimalColumn = "org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractBigDecimalColumn";
  public static final String AbstractDateColumn = "org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractDateColumn";
  public static final String AbstractDoubleColumn = "org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractDoubleColumn";
  public static final String AbstractIntegerColumn = "org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractIntegerColumn";
  public static final String AbstractLongColumn = "org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractLongColumn";
  public static final String AbstractObjectColumn = "org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractObjectColumn";
  public static final String AbstractSmartColumn = "org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractSmartColumn";
  public static final String AbstractStringColumn = "org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractStringColumn";
  public static final String AbstractComposerAttribute = "org.eclipse.scout.rt.client.ui.form.fields.composer.attribute.AbstractComposerAttribute";
  public static final String AbstractComposerEntity = "org.eclipse.scout.rt.client.ui.form.fields.composer.entity.AbstractComposerEntity";
  public static final String AbstractComposerField = "org.eclipse.scout.rt.client.ui.form.fields.composer.AbstractComposerField";
  public static final String AbstractComposerData = "org.eclipse.scout.rt.shared.data.form.fields.composer.AbstractComposerData";
  public static final String AbstractComposerEntityData = "org.eclipse.scout.rt.shared.data.form.fields.composer.AbstractComposerEntityData";
  public static final String AbstractComposerAttributeData = "org.eclipse.scout.rt.shared.data.form.fields.composer.AbstractComposerAttributeData";
  public static final String AbstractComposerField_Tree = "org.eclipse.scout.rt.client.ui.form.fields.composer.AbstractComposerField.Tree";
  public static final String AbstractCompositeField = "org.eclipse.scout.rt.client.ui.form.fields.AbstractCompositeField";
  public static final String AbstractCustomField = "org.eclipse.scout.rt.client.ui.form.fields.customfield.AbstractCustomField";
  public static final String AbstractDateField = "org.eclipse.scout.rt.client.ui.form.fields.datefield.AbstractDateField";
  public static final String AbstractDesktop = "org.eclipse.scout.rt.client.ui.desktop.AbstractDesktop";
  public static final String AbstractDoubleField = "org.eclipse.scout.rt.client.ui.form.fields.doublefield.AbstractDoubleField";
  public static final String AbstractFileChooserField = "org.eclipse.scout.rt.client.ui.form.fields.filechooserfield.AbstractFileChooserField";
  public static final String AbstractForm = "org.eclipse.scout.rt.client.ui.form.AbstractForm";
  public static final String AbstractFormData = "org.eclipse.scout.rt.shared.data.form.AbstractFormData";
  public static final String AbstractFormField = "org.eclipse.scout.rt.client.ui.form.fields.AbstractFormField";
  public static final String AbstractFormFieldData = "org.eclipse.scout.rt.shared.data.form.fields.AbstractFormFieldData";
  public static final String AbstractFormHandler = "org.eclipse.scout.rt.client.ui.form.AbstractFormHandler";
  public static final String AbstractGroupBox = "org.eclipse.scout.rt.client.ui.form.fields.groupbox.AbstractGroupBox";
  public static final String AbstractHtmlField = "org.eclipse.scout.rt.client.ui.form.fields.htmlfield.AbstractHtmlField";
  public static final String AbstractIcons = "org.eclipse.scout.rt.shared.AbstractIcons";
  public static final String AbstractImageField = "org.eclipse.scout.rt.client.ui.form.fields.imagebox.AbstractImageField";
  public static final String AbstractIntegerField = "org.eclipse.scout.rt.client.ui.form.fields.integerfield.AbstractIntegerField";
  public static final String AbstractKeyStroke = "org.eclipse.scout.rt.client.ui.action.keystroke.AbstractKeyStroke";
  public static final String AbstractLabelField = "org.eclipse.scout.rt.client.ui.form.fields.labelfield.AbstractLabelField";
  public static final String AbstractListBox = "org.eclipse.scout.rt.client.ui.form.fields.listbox.AbstractListBox";
  public static final String AbstractLongField = "org.eclipse.scout.rt.client.ui.form.fields.longfield.AbstractLongField";
  public static final String AbstractLookupService = "org.eclipse.scout.rt.server.services.lookup.AbstractLookupService";
  public static final String AbstractMailField = "org.eclipse.scout.rt.client.ui.form.fields.mailfield.AbstractMailField";
  public static final String AbstractMatrixField = "org.eclipse.scout.rt.client.ui.form.fields.matrixfield.AbstractMatrixField";
  public static final String AbstractMenu = "org.eclipse.scout.rt.client.ui.action.menu.AbstractMenu";
  public static final String AbstractOkButton = "org.eclipse.scout.rt.client.ui.form.fields.button.AbstractOkButton";
  public static final String AbstractOutline = "org.eclipse.scout.rt.client.ui.desktop.outline.AbstractOutline";
  public static final String AbstractOutlineToolButton = "org.eclipse.scout.rt.client.ui.desktop.outline.AbstractOutlineToolButton";
  public static final String AbstractPageWithNodes = "org.eclipse.scout.rt.client.ui.desktop.outline.pages.AbstractPageWithNodes";
  public static final String AbstractPageWithTable = "org.eclipse.scout.rt.client.ui.desktop.outline.pages.AbstractPageWithTable";
  public static final String AbstractPlannerField = "org.eclipse.scout.rt.client.ui.form.fields.plannerfield.AbstractPlannerField";
  public static final String AbstractPropertyData = "org.eclipse.scout.rt.shared.data.form.properties.AbstractPropertyData";
  public static final String AbstractRadioButton = "org.eclipse.scout.rt.client.ui.form.fields.button.AbstractRadioButton";
  public static final String AbstractRadioButtonGroup = "org.eclipse.scout.rt.client.ui.form.fields.radiobuttongroup.AbstractRadioButtonGroup";
  public static final String AbstractResetButton = "org.eclipse.scout.rt.client.ui.form.fields.button.AbstractResetButton";
  public static final String AbstractSaveButton = "org.eclipse.scout.rt.client.ui.form.fields.button.AbstractSaveButton";
  public static final String AbstractSearchButton = "org.eclipse.scout.rt.client.ui.form.fields.button.AbstractSearchButton";
  public static final String AbstractSearchForm = "org.eclipse.scout.rt.client.ui.desktop.outline.pages.AbstractSearchForm";
  public static final String AbstractSequenceBox = "org.eclipse.scout.rt.client.ui.form.fields.sequencebox.AbstractSequenceBox";
  public static final String AbstractService = "org.eclipse.scout.service.AbstractService";
  public static final String AbstractSmartField = "org.eclipse.scout.rt.client.ui.form.fields.smartfield.AbstractSmartField";
  public static final String AbstractSMTPService = "org.eclipse.scout.rt.server.services.common.smtp.AbstractSMTPService";
  public static final String AbstractSqlLookupService = "org.eclipse.scout.rt.server.services.lookup.AbstractSqlLookupService";
  public static final String AbstractSqlService = "org.eclipse.scout.rt.server.services.common.jdbc.AbstractSqlService";

  public static final String AbstractStringField = "org.eclipse.scout.rt.client.ui.form.fields.stringfield.AbstractStringField";
  public static final String AbstractTabBox = "org.eclipse.scout.rt.client.ui.form.fields.tabbox.AbstractTabBox";
  public static final String AbstractTable = "org.eclipse.scout.rt.client.ui.basic.table.AbstractTable";
  public static final String AbstractTableField = "org.eclipse.scout.rt.client.ui.form.fields.tablefield.AbstractTableField";
  public static final String AbstractTableFieldData = "org.eclipse.scout.rt.shared.data.form.fields.tablefield.AbstractTableFieldData";
  public static final String AbstractTimeField = "org.eclipse.scout.rt.client.ui.form.fields.timefield.AbstractTimeField";
  public static final String AbstractToolButton = "org.eclipse.scout.rt.client.ui.action.tool.AbstractToolButton";
  public static final String AbstractTree = "org.eclipse.scout.rt.client.ui.basic.tree.AbstractTree";
  public static final String AbstractTreeBox = "org.eclipse.scout.rt.client.ui.form.fields.treebox.AbstractTreeBox";
  public static final String AbstractTreeField = "org.eclipse.scout.rt.client.ui.form.fields.treefield.AbstractTreeField";
  public static final String AbstractValueField = "org.eclipse.scout.rt.client.ui.form.fields.AbstractValueField";
  public static final String AbstractValueFieldData = "org.eclipse.scout.rt.shared.data.form.fields.AbstractValueFieldData";
  public static final String AbstractWizard = "org.eclipse.scout.rt.client.ui.wizard.AbstractWizard";
  public static final String AbstractWizardStep = "org.eclipse.scout.rt.client.ui.wizard.AbstractWizardStep";
  public static final String ACCESS = "org.eclipse.scout.rt.shared.services.common.security.ACCESS";
  public static final String BasicHierarchyPermission = "org.eclipse.scout.rt.shared.security.BasicHierarchyPermission";
  public static final String BasicPermission = "java.security.BasicPermission";
  public static final String FormData = "org.eclipse.scout.commons.annotations.FormData";
  public static final String FormData_UpdateOperation = "org.eclipse.scout.commons.annotations.FormData.UpdateOperation";
  public static final String BsiCaseLocalBeanProperty = "org.eclipse.scout.rt.shared.bsicase.BsiCaseLocalBeanProperty";
  public static final String BsiCaseOperation = "org.eclipse.scout.commons.annotations.ConfigOperation";
  public static final String BsiCaseOrder = "org.eclipse.scout.commons.annotations.Order";
  public static final String BsiCaseProperty = "org.eclipse.scout.commons.annotations.ConfigProperty";
  public static final String ClientProxyServiceFactory = "org.eclipse.scout.rt.client.services.ClientProxyServiceFactory";
  public static final String ClientServiceFactory = "org.eclipse.scout.rt.client.services.ClientServiceFactory";
  public static final String ConfigProperty = "org.eclipse.scout.commons.annotations.ConfigProperty";
  public static final String ConfigOperation = "org.eclipse.scout.commons.annotations.ConfigOperation";
  public static final String ConfigPropertyValue = "org.eclipse.scout.commons.annotations.ConfigPropertyValue";
  public static final String DefaultOutlineTableForm = "org.eclipse.scout.rt.client.ui.form.outline.DefaultOutlineTableForm";
  public static final String DefaultOutlineTreeForm = "org.eclipse.scout.rt.client.ui.form.outline.DefaultOutlineTreeForm";

  public static final String DynamicNls = "org.eclipse.scout.nls.DynamicNls";
  public static final String ExampleWorkflowTablePage = "org.eclipse.scout.rt.client.ui.desktop.outline.pages.workflow.ExampleWorkflowTablePage";
  public static final String IActivityMap = "org.eclipse.scout.rt.client.ui.basic.activitymap.IActivityMap";
  public static final String IBigDecimalField = "org.eclipse.scout.rt.client.ui.form.fields.bigdecimalfield.IBigDecimalField";
  public static final String IBookmarkStorageService = "org.eclipse.scout.rt.shared.services.common.bookmark.IBookmarkStorageService";
  public static final String IBooleanField = "org.eclipse.scout.rt.client.ui.form.fields.booleanfield.IBooleanField";
  public static final String IButton = "org.eclipse.scout.rt.client.ui.form.fields.button.IButton";
  public static final String ICalendar = "org.eclipse.scout.rt.client.ui.basic.calendar.ICalendar";
  public static final String ICalendarField = "org.eclipse.scout.rt.client.ui.form.fields.calendarfield.ICalendarField";
  public static final String ICalendarItem = "org.eclipse.scout.rt.shared.services.common.calendar.ICalendarItem";
  public static final String ICalendarItemProvider = "org.eclipse.scout.rt.client.ui.basic.calendar.provider.ICalendarItemProvider";
  public static final String ICalendarService = "org.eclipse.scout.rt.shared.services.common.calendar.ICalendarService";
  public static final String IChartBox = "org.eclipse.scout.rt.client.ui.form.fields.chartbox.IChartBox";
  public static final String IChartField = "org.eclipse.scout.rt.client.ui.form.fields.chartfield.IChartField";
  public static final String ICheckBox = "org.eclipse.scout.rt.client.ui.form.fields.checkbox.ICheckBox";
  public static final String IClientSession = "org.eclipse.scout.rt.client.IClientSession";
  public static final String ICode = "org.eclipse.scout.rt.shared.services.common.code.ICode";
  public static final String ICodeType = "org.eclipse.scout.rt.shared.services.common.code.ICodeType";
  public static final String IColumn = "org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn";
  public static final String IComposerAttribute = "org.eclipse.scout.rt.client.ui.form.fields.composer.attribute.IComposerAttribute";
  public static final String IComposerEntity = "org.eclipse.scout.rt.client.ui.form.fields.composer.entity.IComposerEntity";
  public static final String IComposerField = "org.eclipse.scout.rt.client.ui.form.fields.composer.IComposerField";
  public static final String ICompositeField = "org.eclipse.scout.rt.client.ui.form.fields.ICompositeField";
  public static final String ICustomField = "org.eclipse.scout.rt.client.ui.form.fields.customfield.ICustomField";
  public static final String IDateField = "org.eclipse.scout.rt.client.ui.form.fields.datefield.IDateField";
  public static final String IDesktop = "org.eclipse.scout.rt.client.ui.desktop.IDesktop";
  public static final String IDoubleField = "org.eclipse.scout.rt.client.ui.form.fields.doublefield.IDoubleField";
  public static final String IFileChooserField = "org.eclipse.scout.rt.client.ui.form.fields.filechooserfield.IFileChooserField";
  public static final String IForm = "org.eclipse.scout.rt.client.ui.form.IForm";
  public static final String IFormField = "org.eclipse.scout.rt.client.ui.form.fields.IFormField";
  public static final String IFormHandler = "org.eclipse.scout.rt.client.ui.form.IFormHandler";
  public static final String IGroupBox = "org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBox";
  public static final String IHtmlField = "org.eclipse.scout.rt.client.ui.form.fields.htmlfield.IHtmlField";
  public static final String IImageField = "org.eclipse.scout.rt.client.ui.form.fields.imagebox.IImageField";
  public static final String IIntegerField = "org.eclipse.scout.rt.client.ui.form.fields.integerfield.IIntegerField";
  public static final String IKeyStroke = "org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke";
  public static final String ILabelField = "org.eclipse.scout.rt.client.ui.form.fields.labelfield.ILabelField";
  public static final String IListBox = "org.eclipse.scout.rt.client.ui.form.fields.listbox.IListBox";
  public static final String ILongField = "org.eclipse.scout.rt.client.ui.form.fields.longfield.ILongField";
  public static final String ILookupService = "org.eclipse.scout.rt.shared.services.lookup.ILookupService";
  public static final String IMailField = "org.eclipse.scout.rt.client.ui.form.fields.mailfield.IMailField";

  public static final String IMatrixField = "org.eclipse.scout.rt.client.ui.form.fields.matrixfield.IMatrixField";
  public static final String IMenu = "org.eclipse.scout.rt.client.ui.action.menu.IMenu";
  public static final String IOutline = "org.eclipse.scout.rt.client.ui.desktop.outline.IOutline";
  public static final String IPage = "org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage";
  public static final String IPageWithNodes = "org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithNodes";
  public static final String IPageWithTable = "org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithTable";
  public static final String IPlannerField = "org.eclipse.scout.rt.client.ui.form.fields.plannerfield.IPlannerField";
  public static final String IPropertyObserver = "org.eclipse.scout.commons.beans.IPropertyObserver";
  public static final String IRadioButtonGroup = "org.eclipse.scout.rt.client.ui.form.fields.radiobuttongroup.IRadioButtonGroup";
  public static final String IScoutLogger = "org.eclipse.scout.commons.logger.IScoutLogger";
  public static final String ISearchForm = "org.eclipse.scout.rt.client.ui.desktop.outline.pages.ISearchForm";
  public static final String ISequenceBox = "org.eclipse.scout.rt.client.ui.form.fields.sequencebox.ISequenceBox";
  public static final String IServerSession = "org.eclipse.scout.rt.server.IServerSession";
  public static final String IService = "org.eclipse.scout.service.IService";
  public static final String ISmartField = "org.eclipse.scout.rt.client.ui.form.fields.smartfield.ISmartField";
  public static final String ISMTPService = "org.eclipse.scout.rt.server.services.common.smtp.ISMTPService";
  public static final String ISplitBox = "org.eclipse.scout.rt.client.ui.form.fields.splitbox.ISplitBox";
  public static final String ISqlService = "org.eclipse.scout.rt.server.services.common.jdbc.ISqlService";
  public static final String IStringField = "org.eclipse.scout.rt.client.ui.form.fields.stringfield.IStringField";
  public static final String ITabBox = "org.eclipse.scout.rt.client.ui.form.fields.tabbox.ITabBox";
  public static final String ITable = "org.eclipse.scout.rt.client.ui.basic.table.ITable";
  public static final String ITableRow = "org.eclipse.scout.rt.client.ui.basic.table.ITableRow";
  public static final String ITableField = "org.eclipse.scout.rt.client.ui.form.fields.tablefield.ITableField";
  public static final String ITimeField = "org.eclipse.scout.rt.client.ui.form.fields.timefield.ITimeField";
  public static final String IToolButton = "org.eclipse.scout.rt.client.ui.action.tool.IToolButton";
  public static final String ITree = "org.eclipse.scout.rt.client.ui.basic.tree.ITree";
  public static final String ITreeBox = "org.eclipse.scout.rt.client.ui.form.fields.treebox.ITreeBox";
  public static final String ITreeField = "org.eclipse.scout.rt.client.ui.form.fields.treefield.ITreeField";
  public static final String ITreeNode = "org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode";
  public static final String IValueField = "org.eclipse.scout.rt.client.ui.form.fields.IValueField";
  public static final String IViewButton = "org.eclipse.scout.rt.client.ui.action.view.IViewButton";
  public static final String IWizard = "org.eclipse.scout.rt.client.ui.wizard.IWizard";
  public static final String IWizardStep = "org.eclipse.scout.rt.client.ui.wizard.IWizardStep";
  public static final String LocalLookupCall = "org.eclipse.scout.rt.shared.services.lookup.LocalLookupCall";
  public static final String LookupCall = "org.eclipse.scout.rt.shared.services.lookup.LookupCall";
  public static final String LookupRow = "org.eclipse.scout.rt.shared.services.lookup.LookupRow";
  public static final String Order = "org.eclipse.scout.commons.annotations.Order";
  public static final String ScoutTexts = "org.eclipse.scout.rt.shared.ScoutTexts";
  public static final String SearchFilter = "org.eclipse.scout.rt.shared.services.common.jdbc.SearchFilter";
  public static final String ServerServiceFactory = "org.eclipse.scout.rt.server.services.ServerServiceFactory";
  public static final String SERVICES = "org.eclipse.scout.service.SERVICES";
  public static final String ProcessingException = "org.eclipse.scout.commons.exception.ProcessingException";
  public static final String ValidationRule = "org.eclipse.scout.rt.shared.data.form.ValidationRule";
  public static final String VetoException = "org.eclipse.scout.commons.exception.VetoException";

  public static final String IBigDecimalColumn = "org.eclipse.scout.rt.client.ui.basic.table.columns.IBigDecimalColumn";
  public static final String IBooleanColumn = "org.eclipse.scout.rt.client.ui.basic.table.columns.IBooleanColumn";
  public static final String IDateColumn = "org.eclipse.scout.rt.client.ui.basic.table.columns.IDateColumn";
  public static final String IDoubleColumn = "org.eclipse.scout.rt.client.ui.basic.table.columns.IDoubleColumn";
  public static final String IIntegerColumn = "org.eclipse.scout.rt.client.ui.basic.table.columns.IIntegerColumn";
  public static final String ILongColumn = "org.eclipse.scout.rt.client.ui.basic.table.columns.ILongColumn";
  public static final String ISmartColumn = "org.eclipse.scout.rt.client.ui.basic.table.columns.ISmartColumn";
  public static final String IStringColumn = "org.eclipse.scout.rt.client.ui.basic.table.columns.IStringColumn";
  public static final String ITimeColumn = "org.eclipse.scout.rt.client.ui.basic.table.columns.ITimeColumn";
  public static final String CopyWidthsOfColumnsMenu = "org.eclipse.scout.rt.client.ui.basic.table.menus.CopyWidthsOfColumnsMenu";

  public static final String ResourceServlet = "org.eclipse.scout.rt.server.ResourceServlet";
//CHECKSTYLE:ON
}
